/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.helper.InventoryHelper;

public class BlockRuneAltar
extends BlockModWaterloggable
implements EntityBlock {
    private static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape BOTTOM = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    private static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)TOP, (VoxelShape)BOTTOM, (BooleanOp)BooleanOp.f_82695_);

    public BlockRuneAltar(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        TileRuneAltar altar = (TileRuneAltar)world.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            if (altar.manaToGet == 0) {
                InventoryHelper.withdrawFromInventory(altar, player);
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
                return InteractionResult.SUCCESS;
            }
        } else {
            if (altar.isEmpty() && stack.m_41619_()) {
                altar.trySetLastRecipe(player);
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
                return InteractionResult.SUCCESS;
            }
            if (!stack.m_41619_()) {
                boolean result = altar.addItem(player, stack, hand);
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
                return result ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = world.m_7702_(pos);
            if (be instanceof TileSimpleInventory) {
                TileSimpleInventory inventory = (TileSimpleInventory)be;
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)inventory.getItemHandler());
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileRuneAltar(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return BlockRuneAltar.createTickerHelper(type, ModTiles.RUNE_ALTAR, TileRuneAltar::clientTick);
        }
        return BlockRuneAltar.createTickerHelper(type, ModTiles.RUNE_ALTAR, TileRuneAltar::serverTick);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        TileRuneAltar altar = (TileRuneAltar)world.m_7702_(pos);
        return altar.signal;
    }
}

