/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.recipe.ICustomApothecaryColor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.xplat.BotaniaConfig;

public class BlockModMushroom
extends MushroomBlock
implements ICustomApothecaryColor {
    private static final VoxelShape SHAPE = BlockModMushroom.m_49796_((double)4.8, (double)0.0, (double)4.8, (double)12.8, (double)16.0, (double)12.8);
    public final DyeColor color;

    public BlockModMushroom(DyeColor color, BlockBehaviour.Properties builder) {
        super(builder, BlockModMushroom::getDummyFeature);
        this.color = color;
    }

    private static ConfiguredFeature<NoneFeatureConfiguration, Feature<NoneFeatureConfiguration>> getDummyFeature() {
        Feature<NoneFeatureConfiguration> feature = new Feature<NoneFeatureConfiguration>(NoneFeatureConfiguration.f_67815_){

            public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
                return false;
            }
        };
        return new ConfiguredFeature((Feature)feature, (FeatureConfiguration)NoneFeatureConfiguration.f_67816_);
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (!blockstate.m_60620_((Tag)BlockTags.f_13057_)) {
            return this.m_6266_(blockstate, (BlockGetter)worldIn, blockpos);
        }
        return true;
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        int hex = ColorHelper.getColorValue(this.color);
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        if (rand.nextDouble() < BotaniaConfig.client().flowerParticleFrequency() * 0.25) {
            SparkleParticleData data = SparkleParticleData.sparkle(rand.nextFloat(), (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
            world.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + 0.3 + (double)rand.nextFloat() * 0.5, (double)pos.m_123342_() + 0.5 + (double)rand.nextFloat() * 0.5, (double)pos.m_123343_() + 0.3 + (double)rand.nextFloat() * 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getParticleColor(ItemStack stack) {
        return ColorHelper.getColorValue(this.color);
    }
}

