/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileIncensePlate;

public class BlockIncensePlate
extends BlockModWaterloggable
implements EntityBlock {
    private static final VoxelShape X_SHAPE = BlockIncensePlate.m_49796_((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)1.0, (double)14.0);
    private static final VoxelShape Z_SHAPE = BlockIncensePlate.m_49796_((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)1.0, (double)10.0);

    protected BlockIncensePlate(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TileIncensePlate plate = (TileIncensePlate)world.m_7702_(pos);
        ItemStack plateStack = plate.getItemHandler().m_8020_(0);
        ItemStack stack = player.m_21120_(hand);
        boolean did = false;
        if (world.f_46443_) {
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && !plateStack.m_41619_() && !plate.burning && !stack.m_41619_() && stack.m_150930_(Items.f_42409_)) {
                plate.spawnSmokeParticles();
            }
            return InteractionResult.SUCCESS;
        }
        if (plateStack.m_41619_() && plate.acceptsItem(stack)) {
            plate.getItemHandler().m_6836_(0, stack.m_41777_());
            stack.m_41774_(1);
            did = true;
        } else if (!plateStack.m_41619_() && !plate.burning) {
            if (!stack.m_41619_() && stack.m_150930_(Items.f_42409_)) {
                plate.ignite();
                stack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(hand));
                did = true;
            } else {
                player.m_150109_().m_150079_(plateStack);
                plate.getItemHandler().m_6836_(0, ItemStack.f_41583_);
                did = true;
            }
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
        }
        return did ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_().m_122424_());
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return ((TileIncensePlate)world.m_7702_((BlockPos)pos)).comparatorOutput;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        if (((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_() == Direction.Axis.X) {
            return X_SHAPE;
        }
        return Z_SHAPE;
    }

    @Nonnull
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new TileIncensePlate(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockIncensePlate.createTickerHelper(type, ModTiles.INCENSE_PLATE, TileIncensePlate::commonTick);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        BlockEntity block;
        if (!state.m_60713_(newState.m_60734_()) && (block = world.m_7702_(pos)) instanceof TileIncensePlate) {
            TileIncensePlate plate = (TileIncensePlate)block;
            if (!plate.burning) {
                Containers.m_19002_((Level)world, (BlockPos)pos, (Container)plate.getItemHandler());
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_5581_(@Nonnull Level level, @Nonnull BlockState blockState, @Nonnull BlockHitResult hit, @Nonnull Projectile projectile) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && projectile.m_142265_(level, hit.m_82425_()) && projectile.m_6060_() && (blockEntity = level.m_7702_(hit.m_82425_())) instanceof TileIncensePlate) {
            TileIncensePlate plate = (TileIncensePlate)blockEntity;
            plate.ignite();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(plate);
        }
    }
}

