/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.crafting;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICustomCraftingCategoryExtension;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.common.crafting.recipe.CompositeLensRecipe;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class CompositeLensRecipeWrapper
implements ICustomCraftingCategoryExtension {
    private final List<List<ItemStack>> inputs;
    private final List<Item> lenses;

    public CompositeLensRecipeWrapper(CompositeLensRecipe recipe) {
        List lensStacks = ItemTags.m_13193_().m_7689_(ResourceLocationHelper.prefix("lens")).m_6497_().stream().map(ItemStack::new).filter(s -> !((ItemLens)s.m_41720_()).isControlLens((ItemStack)s)).filter(s -> ((ItemLens)s.m_41720_()).isCombinable((ItemStack)s)).collect(Collectors.toList());
        this.lenses = lensStacks.stream().map(ItemStack::m_41720_).collect(Collectors.toList());
        this.inputs = ImmutableList.of(lensStacks, (Object)ImmutableList.of((Object)new ItemStack((ItemLike)Items.f_42518_)), lensStacks);
    }

    public void setIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IIngredients ingredients) {
        ItemStack stack;
        int idx;
        recipeLayout.getItemStacks().set(ingredients);
        recipeLayout.setShapeless();
        IFocus focus = recipeLayout.getFocus(VanillaTypes.ITEM);
        if (focus != null && (idx = this.lenses.indexOf((stack = (ItemStack)focus.getValue()).m_41720_())) != -1) {
            this.setLenses(recipeLayout, idx, idx);
            return;
        }
        this.setLenses(recipeLayout, 1, this.lenses.size() - 1);
    }

    private void setLenses(IRecipeLayout recipeLayout, int start, int end) {
        ArrayList<ItemStack> firstInput = new ArrayList<ItemStack>();
        ArrayList<ItemStack> secondInput = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        if (end >= this.lenses.size()) {
            end = this.lenses.size() - 1;
        }
        for (int i = start; i <= end; ++i) {
            ItemStack firstLens = new ItemStack((ItemLike)this.lenses.get(i));
            for (Item secondLens : this.lenses) {
                if (secondLens == firstLens.m_41720_()) continue;
                ItemStack secondLensStack = new ItemStack((ItemLike)secondLens);
                if (!((ItemLens)firstLens.m_41720_()).canCombineLenses(firstLens, secondLensStack)) continue;
                firstInput.add(firstLens);
                secondInput.add(secondLensStack);
                outputs.add(((ItemLens)firstLens.m_41720_()).setCompositeLens(firstLens.m_41777_(), secondLensStack));
            }
        }
        recipeLayout.getItemStacks().set(1, firstInput);
        recipeLayout.getItemStacks().set(3, secondInput);
        recipeLayout.getItemStacks().set(0, outputs);
    }
}

