/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec2;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.client.integration.jei.PetalApothecaryRecipeCategory;
import vazkii.botania.client.integration.jei.TerraPlateDrawable;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class TerraPlateRecipeCategory
implements IRecipeCategory<ITerraPlateRecipe> {
    public static final ResourceLocation UID = ResourceLocationHelper.prefix("terra_plate");
    private final Component localizedName;
    private final IDrawable background;
    private final IDrawable overlay;
    private final IDrawable icon;
    private final IDrawable terraPlate;

    public TerraPlateRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation location = ResourceLocationHelper.prefix("textures/gui/terrasteel_jei_overlay.png");
        this.background = guiHelper.createBlankDrawable(114, 131);
        this.overlay = guiHelper.createDrawable(location, 42, 29, 64, 64);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.terraPlate));
        this.localizedName = new TranslatableComponent("botania.nei.terraPlate");
        IDrawable livingrock = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)ModBlocks.livingrock));
        this.terraPlate = new TerraPlateDrawable(livingrock, livingrock, guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Blocks.f_50060_)));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends ITerraPlateRecipe> getRecipeClass() {
        return ITerraPlateRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@Nonnull ITerraPlateRecipe recipe, @Nonnull PoseStack ms, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(ms, 25, 14);
        HUDHandler.renderManaBar(ms, 6, 126, 255, 0.75f, recipe.getMana(), 100000);
        this.terraPlate.draw(ms, 35, 92);
        RenderSystem.m_69461_();
    }

    public void setIngredients(@Nonnull ITerraPlateRecipe recipe, @Nonnull IIngredients iIngredients) {
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>();
        for (Ingredient ingr : recipe.m_7527_()) {
            list.add(Arrays.asList(ingr.m_43908_()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, list);
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)recipe.m_8043_());
    }

    public void setRecipe(@Nonnull IRecipeLayout layout, @Nonnull ITerraPlateRecipe recipe, @Nonnull IIngredients ingredients) {
        layout.getItemStacks().init(0, false, 48, 37);
        layout.getItemStacks().set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        int index = 1;
        double angleBetweenEach = 360.0 / (double)ingredients.getInputs(VanillaTypes.ITEM).size();
        Vec2 point = new Vec2(48.0f, 5.0f);
        Vec2 center = new Vec2(48.0f, 37.0f);
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            layout.getItemStacks().init(index, true, (int)point.f_82470_, (int)point.f_82471_);
            layout.getItemStacks().set(index, o);
            ++index;
            point = PetalApothecaryRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        layout.getItemStacks().init(index, true, 48, 92);
        layout.getItemStacks().set(index, new ItemStack((ItemLike)ModBlocks.terraPlate));
    }
}

