/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.subtile;

import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

public class RadiusDescriptor {
    private final BlockPos subtileCoords;

    public RadiusDescriptor(BlockPos subtileCoords) {
        this.subtileCoords = subtileCoords;
    }

    public BlockPos getSubtileCoords() {
        return this.subtileCoords;
    }

    public boolean isCircle() {
        return false;
    }

    public double getCircleRadius() {
        return 0.0;
    }

    public AABB getAABB() {
        return null;
    }

    public static class Square
    extends Rectangle {
        public Square(BlockPos subtileCoords, int expand) {
            super(subtileCoords, new AABB(subtileCoords.m_142082_(-expand, 0, -expand), subtileCoords.m_142082_(expand + 1, 0, expand + 1)));
        }
    }

    public static class Rectangle
    extends RadiusDescriptor {
        final AABB aabb;

        public Rectangle(BlockPos subtileCoords, AABB aabb) {
            super(subtileCoords);
            this.aabb = aabb;
        }

        @Override
        public AABB getAABB() {
            return this.aabb;
        }
    }

    public static class Circle
    extends RadiusDescriptor {
        final double radius;

        public Circle(BlockPos subtileCoords, double radius) {
            super(subtileCoords);
            this.radius = radius;
        }

        @Override
        public boolean isCircle() {
            return true;
        }

        @Override
        public double getCircleRadius() {
            return this.radius;
        }
    }
}

