/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries.forge;

import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import dev.architectury.platform.forge.EventBuses;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarBuilder;
import dev.architectury.registry.registries.Registries;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.architectury.registry.registries.options.RegistrarOption;
import dev.architectury.registry.registries.options.StandardRegistrarOption;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class RegistriesImpl {
    public static Registries.RegistryProvider _get(String modId) {
        return new RegistryProviderImpl(modId);
    }

    public static <T> ResourceLocation getId(T t, ResourceKey<Registry<T>> registryKey) {
        if (t instanceof IForgeRegistryEntry) {
            return ((IForgeRegistryEntry)t).getRegistryName();
        }
        return null;
    }

    public static <T> ResourceLocation getId(T t, Registry<T> registry) {
        if (t instanceof IForgeRegistryEntry) {
            return ((IForgeRegistryEntry)t).getRegistryName();
        }
        return null;
    }

    public static class RegistryProviderImpl
    implements Registries.RegistryProvider {
        private final String modId;
        private final java.util.function.Supplier<IEventBus> eventBus;
        private final Table<Type, RegistryObject<?>, java.util.function.Supplier<? extends IForgeRegistryEntry<?>>> registry = HashBasedTable.create();
        private final Multimap<ResourceKey<Registry<?>>, Consumer<Registrar<?>>> listeners = HashMultimap.create();

        public RegistryProviderImpl(String modId) {
            this.modId = modId;
            this.eventBus = Suppliers.memoize(() -> {
                IEventBus eventBus = EventBuses.getModEventBus(modId).orElseThrow(() -> new IllegalStateException("Can't get event bus for mod '" + modId + "' because it was not registered!"));
                eventBus.register((Object)new EventListener());
                return eventBus;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateEventBus() {
            java.util.function.Supplier<IEventBus> supplier = this.eventBus;
            synchronized (supplier) {
                this.eventBus.get();
            }
        }

        @Override
        public <T> Registrar<T> get(ResourceKey<Registry<T>> registryKey) {
            this.updateEventBus();
            return this.get((IForgeRegistry)RegistryManager.ACTIVE.getRegistry(registryKey.m_135782_()));
        }

        public <T> Registrar<T> get(IForgeRegistry registry) {
            this.updateEventBus();
            return new ForgeBackedRegistryImpl(this.registry, registry);
        }

        @Override
        public <T> Registrar<T> get(Registry<T> registry) {
            this.updateEventBus();
            return new VanillaBackedRegistryImpl<T>(registry);
        }

        @Override
        public <T> void forRegistry(ResourceKey<Registry<T>> key, Consumer<Registrar<T>> consumer) {
            this.listeners.put(key, consumer);
        }

        @Override
        public <T> RegistrarBuilder<T> builder(Class<T> type, ResourceLocation registryId) {
            return new RegistryBuilderWrapper(this, new RegistryBuilder().setName(registryId).setType(type));
        }

        public class EventListener {
            @SubscribeEvent
            public void handleEvent(RegistryEvent.Register event) {
                IForgeRegistry registry = event.getRegistry();
                Registrar archRegistry = RegistryProviderImpl.this.get(registry);
                for (Map.Entry row : RegistryProviderImpl.this.registry.rowMap().entrySet()) {
                    if (row.getKey() != event.getGenericType()) continue;
                    for (Map.Entry entry : ((Map)row.getValue()).entrySet()) {
                        registry.register((IForgeRegistryEntry)((java.util.function.Supplier)entry.getValue()).get());
                        ((RegistryObject)entry.getKey()).updateReference(registry);
                    }
                }
                for (Map.Entry entry : RegistryProviderImpl.this.listeners.entries()) {
                    if (!((ResourceKey)entry.getKey()).m_135782_().equals((Object)registry.getRegistryName())) continue;
                    ((Consumer)entry.getValue()).accept(archRegistry);
                }
            }
        }
    }

    public static class ForgeBackedRegistryImpl<T extends IForgeRegistryEntry<T>>
    implements Registrar<T> {
        private IForgeRegistry<T> delegate;
        private Table<Type, RegistryObject<?>, java.util.function.Supplier<? extends IForgeRegistryEntry<?>>> registry;

        public ForgeBackedRegistryImpl(Table<Type, RegistryObject<?>, java.util.function.Supplier<? extends IForgeRegistryEntry<?>>> registry, IForgeRegistry<T> delegate) {
            this.registry = registry;
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public RegistrySupplier<T> delegate(final ResourceLocation id) {
            Supplier value = Suppliers.memoize(() -> this.get(id));
            return new RegistrySupplier<T>(){
                final /* synthetic */ java.util.function.Supplier val$value;
                {
                    this.val$value = supplier;
                }

                @Override
                @NotNull
                public ResourceLocation getRegistryId() {
                    return delegate.getRegistryName();
                }

                @Override
                @NotNull
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.contains(id);
                }

                @Override
                public T get() {
                    return (IForgeRegistryEntry)this.val$value.get();
                }

                public int hashCode() {
                    return Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        @NotNull
        public <E extends T> RegistrySupplier<E> register(final ResourceLocation id, java.util.function.Supplier<E> supplier) {
            final RegistryObject registryObject = RegistryObject.of((ResourceLocation)id, this.delegate);
            this.registry.put((Object)this.delegate.getRegistrySuperType(), (Object)registryObject, () -> (IForgeRegistryEntry)((IForgeRegistryEntry)supplier.get()).setRegistryName(id));
            return new RegistrySupplier<E>(){

                @Override
                @NotNull
                public ResourceLocation getRegistryId() {
                    return delegate.getRegistryName();
                }

                @Override
                @NotNull
                public ResourceLocation getId() {
                    return registryObject.getId();
                }

                @Override
                public boolean isPresent() {
                    return registryObject.isPresent();
                }

                @Override
                public E get() {
                    return registryObject.get();
                }

                public int hashCode() {
                    return Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        @Nullable
        public ResourceLocation getId(T obj) {
            return this.delegate.getKey(obj);
        }

        @Override
        public int getRawId(T obj) {
            return ((ForgeRegistry)this.delegate).getID(obj);
        }

        @Override
        public Optional<ResourceKey<T>> getKey(T t) {
            return Optional.ofNullable(this.getId(t)).map(id -> ResourceKey.m_135785_(this.key(), (ResourceLocation)id));
        }

        @Override
        @Nullable
        public T get(ResourceLocation id) {
            return (T)this.delegate.getValue(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)((ForgeRegistry)this.delegate).getValue(rawId);
        }

        @Override
        public boolean contains(ResourceLocation resourceLocation) {
            return this.delegate.containsKey(resourceLocation);
        }

        @Override
        public boolean containsValue(T t) {
            return this.delegate.containsValue(t);
        }

        @Override
        public Set<ResourceLocation> getIds() {
            return this.delegate.getKeys();
        }

        @Override
        public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
            return this.delegate.getEntries();
        }

        @Override
        public ResourceKey<? extends Registry<T>> key() {
            return ResourceKey.m_135788_((ResourceLocation)this.delegate.getRegistryName());
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }
    }

    public static class VanillaBackedRegistryImpl<T>
    implements Registrar<T> {
        private Registry<T> delegate;

        public VanillaBackedRegistryImpl(Registry<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        @NotNull
        public RegistrySupplier<T> delegate(final ResourceLocation id) {
            Supplier value = Suppliers.memoize(() -> this.get(id));
            return new RegistrySupplier<T>(){
                final /* synthetic */ java.util.function.Supplier val$value;
                {
                    this.val$value = supplier;
                }

                @Override
                @NotNull
                public ResourceLocation getRegistryId() {
                    return delegate.m_123023_().m_135782_();
                }

                @Override
                @NotNull
                public ResourceLocation getId() {
                    return id;
                }

                @Override
                public boolean isPresent() {
                    return this.contains(id);
                }

                @Override
                public T get() {
                    return this.val$value.get();
                }

                public int hashCode() {
                    return Objects.hashCode((Object[])new Object[]{this.getRegistryId(), this.getId()});
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof RegistrySupplier)) {
                        return false;
                    }
                    RegistrySupplier other = (RegistrySupplier)obj;
                    return other.getRegistryId().equals((Object)this.getRegistryId()) && other.getId().equals((Object)this.getId());
                }

                public String toString() {
                    return this.getRegistryId().toString() + "@" + id.toString();
                }
            };
        }

        @Override
        @NotNull
        public <E extends T> RegistrySupplier<E> register(ResourceLocation id, java.util.function.Supplier<E> supplier) {
            Registry.m_122965_(this.delegate, (ResourceLocation)id, supplier.get());
            return this.delegate(id);
        }

        @Override
        @Nullable
        public ResourceLocation getId(T obj) {
            return this.delegate.m_7981_(obj);
        }

        @Override
        public int getRawId(T obj) {
            return this.delegate.m_7447_(obj);
        }

        @Override
        public Optional<ResourceKey<T>> getKey(T t) {
            return this.delegate.m_7854_(t);
        }

        @Override
        @Nullable
        public T get(ResourceLocation id) {
            return (T)this.delegate.m_7745_(id);
        }

        @Override
        public T byRawId(int rawId) {
            return (T)this.delegate.m_7942_(rawId);
        }

        @Override
        public boolean contains(ResourceLocation resourceLocation) {
            return this.delegate.m_6566_().contains(resourceLocation);
        }

        @Override
        public boolean containsValue(T t) {
            return this.delegate.m_7854_(t).isPresent();
        }

        @Override
        public Set<ResourceLocation> getIds() {
            return this.delegate.m_6566_();
        }

        @Override
        public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
            return this.delegate.m_6579_();
        }

        @Override
        public ResourceKey<? extends Registry<T>> key() {
            return this.delegate.m_123023_();
        }

        @Override
        public Iterator<T> iterator() {
            return this.delegate.iterator();
        }
    }

    public static class RegistryBuilderWrapper<T>
    implements RegistrarBuilder<T> {
        @NotNull
        private final RegistryProviderImpl provider;
        @NotNull
        private final RegistryBuilder<?> builder;
        private boolean saveToDisk = false;
        private boolean syncToClients = false;

        public RegistryBuilderWrapper(@NotNull RegistryProviderImpl provider, @NotNull RegistryBuilder<?> builder) {
            this.provider = provider;
            this.builder = builder;
        }

        @Override
        @NotNull
        public Registrar<T> build() {
            if (!this.syncToClients) {
                this.builder.disableSync();
            }
            if (!this.saveToDisk) {
                this.builder.disableSaving();
            }
            return this.provider.get(this.builder.create());
        }

        @Override
        @NotNull
        public RegistrarBuilder<T> option(@NotNull RegistrarOption option) {
            if (option == StandardRegistrarOption.SAVE_TO_DISC) {
                this.saveToDisk = true;
            } else if (option == StandardRegistrarOption.SYNC_TO_CLIENTS) {
                this.syncToClients = true;
            }
            return this;
        }
    }
}

