/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.forge;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="architectury")
public class ReloadListenerRegistryImpl {
    private static List<PreparableReloadListener> serverDataReloadListeners = Lists.newArrayList();

    public static void register(PackType type, PreparableReloadListener listener) {
        if (type == PackType.SERVER_DATA) {
            serverDataReloadListeners.add(listener);
        } else if (type == PackType.CLIENT_RESOURCES) {
            ReloadListenerRegistryImpl.registerClient(listener);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void registerClient(PreparableReloadListener listener) {
        ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_(listener);
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        for (PreparableReloadListener listener : serverDataReloadListeners) {
            event.addListener(listener);
        }
    }
}

