/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.platform.forge;

import dev.architectury.platform.Mod;
import dev.architectury.utils.Env;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformImpl {
    private static final Map<String, Mod> mods = new ConcurrentHashMap<String, Mod>();

    public static Path getGameFolder() {
        return FMLPaths.GAMEDIR.get();
    }

    public static Path getConfigFolder() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static Path getModsFolder() {
        return FMLPaths.MODSDIR.get();
    }

    public static Env getEnvironment() {
        return Env.fromPlatform(PlatformImpl.getEnv());
    }

    public static Dist getEnv() {
        return FMLEnvironment.dist;
    }

    public static boolean isModLoaded(String id) {
        return ModList.get().isLoaded(id);
    }

    public static Mod getMod(String id) {
        return mods.computeIfAbsent(id, ModImpl::new);
    }

    public static Collection<Mod> getMods() {
        for (IModInfo mod : ModList.get().getMods()) {
            PlatformImpl.getMod(mod.getModId());
        }
        return mods.values();
    }

    public static Collection<String> getModIds() {
        return ModList.get().getMods().stream().map(IModInfo::getModId).collect(Collectors.toList());
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    private static class ModImpl
    implements Mod {
        private final ModContainer container;
        private final IModInfo info;

        public ModImpl(String id) {
            this.container = (ModContainer)ModList.get().getModContainerById(id).get();
            this.info = ModList.get().getMods().stream().filter(modInfo -> Objects.equals(modInfo.getModId(), id)).findAny().get();
        }

        @Override
        @Nonnull
        public String getModId() {
            return this.info.getModId();
        }

        @Override
        @Nonnull
        public String getVersion() {
            return this.info.getVersion().toString();
        }

        @Override
        @Nonnull
        public String getName() {
            return this.info.getDisplayName();
        }

        @Override
        @Nonnull
        public String getDescription() {
            return this.info.getDescription();
        }

        @Override
        @NotNull
        public Optional<String> getLogoFile(int i) {
            return this.info.getLogoFile();
        }

        @Override
        @NotNull
        public Path getFilePath() {
            return this.info.getOwningFile().getFile().getFilePath();
        }

        @Override
        @NotNull
        public Collection<String> getAuthors() {
            Optional<String> optional = this.info.getConfig().getConfigElement(new String[]{"authors"}).map(String::valueOf);
            return optional.isPresent() ? Collections.singleton(optional.get()) : Collections.emptyList();
        }

        @Override
        @Nullable
        public Collection<String> getLicense() {
            return Collections.singleton(this.info.getOwningFile().getLicense());
        }

        @Override
        @NotNull
        public Optional<String> getHomepage() {
            return this.info.getConfig().getConfigElement(new String[]{"displayURL"}).map(String::valueOf);
        }

        @Override
        @NotNull
        public Optional<String> getSources() {
            return Optional.empty();
        }

        @Override
        @NotNull
        public Optional<String> getIssueTracker() {
            IModFileInfo owningFile = this.info.getOwningFile();
            if (owningFile instanceof ModFileInfo) {
                ModFileInfo info = (ModFileInfo)owningFile;
                return Optional.ofNullable(info.getIssueURL()).map(URL::toString);
            }
            return Optional.empty();
        }

        @Override
        public void registerConfigurationScreen(Mod.ConfigurationScreenProvider configurationScreenProvider) {
            this.container.registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((minecraft, screen) -> configurationScreenProvider.provide((Screen)screen)));
        }
    }
}

