/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.hooks.fluid.forge;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidStackHooksImpl {
    public static Component getName(FluidStack stack) {
        return stack.getFluid().getAttributes().getDisplayName(FluidStackHooksForge.toForge(stack));
    }

    public static String getTranslationKey(FluidStack stack) {
        return stack.getFluid().getAttributes().getTranslationKey(FluidStackHooksForge.toForge(stack));
    }

    public static FluidStack read(FriendlyByteBuf buf) {
        return FluidStackHooksForge.fromForge(net.minecraftforge.fluids.FluidStack.readFromPacket((FriendlyByteBuf)buf));
    }

    public static void write(FluidStack stack, FriendlyByteBuf buf) {
        FluidStackHooksForge.toForge(stack).writeToPacket(buf);
    }

    public static FluidStack read(CompoundTag tag) {
        return FluidStackHooksForge.fromForge(net.minecraftforge.fluids.FluidStack.loadFluidStackFromNBT((CompoundTag)tag));
    }

    public static CompoundTag write(FluidStack stack, CompoundTag tag) {
        return FluidStackHooksForge.toForge(stack).writeToNBT(tag);
    }

    public static long bucketAmount() {
        return 1000L;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static TextureAtlasSprite getStillTexture(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @NotNull FluidState state) {
        if (state.m_76152_() == Fluids.f_76191_) {
            return null;
        }
        ResourceLocation texture = state.m_76152_().getAttributes().getStillTexture(level, pos);
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static TextureAtlasSprite getStillTexture(@NotNull FluidStack stack) {
        if (stack.getFluid() == Fluids.f_76191_) {
            return null;
        }
        ResourceLocation texture = stack.getFluid().getAttributes().getStillTexture(FluidStackHooksForge.toForge(stack));
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static TextureAtlasSprite getStillTexture(@NotNull Fluid fluid) {
        if (fluid == Fluids.f_76191_) {
            return null;
        }
        ResourceLocation texture = fluid.getAttributes().getStillTexture();
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static TextureAtlasSprite getFlowingTexture(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @NotNull FluidState state) {
        if (state.m_76152_() == Fluids.f_76191_) {
            return null;
        }
        ResourceLocation texture = state.m_76152_().getAttributes().getFlowingTexture(level, pos);
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static TextureAtlasSprite getFlowingTexture(@NotNull FluidStack stack) {
        if (stack.getFluid() == Fluids.f_76191_) {
            return null;
        }
        ResourceLocation texture = stack.getFluid().getAttributes().getFlowingTexture(FluidStackHooksForge.toForge(stack));
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public static TextureAtlasSprite getFlowingTexture(@NotNull Fluid fluid) {
        if (fluid == Fluids.f_76191_) {
            return null;
        }
        ResourceLocation texture = fluid.getAttributes().getFlowingTexture();
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(texture);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @NotNull FluidState state) {
        if (state.m_76152_() == Fluids.f_76191_) {
            return -1;
        }
        return state.m_76152_().getAttributes().getColor(level, pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(@NotNull FluidStack stack) {
        if (stack.getFluid() == Fluids.f_76191_) {
            return -1;
        }
        return stack.getFluid().getAttributes().getColor(FluidStackHooksForge.toForge(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(@NotNull Fluid fluid) {
        if (fluid == Fluids.f_76191_) {
            return -1;
        }
        return fluid.getAttributes().getColor();
    }
}

