/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.misc;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChatPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import shetiphian.core.client.Localization;
import shetiphian.core.common.NameHelper;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

public class ChestInfoHelper {
    private static final ChestInfoHelper INSTANCE = new ChestInfoHelper();

    public static void getHUDInfo(List<String> tooltip, TileEntityEnderChest tile) {
        if (tile == null) {
            return;
        }
        tooltip.add(ChestInfoHelper.formatChestOwner(tile.getOwnerName(), true));
        tooltip.add(" " + Localization.get((String)"info.enderchests.chest.code.txt") + " " + tile.getCode());
    }

    public static void sendCapacityInfo(Player player, TileEntityEnderChest tankTile) {
        Object message = INSTANCE.localize("info.enderchests.chest.capacity.txt");
        message = (String)message + " " + ChestHelper.getCapacity(player.m_20193_(), tankTile.getOwnerID(), tankTile.getCode());
        INSTANCE.sendInfo(player, (String)message);
    }

    public static void sendLinkError(Player player, int error) {
        String message = "\u00a7c\u00a7l" + INSTANCE.localize("error.enderchests.bag.nolink" + error + ".txt") + "\u00a7r";
        INSTANCE.sendInfo(player, message);
    }

    public static void sendError(Player player, String error) {
        String message = "\u00a7c\u00a7l" + INSTANCE.localize("error." + error + ".txt") + "\u00a7r";
        INSTANCE.sendInfo(player, message);
    }

    public static String formatChestOwner(String owner, boolean displayPublic) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            return displayPublic ? " \u00a76[-" + INSTANCE.localize("info.enderchests.chest.public.txt") + "-]\u00a7r" : "";
        }
        if (owner.startsWith("#")) {
            return " \u00a7a[-" + owner.substring(1) + "\u00a7a-]\u00a7r";
        }
        return " \u00a7b[-" + owner + "\u00a7b-]\u00a7r";
    }

    private String localize(String string) {
        return Localization.get((String)string);
    }

    private void sendInfo(Player player, String message) {
        if (player instanceof ServerPlayer) {
            message = message.replace("<br>", " ");
            ((ServerPlayer)player).f_8906_.m_141995_((Packet)new ClientboundChatPacket((Component)new TextComponent(message), ChatType.GAME_INFO, player.m_142081_()));
        } else {
            String[] split;
            for (String line : split = message.split("<br>")) {
                player.m_5661_((Component)new TextComponent(line), true);
            }
        }
    }

    public static String getDisplayNameFromOwnerID(String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            return "all";
        }
        if (ownerID.startsWith("#")) {
            return "#" + NameHelper.getDisplayNameFor((String)ownerID.substring(1));
        }
        return NameHelper.getDisplayNameFor((String)ownerID);
    }
}

