/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shetiphian.core.common.MyCreativeTab;
import shetiphian.core.common.RegistryHelper;
import shetiphian.core.common.inventory.InventoryInternal;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.client.gui.GuiEnderChest;
import shetiphian.enderchests.common.block.BlockEnderChest;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.item.ItemBlockEnderChest;
import shetiphian.enderchests.common.item.ItemEnderBag;
import shetiphian.enderchests.common.item.ItemEnderPouch;
import shetiphian.enderchests.common.misc.ChestHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;

@Mod.EventBusSubscriber(modid="enderchests", bus=Mod.EventBusSubscriber.Bus.MOD)
class Register {
    Register() {
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        Values.blockEnderChest = RegistryHelper.register((IForgeRegistry)registry, (Block)new BlockEnderChest(), (String)"enderchests:ender_chest");
    }

    @SubscribeEvent
    public static void registerTileEntities(RegistryEvent.Register<BlockEntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        Values.tileEnderChest = RegistryHelper.register((IForgeRegistry)registry, TileEntityEnderChest::new, (String)"enderchests:ender_chest.tile", (Block[])new Block[]{Values.blockEnderChest});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Values.tabEnderChests = new MyCreativeTab("EnderChests");
        RegistryHelper.register((IForgeRegistry)registry, (BlockItem)new ItemBlockEnderChest(Values.blockEnderChest, Register.stackable()));
        Values.itemEnderBag = RegistryHelper.register((IForgeRegistry)registry, (Item)new ItemEnderBag(Register.singleton()), (String)"enderchests:ender_bag");
        RegistryHelper.register((IForgeRegistry)registry, (Item)new ItemEnderPouch(Register.singleton()), (String)"enderchests:ender_pouch");
        Register.setTabIcon();
    }

    private static Item.Properties stackable() {
        return new Item.Properties().m_41491_((CreativeModeTab)Values.tabEnderChests);
    }

    private static Item.Properties singleton() {
        return Register.stackable().m_41487_(1);
    }

    private static void setTabIcon() {
        Values.tabEnderChests.setIcon(new ItemStack((ItemLike)Values.blockEnderChest));
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<MenuType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((windowId, invPlayer, data) -> {
            Level world = invPlayer.f_35978_.m_20193_();
            InventoryInternal chest = null;
            try {
                chest = ChestHelper.getChest(world, data.m_130277_(), data.m_130277_());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return chest != null ? new ContainerEnderChest(windowId, invPlayer, chest, data.m_130277_()) : null;
        }).setRegistryName("enderchests:ender_bag")));
        registry.register((IForgeRegistryEntry)((MenuType)IForgeMenuType.create((windowId, invPlayer, data) -> {
            BlockPos pos = data.m_130135_();
            Level world = invPlayer.f_35978_.m_20193_();
            BlockEntity tile = world.m_7702_(pos);
            return tile instanceof TileEntityEnderChest ? new ContainerEnderChest(windowId, invPlayer, (TileEntityEnderChest)tile) : null;
        }).setRegistryName("enderchests:ender_chest")));
    }

    @OnlyIn(value=Dist.CLIENT)
    static void registerScreenFactories() {
        MenuScreens.m_96206_(Values.Container.ENDER_BAG, GuiEnderChest::new);
        MenuScreens.m_96206_(Values.Container.ENDER_CHEST, GuiEnderChest::new);
    }
}

