/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import shetiphian.enderchests.Values;

public class Configuration {
    private static final ForgeConfigSpec.Builder BUILDER_CLIENT = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder BUILDER_COMMON = new ForgeConfigSpec.Builder();
    public static final Menu_General GENERAL = new Menu_General(BUILDER_COMMON);
    public static final Menu_GUI GUI_STYLE = new Menu_GUI(BUILDER_CLIENT);
    private static final Menu_Upgrade UPGRADE_ITEMS = new Menu_Upgrade(BUILDER_COMMON);
    public static final Menu_Settings UPGRADE_SETTINGS = new Menu_Settings(BUILDER_COMMON);
    public static final Menu_Access ACCESS_SETTINGS = new Menu_Access(BUILDER_COMMON);
    private static final Menu_Color COLOR_VALUES = new Menu_Color(BUILDER_CLIENT);
    static final ForgeConfigSpec SPEC_CLIENT = BUILDER_CLIENT.build();
    static final ForgeConfigSpec SPEC_COMMON = BUILDER_COMMON.build();
    public static boolean CAN_PROCESS_TAGS = false;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        ModConfig config = event.getConfig();
        if (config.getType() == ModConfig.Type.CLIENT) {
            Configuration.process_client();
        }
        if (config.getType() == ModConfig.Type.COMMON && Configuration.process(config.getConfigData())) {
            config.save();
        }
    }

    @SubscribeEvent
    public static void onReLoad(ModConfigEvent.Reloading event) {
        ModConfig config = event.getConfig();
        if (config.getType() == ModConfig.Type.CLIENT) {
            Configuration.process_client();
        }
        if (config.getType() == ModConfig.Type.COMMON && Configuration.process(config.getConfigData())) {
            config.save();
        }
    }

    private static void process_client() {
        Values.colorValues[0] = (Integer)Configuration.COLOR_VALUES.white.get();
        Values.colorValues[1] = (Integer)Configuration.COLOR_VALUES.orange.get();
        Values.colorValues[2] = (Integer)Configuration.COLOR_VALUES.magenta.get();
        Values.colorValues[3] = (Integer)Configuration.COLOR_VALUES.light_blue.get();
        Values.colorValues[4] = (Integer)Configuration.COLOR_VALUES.yellow.get();
        Values.colorValues[5] = (Integer)Configuration.COLOR_VALUES.lime.get();
        Values.colorValues[6] = (Integer)Configuration.COLOR_VALUES.pink.get();
        Values.colorValues[7] = (Integer)Configuration.COLOR_VALUES.gray.get();
        Values.colorValues[8] = (Integer)Configuration.COLOR_VALUES.light_gray.get();
        Values.colorValues[9] = (Integer)Configuration.COLOR_VALUES.cyan.get();
        Values.colorValues[10] = (Integer)Configuration.COLOR_VALUES.purple.get();
        Values.colorValues[11] = (Integer)Configuration.COLOR_VALUES.blue.get();
        Values.colorValues[12] = (Integer)Configuration.COLOR_VALUES.brown.get();
        Values.colorValues[13] = (Integer)Configuration.COLOR_VALUES.green.get();
        Values.colorValues[14] = (Integer)Configuration.COLOR_VALUES.red.get();
        Values.colorValues[15] = (Integer)Configuration.COLOR_VALUES.black.get();
    }

    private static boolean process(CommentedConfig config) {
        int chestMax;
        boolean save = false;
        int chestMin = (Integer)Configuration.UPGRADE_SETTINGS.chestSizeMin.get();
        if (chestMin > (chestMax = ((Integer)Configuration.UPGRADE_SETTINGS.chestSizeMax.get()).intValue())) {
            config.set("capacity_settings.chest_size_min", (Object)chestMax);
            config.set("capacity_settings.chest_size_max", (Object)chestMin);
            save = true;
        }
        if (CAN_PROCESS_TAGS) {
            Configuration.processTagLists();
        }
        return save;
    }

    public static void processTagLists() {
        Configuration.process((List)Configuration.UPGRADE_ITEMS.personal.get(), Values.listPersonal, Items.f_42415_);
        Configuration.process((List)Configuration.UPGRADE_ITEMS.team.get(), Values.listTeam, Items.f_42616_);
        Configuration.process((List)Configuration.UPGRADE_ITEMS.sCapacity_multi.get(), Values.listSmallCap_Multi, Items.f_42584_);
        Configuration.process((List)Configuration.UPGRADE_ITEMS.lCapacity_multi.get(), Values.listLargeCap_Multi, Items.f_42545_);
        Configuration.process((List)Configuration.UPGRADE_ITEMS.sCapacity_single.get(), Values.listSmallCap_Single, null);
        Configuration.process((List)Configuration.UPGRADE_ITEMS.lCapacity_single.get(), Values.listLargeCap_Single, null);
    }

    /*
     * WARNING - void declaration
     */
    private static void process(List<? extends String> names, ArrayList<Item> list, Item basic) {
        list.clear();
        for (String string : names) {
            void nameId;
            void var4_4;
            if (Strings.isNullOrEmpty((String)string)) continue;
            boolean isTag = false;
            if (string.toLowerCase().startsWith("tag|")) {
                isTag = true;
                String string2 = string.substring(4);
            }
            String modId = var4_4.contains(":") ? var4_4.split(":")[0] : "minecraft";
            Object object = nameId = var4_4.contains(":") ? var4_4.split(":")[1] : var4_4;
            if (isTag) {
                Tag.Named tag = ItemTags.m_13194_((String)(modId + ":" + nameId.replaceAll("\\.", "/")));
                tag.m_6497_().listIterator().forEachRemaining(item -> Configuration.addToList(item, list));
                continue;
            }
            Configuration.addToList((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modId, (String)nameId)), list);
        }
        if (list.isEmpty() && basic != null) {
            list.add(basic);
        }
    }

    private static void addToList(Item item, ArrayList<Item> list) {
        if (list != null && item != null && !list.contains(item)) {
            list.add(item);
        }
    }

    private static class Menu_Color {
        ForgeConfigSpec.IntValue white;
        ForgeConfigSpec.IntValue orange;
        ForgeConfigSpec.IntValue magenta;
        ForgeConfigSpec.IntValue light_blue;
        ForgeConfigSpec.IntValue yellow;
        ForgeConfigSpec.IntValue lime;
        ForgeConfigSpec.IntValue pink;
        ForgeConfigSpec.IntValue gray;
        ForgeConfigSpec.IntValue light_gray;
        ForgeConfigSpec.IntValue cyan;
        ForgeConfigSpec.IntValue purple;
        ForgeConfigSpec.IntValue blue;
        ForgeConfigSpec.IntValue brown;
        ForgeConfigSpec.IntValue green;
        ForgeConfigSpec.IntValue red;
        ForgeConfigSpec.IntValue black;

        Menu_Color(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"Color Values for Bands,", "Format: Decimal Values (0 to 16,777,215)", "You can use this website to get the decimal value of any color:", "http://www.colorhexa.com", "Or by using the Color Mixer from this website:", "http://www.mathsisfun.com/hexadecimal-decimal-colors.html"}).push("color_values");
            this.white = builder.defineInRange("white", 0xFFFFFF, 0, 0xFFFFFF);
            this.orange = builder.defineInRange("orange", 14517579, 0, 0xFFFFFF);
            this.magenta = builder.defineInRange("magenta", 12411333, 0, 0xFFFFFF);
            this.light_blue = builder.defineInRange("light_blue", 8296912, 0, 0xFFFFFF);
            this.yellow = builder.defineInRange("yellow", 12892206, 0, 0xFFFFFF);
            this.lime = builder.defineInRange("lime", 4832573, 0, 0xFFFFFF);
            this.pink = builder.defineInRange("pink", 14195370, 0, 0xFFFFFF);
            this.gray = builder.defineInRange("gray", 0x464646, 0, 0xFFFFFF);
            this.light_gray = builder.defineInRange("light_gray", 0xA9AFAF, 0, 0xFFFFFF);
            this.cyan = builder.defineInRange("cyan", 3373205, 0, 0xFFFFFF);
            this.purple = builder.defineInRange("purple", 8996546, 0, 0xFFFFFF);
            this.blue = builder.defineInRange("blue", 3292826, 0, 0xFFFFFF);
            this.brown = builder.defineInRange("brown", 5650466, 0, 0xFFFFFF);
            this.green = builder.defineInRange("green", 3821086, 0, 0xFFFFFF);
            this.red = builder.defineInRange("red", 0xA53A35, 0, 0xFFFFFF);
            this.black = builder.defineInRange("black", 0x262626, 0, 0xFFFFFF);
            builder.pop();
        }
    }

    public static class Menu_Settings {
        public ForgeConfigSpec.IntValue chestSizeMin;
        public ForgeConfigSpec.IntValue chestSizeMax;

        Menu_Settings(ForgeConfigSpec.Builder builder) {
            builder.comment("Adjust how many inventory slots are available").push("capacity_settings");
            this.chestSizeMin = builder.comment("Minimum capacity an EnderChest holds").defineInRange("chest_size_min", 9, 9, 27);
            this.chestSizeMax = builder.comment("Maximum capacity an EnderChest holds").defineInRange("chest_size_max", 27, 9, 54);
            builder.pop();
        }
    }

    private static class Menu_Upgrade {
        ForgeConfigSpec.ConfigValue<List<? extends String>> personal;
        ForgeConfigSpec.ConfigValue<List<? extends String>> team;
        ForgeConfigSpec.ConfigValue<List<? extends String>> sCapacity_multi;
        ForgeConfigSpec.ConfigValue<List<? extends String>> lCapacity_multi;
        ForgeConfigSpec.ConfigValue<List<? extends String>> sCapacity_single;
        ForgeConfigSpec.ConfigValue<List<? extends String>> lCapacity_single;
        private Predicate<Object> validator = object -> {
            if (object instanceof String) {
                String string = (String)object;
                return Strings.isNullOrEmpty((String)string) || string.split(":").length == 2;
            }
            return false;
        };

        Menu_Upgrade(ForgeConfigSpec.Builder builder) {
            builder.comment("Item used to upgrade the EnderChests").push("upgrade_item_tags");
            this.personal = builder.comment("Items used to make the chests personal").defineList("personal", this.getListOf("tag|forge:gems.diamond"), this.validator);
            this.team = builder.comment("Items used to make the chests team chests").defineList("team", this.getListOf("tag|forge:gems.emerald"), this.validator);
            this.sCapacity_multi = builder.comment("Items that upgrade storage capacity by 3").defineList("small_capacity", this.getListOf("minecraft:ender_pearl"), this.validator);
            this.lCapacity_multi = builder.comment("Items that upgrade storage capacity by 9").defineList("large_capacity", this.getListOf("minecraft:ender_eye"), this.validator);
            this.sCapacity_single = builder.comment(new String[]{"Items that upgrade storage capacity by 3", "Each item can only be use once per chest"}).defineList("small_capacity_singleuse", new ArrayList(), this.validator);
            this.lCapacity_single = builder.comment(new String[]{"Items that upgrade storage capacity by 9", "Each item can only be use once per chest"}).defineList("large_capacity_singleuse", new ArrayList(), this.validator);
            builder.pop();
        }

        private List<String> getListOf(String ... values) {
            return new ArrayList<String>(Arrays.asList(values));
        }
    }

    public static class Menu_General {
        public ForgeConfigSpec.BooleanValue enableInWorldRecoloring;

        Menu_General(ForgeConfigSpec.Builder builder) {
            this.enableInWorldRecoloring = builder.comment("With this disabled chests are essentially locked to the crafted color as dyes will no longer work").define("enable_in_world_coloring", true);
        }
    }

    public static class Menu_GUI {
        public ForgeConfigSpec.EnumValue<STYLE> enderchest;

        Menu_GUI(ForgeConfigSpec.Builder builder) {
            builder.comment("Select A GUI Style").push("gui_style");
            this.enderchest = builder.defineEnum("EnderChest", (Enum)STYLE.DEFAULT);
            builder.pop();
        }

        public static enum STYLE {
            DEFAULT,
            VANILLA;

        }
    }

    public static class Menu_Access {
        public ForgeConfigSpec.BooleanValue allowEnderPouch;
        public ForgeConfigSpec.BooleanValue allowPublicChests;
        public ForgeConfigSpec.BooleanValue allowPersonalChests;
        public ForgeConfigSpec.BooleanValue allowTeamChests;
        public ForgeConfigSpec.BooleanValue allowPublicBags;
        public ForgeConfigSpec.BooleanValue allowPersonalBags;
        public ForgeConfigSpec.BooleanValue allowTeamBags;
        public ForgeConfigSpec.BooleanValue enableAutomationPublic;
        public ForgeConfigSpec.BooleanValue enableAutomationPersonal;
        public ForgeConfigSpec.BooleanValue enableAutomationTeam;
        public ForgeConfigSpec.BooleanValue lockPersonalEdit;
        public ForgeConfigSpec.BooleanValue lockTeamEdit;
        public ForgeConfigSpec.BooleanValue lockPersonalLink;
        public ForgeConfigSpec.BooleanValue lockTeamLink;
        public ForgeConfigSpec.BooleanValue lockPersonalUse;
        public ForgeConfigSpec.BooleanValue lockTeamUse;

        Menu_Access(ForgeConfigSpec.Builder builder) {
            builder.push("access_settings");
            this.allowEnderPouch = builder.comment("When enabled these bags access a players vanilla EnderChest, if disabled they will only be a crafting ingredient").define("ender_pouch", true);
            this.allowPublicChests = builder.comment("Enables the usage of public chests, if disabled chests must be upgraded before use").define("public_chests", true);
            this.allowPersonalChests = builder.comment(new String[]{"Enables the creation of personal chests, if disabled chests can not set personal.", "Does not effect chests that are already set as personal"}).define("personal_chests", true);
            this.allowTeamChests = builder.comment(new String[]{"Enables the creation of team chests, if disabled chests can not be set team.", "Does not effect chests that are already set as team"}).define("team_chests", true);
            this.allowPublicBags = builder.comment("Enables the usage of public bags, if disabled bags must be linked to an upgraded chest before use").define("public_bags", true);
            this.allowPersonalBags = builder.comment(new String[]{"Enables the linking of bags to personal chests.", "Does not effect bags that are already linked to personal chests"}).define("personal_bags", true);
            this.allowTeamBags = builder.comment(new String[]{"Enables the linking of bags to team chests.", "Does not effect bags that are already linked to team chests"}).define("team_bags", true);
            this.enableAutomationPublic = builder.comment("Public chests can be used with automation.").define("public_automation", true);
            this.enableAutomationPersonal = builder.comment("Personal chests can be used with automation.").define("personal_automation", true);
            this.enableAutomationTeam = builder.comment("Team chests can be used with automation.").define("team_automation", true);
            this.lockPersonalEdit = builder.comment("While true a Personal chest can only be edited (upgrade, move, etc) by the owner").define("personal_edit_lock", true);
            this.lockTeamEdit = builder.comment("While true a Team chest can only be edited (upgrade, move, etc) by a team member").define("team_edit_lock", true);
            this.lockPersonalLink = builder.comment("While true only the owner can link a bag to their chests").define("personal_link_lock", true);
            this.lockTeamLink = builder.comment("While true only a team member can link a bag to team chests").define("team_link_lock", true);
            this.lockPersonalUse = builder.comment("While true only the owner can use the chest").define("personal_use_lock", false);
            this.lockTeamUse = builder.comment("While true only a team member can use the chest").define("team_use_lock", false);
            builder.pop();
        }
    }
}

