/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIcon;
import xaero.common.minimap.render.radar.EntityIconAtlas;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.EntityIconModelFieldResolver;
import xaero.common.minimap.render.radar.EntityIconModelPartsRenderer;
import xaero.common.minimap.render.radar.LivingEntityRotationResetter;
import xaero.common.minimap.render.radar.ModelRenderDetectionElement;
import xaero.common.minimap.render.radar.ResolvedFieldModelPartsRenderer;
import xaero.common.minimap.render.radar.ResolvedFieldModelRootPathListener;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;
import xaero.common.misc.Misc;

public class EntityIconPrerenderer {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    private static final int ICON_WIDTH = 64;
    private static final ModelPart[] ONE_RENDERER_ARRAY = new ModelPart[1];
    private static final Object[] ONE_OBJECT_ARRAY = new Object[1];
    private static final boolean TEST_ALL_FIELDS = false;
    private static ArrayList<String> failedFields = new ArrayList();
    private final IXaeroMinimap modMain;
    private ImprovedFramebuffer modelRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private PoseStack matrixStack;
    private EntityIconModelPartsRenderer entityModelPartsRenderer;
    private ResolvedFieldModelPartsRenderer modelPartsFieldResolverListener;
    private ResolvedFieldModelRootPathListener resolvedFieldModelRootPathListener;
    private LivingEntityRotationResetter livingEntityRotationResetter;
    private final int atlasTextureSize;
    private final List<EntityIconAtlas> atlases;
    private int currentAtlasIndex;
    private MultiBufferSource.BufferSource entityIconRenderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(256));
    public static boolean DETECTING_MODEL_RENDERS;
    private EntityRenderer modelRenderDetectionEntityRenderer;
    private Class<?> modelRenderDetectionEntityModelClass;
    private List<ModelRenderDetectionElement> modelRenderDetectionList;
    private ModelRenderDetectionElement lastModelRenderDetected;
    private MultiBufferSource.BufferSource modelRenderDetectionRenderTypeBuffer;
    private Field lastRenderTypeField;
    private Class<?> renderTypeTypeClass;
    private Field enderDragonModelField;
    private Field renderStateField;
    private Field renderStateTextureStateField;
    private Field renderStateTextureStateTextureField;
    private Field renderStateDepthTestStateField;
    private Field renderStateWriteMaskStateField;
    private Field renderStateCullStateField;
    private Field renderStateTransparencyStateField;
    private Field renderStateShaderStateField;
    private Field vanillaEntityVertexConsumersField;
    private Class<?> irisRenderLayerWrapperClass;
    private Method irisRenderLayerWrapperUnwrapMethod;

    public EntityIconPrerenderer(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.modelRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.matrixStack = new PoseStack();
        this.entityModelPartsRenderer = new EntityIconModelPartsRenderer();
        this.livingEntityRotationResetter = new LivingEntityRotationResetter();
        this.modelRenderFramebuffer.m_83956_();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.m_84209_((int)3553, (int)0, (int)32856, (int)this.modelRenderFramebuffer.f_83917_, (int)this.modelRenderFramebuffer.f_83918_, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.m_84544_((int)0);
        this.iconRenderFramebuffer.m_83956_();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.m_84209_((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.f_83917_, (int)this.iconRenderFramebuffer.f_83918_, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.m_84544_((int)0);
        this.modelRenderDetectionList = new ArrayList<ModelRenderDetectionElement>();
        this.enderDragonModelField = Misc.getFieldReflection(EnderDragonRenderer.class, "f_114183_", "model");
        this.lastRenderTypeField = Misc.getFieldReflection(MultiBufferSource.BufferSource.class, "f_109906_", "lastState");
        try {
            this.renderTypeTypeClass = Class.forName("net.minecraft.client.renderer.RenderType$CompositeRenderType");
            this.renderStateField = Misc.getFieldReflection(this.renderTypeTypeClass, "f_110511_", "state");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        try {
            Class<?> multiPhaseParametersClass = Class.forName("net.minecraft.client.renderer.RenderType$CompositeState");
            Class<?> renderPhaseTextureClass = Class.forName("net.minecraft.client.renderer.RenderStateShard$TextureStateShard");
            this.renderStateTextureStateField = Misc.getFieldReflection(multiPhaseParametersClass, "f_110576_", "textureState");
            this.renderStateTextureStateTextureField = Misc.getFieldReflection(renderPhaseTextureClass, "f_110328_", "texture");
            this.renderStateTransparencyStateField = Misc.getFieldReflection(multiPhaseParametersClass, "f_110577_", "transparencyState");
            this.renderStateDepthTestStateField = Misc.getFieldReflection(multiPhaseParametersClass, "f_110581_", "depthTestState");
            this.renderStateWriteMaskStateField = Misc.getFieldReflection(multiPhaseParametersClass, "f_110589_", "writeMaskState");
            this.renderStateCullStateField = Misc.getFieldReflection(multiPhaseParametersClass, "f_110582_", "cullState");
            this.renderStateShaderStateField = Misc.getFieldReflection(multiPhaseParametersClass, "f_173274_", "shaderState");
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException(e2);
        }
        this.vanillaEntityVertexConsumersField = Misc.getFieldReflection(RenderBuffers.class, "f_110094_", "bufferSource");
        try {
            try {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderTypeWrapper");
            }
            catch (ClassNotFoundException e) {
                this.irisRenderLayerWrapperClass = Class.forName("net.coderbot.iris.layer.IrisRenderLayerWrapper");
            }
            this.irisRenderLayerWrapperUnwrapMethod = Misc.getMethodReflection(this.irisRenderLayerWrapperClass, "unwrap", "unwrap", new Class[0]);
            System.out.println("Iris!");
        }
        catch (Exception e) {
            System.out.println("No Iris!");
        }
        this.modelPartsFieldResolverListener = new ResolvedFieldModelPartsRenderer();
        this.resolvedFieldModelRootPathListener = new ResolvedFieldModelRootPathListener();
        int maxTextureSize = GlStateManager.m_84092_((int)3379);
        this.atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
        this.atlases = new ArrayList<EntityIconAtlas>();
        this.currentAtlasIndex = -1;
        this.atlasRenderFramebuffer = new ImprovedFramebuffer(this.atlasTextureSize, this.atlasTextureSize, false);
        OpenGLException.checkGLError();
        GlStateManager.m_84541_((int)this.atlasRenderFramebuffer.getFramebufferTexture());
        OpenGLException.checkGLError();
    }

    void clearAtlases() {
        for (EntityIconAtlas entityIconAtlas : this.atlases) {
            GlStateManager.m_84541_((int)entityIconAtlas.getTextureId());
        }
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
        this.currentAtlasIndex = -1;
        this.atlases.clear();
    }

    private EntityIconAtlas getCurrentAtlas() throws Exception {
        if (this.currentAtlasIndex < 0 || this.atlases.get(this.currentAtlasIndex).isFull()) {
            this.atlases.add(EntityIconAtlas.Builder.begin(this.modMain).setWidth(this.atlasTextureSize).setIconWidth(64).build());
            this.currentAtlasIndex = this.atlases.size() - 1;
        }
        return this.atlases.get(this.currentAtlasIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void testField(ImmutableList<String> fields) throws NoSuchFieldException, SecurityException {
        boolean odd = true;
        boolean pairFirstFailed = false;
        String prevS = null;
        UnmodifiableIterator unmodifiableIterator = fields.iterator();
        while (unmodifiableIterator.hasNext()) {
            String s = (String)unmodifiableIterator.next();
            try {
                boolean bl = odd = !odd;
                if (!odd) {
                    pairFirstFailed = false;
                }
                boolean failed = false;
                if (!s.isEmpty()) {
                    String[] fieldArgs = s.split(";");
                    Class<?> c = null;
                    try {
                        c = Class.forName(fieldArgs[0]);
                    }
                    catch (ClassNotFoundException cnfe) {
                        System.out.println("Skipping testing a class: " + fieldArgs[0]);
                        prevS = s;
                        continue;
                    }
                    try {
                        c.getDeclaredField(fieldArgs[1]);
                    }
                    catch (Exception e) {
                        failed = true;
                    }
                } else {
                    failed = true;
                }
                if (failed) {
                    if (!odd) {
                        pairFirstFailed = true;
                    } else if (pairFirstFailed) {
                        failedFields.add(prevS);
                        failedFields.add(s);
                    }
                }
                prevS = s;
            }
            catch (Throwable throwable) {
                prevS = s;
                throw throwable;
            }
        }
        return;
    }

    public EntityIcon prerender(String cacheKey, EntityRenderer entityRenderer, Entity entity, RenderTarget defaultFramebuffer, MinimapRendererHelper helper, float scale, EntityIconModelConfig modelConfig, ResourceLocation readySprite, boolean outlined, boolean flipped, boolean debug) {
        boolean renderedSomething;
        ImprovedFramebuffer modelRenderFramebuffer = this.modelRenderFramebuffer;
        ImprovedFramebuffer iconRenderFramebuffer = this.iconRenderFramebuffer;
        OpenGLException.checkGLError();
        PoseStack matrixStack = this.matrixStack;
        modelRenderFramebuffer.m_83947_(true);
        int farPlane = 500;
        this.setupMatrices(64, farPlane);
        OpenGLException.checkGLError();
        if (readySprite == null) {
            LivingEntity livingEntity;
            GlStateManager.m_84091_();
            if (Minecraft.m_91087_().m_91290_().f_114358_ != null) {
                DETECTING_MODEL_RENDERS = true;
                this.modelRenderDetectionEntityRenderer = entityRenderer;
                this.modelRenderDetectionEntityModelClass = null;
                this.modelRenderDetectionList.clear();
                this.lastModelRenderDetected = null;
                PoseStack.Pose matrixEntryToRestore = matrixStack.m_85850_();
                matrixStack.m_85836_();
                try {
                    MultiBufferSource.BufferSource renderTypeBuffer = this.modelRenderDetectionRenderTypeBuffer = (MultiBufferSource.BufferSource)Misc.getReflectFieldValue(Minecraft.m_91087_().m_91269_(), this.vanillaEntityVertexConsumersField);
                    entityRenderer.m_7392_(entity, 0.0f, 1.0f, matrixStack, (MultiBufferSource)renderTypeBuffer, 0xF000F0);
                    renderTypeBuffer.m_109911_();
                    OpenGLException.checkGLError();
                }
                catch (Exception e) {
                    this.modelRenderDetectionList.clear();
                    System.out.println("Exception when calling the full entity renderer before rendering the icon. " + entity.m_20078_());
                    e.printStackTrace();
                }
                DETECTING_MODEL_RENDERS = false;
                while (matrixStack.m_85850_() != matrixEntryToRestore) {
                    matrixStack.m_85849_();
                }
                while (GL11.glGetError() != 0) {
                }
            } else {
                System.out.println("Render info was null for entity " + entity.m_20078_());
            }
            MultiBufferSource.BufferSource renderTypeBuffer = this.entityIconRenderTypeBuffer;
            EntityModel entityModel = this.getEntityRendererModel(entityRenderer);
            if (entityModel == null) {
                this.endModelRendering(modelRenderFramebuffer);
                defaultFramebuffer.m_83947_(true);
                this.restoreMatrices(helper);
                return EntityIconManager.FAILED;
            }
            GlStateManager.m_84519_();
            GlStateManager.m_84318_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.m_84266_((int)16640, (boolean)Minecraft.f_91002_);
            GlStateManager.m_84525_();
            GlStateManager.m_84507_();
            GlStateManager.m_84091_();
            GlStateManager.m_84323_((int)515);
            Lighting.m_84930_();
            if (debug) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(0.0, 10.0, -10.0);
                matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-65536);
                matrixStack.m_85849_();
                GlStateManager.m_84525_();
                RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)771);
            }
            PoseStack.Pose matrixEntryToRestore = matrixStack.m_85850_();
            matrixStack.m_85836_();
            matrixStack.m_85837_(32.0, 32.0, -450.0);
            matrixStack.m_85837_((double)modelConfig.offsetX, (double)(-modelConfig.offsetY), 0.0);
            int mainScale = 32;
            matrixStack.m_85841_((float)mainScale, (float)(-mainScale), (float)(-mainScale));
            if (scale < 1.0f) {
                matrixStack.m_85841_(scale, scale, scale);
            }
            matrixStack.m_85841_(modelConfig.baseScale, modelConfig.baseScale, modelConfig.baseScale);
            EntityIconDefinitions.customTransformation(matrixStack, entityModel, entity, this);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(modelConfig.rotationY));
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(modelConfig.rotationX));
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(modelConfig.rotationZ));
            LivingEntity livingEntity2 = livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
            if (livingEntity != null) {
                this.livingEntityRotationResetter.rememberAndResetValues(livingEntity);
            }
            renderedSomething = this.renderIcon(matrixStack, renderTypeBuffer, entityRenderer, entityModel, this.modelRenderDetectionList, (Entity)((LivingEntity)entity), modelConfig);
            if (livingEntity != null) {
                this.livingEntityRotationResetter.restore(livingEntity);
            }
            EntityIconDefinitions.customPostRenderTransformation(matrixStack, entityModel, entity);
            while (matrixStack.m_85850_() != matrixEntryToRestore) {
                matrixStack.m_85849_();
            }
            if (debug) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(9.0, 10.0, -10.0);
                matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-16711936);
                matrixStack.m_85849_();
                RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)771);
            }
        } else {
            matrixStack.m_85836_();
            GlStateManager.m_84519_();
            GlStateManager.m_84318_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.m_84266_((int)16640, (boolean)Minecraft.f_91002_);
            GlStateManager.m_84525_();
            GlStateManager.m_84094_();
            Lighting.m_84930_();
            Minecraft.m_91087_().m_91097_().m_174784_(readySprite);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
            matrixStack.m_85837_(32.0, 32.0, 1.0);
            if (scale < 1.0f) {
                matrixStack.m_85841_(scale, scale, 1.0f);
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)readySprite);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            helper.drawMyTexturedModalRect(matrixStack, -32.0f, -32.0f, 0, 0, 64.0f, 64.0f, 64.0f, 64.0f);
            GlStateManager.m_84091_();
            matrixStack.m_85849_();
            renderedSomething = true;
        }
        this.endModelRendering(modelRenderFramebuffer);
        EntityIcon icon = EntityIconManager.FAILED;
        if (renderedSomething) {
            iconRenderFramebuffer.m_83947_(true);
            GlStateManager.m_84318_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.m_84266_((int)16384, (boolean)Minecraft.f_91002_);
            GlStateManager.m_84519_();
            if (debug) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(18.0, 10.0, -10.0);
                matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-16776961);
                matrixStack.m_85849_();
                RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)771);
            }
            modelRenderFramebuffer.m_83956_();
            RenderSystem.m_157429_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.m_84525_();
            RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)1);
            if (outlined) {
                for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
                    for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                        if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                        helper.drawIconOutline(matrixStack, shadowOffsetX, 64 + shadowOffsetY, 0, 0, 64.0f, -64.0f, 64.0f, 64.0f, 0.05f);
                    }
                }
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.m_84519_();
            helper.drawMyTexturedModalRect(matrixStack, 0.0f, 64.0f, 0, 0, 64.0f, -64.0f, 64.0f, 64.0f, 0.05f, false);
            RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)771);
            if (debug) {
                matrixStack.m_85836_();
                matrixStack.m_85837_(27.0, 10.0, -10.0);
                matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
                GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-16711681);
                matrixStack.m_85849_();
                RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)771);
            }
            GlStateManager.m_84525_();
            iconRenderFramebuffer.m_83970_();
            iconRenderFramebuffer.m_83956_();
            iconRenderFramebuffer.generateMipmaps();
            GlStateManager.m_84544_((int)0);
            try {
                EntityIconAtlas atlas = this.getCurrentAtlas();
                icon = atlas.createIcon();
                this.atlasRenderFramebuffer.m_83947_(false);
                GlStateManager.m_84430_((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
                this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
                this.atlasRenderFramebuffer.m_83949_();
                iconRenderFramebuffer.m_83956_();
                GlStateManager.m_84519_();
                if (flipped) {
                    helper.drawMyTexturedModalRect(matrixStack, 0.0f, 64.0f, 0, 64, 64.0f, -64.0f, -64.0f, 64.0f, -1.0f, false);
                } else {
                    helper.drawMyTexturedModalRect(matrixStack, 0.0f, 64.0f, 0, 0, 64.0f, -64.0f, 64.0f, 64.0f, -1.0f, false);
                }
                if (debug) {
                    matrixStack.m_85836_();
                    matrixStack.m_85837_(36.0, 10.0, -10.0);
                    matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
                    GuiComponent.m_93172_((PoseStack)matrixStack, (int)0, (int)0, (int)9, (int)9, (int)-256);
                    matrixStack.m_85849_();
                    RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)771);
                }
            }
            catch (Throwable t) {
                this.modMain.getLogger().error(String.format("Exception rendering to a entity icon atlas for %s!", cacheKey), t);
            }
            GlStateManager.m_84525_();
            GlStateManager.m_84544_((int)0);
            MinimapRendererHelper.restoreDefaultShaderBlendState();
        }
        this.restoreMatrices(helper);
        this.atlasRenderFramebuffer.m_83970_();
        defaultFramebuffer.m_83947_(true);
        return icon;
    }

    private void setupMatrices(int finalIconSize, int farPlane) {
        Matrix4f ortho = Matrix4f.m_162203_((float)0.0f, (float)finalIconSize, (float)finalIconSize, (float)0.0f, (float)-1.0f, (float)farPlane);
        RenderSystem.m_157425_((Matrix4f)ortho);
        RenderSystem.m_157191_().m_85836_();
        RenderSystem.m_157191_().m_166856_();
        RenderSystem.m_157182_();
    }

    private void restoreMatrices(MinimapRendererHelper helper) {
        helper.defaultOrtho();
        RenderSystem.m_157191_().m_85849_();
        RenderSystem.m_157182_();
    }

    private void endModelRendering(ImprovedFramebuffer modelRenderFramebuffer) {
        modelRenderFramebuffer.m_83970_();
        GlStateManager.m_84525_();
        Lighting.m_84931_();
        Lighting.m_84930_();
    }

    private ModelPart renderModel(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, EntityRenderer entityRenderer, EntityModel entityModel, Entity entity, EntityIconModelConfig modelConfig, ModelPart mainPart, ArrayList<ModelPart> renderedModels, ResourceLocation entityTexture, boolean forceFieldCheck, boolean fullModelIcon, ModelRenderDetectionElement mrde, List<String> hardcodedMainPartAliases, List<String> hardcodedModelPartsFields) {
        boolean isChildBU = entityModel.f_102610_;
        entityModel.f_102610_ = false;
        Object modelRoot = null;
        if (modelConfig.modelRootPath != null) {
            modelRoot = this.resolveModelRoot(entityModel, modelConfig.modelRootPath, entity);
        }
        if (modelRoot == null) {
            modelRoot = EntityIconDefinitions.getModelRoot(entityRenderer, entityModel);
        }
        if (entityTexture != null) {
            VertexConsumer vertexBuilder = this.setupModelRenderType(renderTypeBuffer, entityTexture, mrde);
            if (modelConfig.modelMainPartFieldAliases != null && !modelConfig.modelMainPartFieldAliases.isEmpty()) {
                mainPart = this.searchSuperclassFields(vertexBuilder, modelRoot, renderedModels, mainPart, modelConfig.modelMainPartFieldAliases, true, modelConfig.modelPartsRotationReset, mrde);
            }
            if (!forceFieldCheck && modelRoot instanceof AgeableListModel) {
                if (modelRoot instanceof HumanoidModel) {
                    ModelPart headRenderer = ((HumanoidModel)modelRoot).f_102808_;
                    if (mainPart == null) {
                        mainPart = headRenderer;
                    }
                    ModelPart headWearRenderer = ((HumanoidModel)modelRoot).f_102809_;
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                    this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headWearRenderer, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
                mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.ageableModelHeadPartsMethod, (EntityModel)((AgeableListModel)modelRoot), renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                if (fullModelIcon) {
                    mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.ageableModelBodyPartsMethod, (EntityModel)((AgeableListModel)modelRoot), renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                }
            } else {
                HierarchicalModel singlePartModel;
                ModelPart rootPart;
                boolean singlePartSucceeded = false;
                if (!forceFieldCheck && modelRoot instanceof HierarchicalModel && (rootPart = (singlePartModel = (HierarchicalModel)modelRoot).m_142109_()) != null) {
                    try {
                        ModelPart headPart = rootPart.m_171324_("head");
                        if (mainPart == null) {
                            mainPart = headPart;
                        }
                        this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headPart, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                        singlePartSucceeded = true;
                    }
                    catch (NoSuchElementException headPart) {
                        // empty catch block
                    }
                    if (fullModelIcon) {
                        Map<String, ModelPart> rootChildren = this.entityModelPartsRenderer.getChildModels(rootPart);
                        mainPart = this.entityModelPartsRenderer.renderPartsIterable(rootChildren.values(), matrixStack, vertexBuilder, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                        singlePartSucceeded = true;
                    }
                }
                if (!singlePartSucceeded) {
                    if (!forceFieldCheck && modelRoot instanceof ListModel && fullModelIcon) {
                        mainPart = this.entityModelPartsRenderer.renderDeclaredMethod(matrixStack, vertexBuilder, this.entityModelPartsRenderer.segmentedModelPartsMethod, (EntityModel)((ListModel)modelRoot), renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                    } else {
                        if (!forceFieldCheck && modelRoot instanceof HeadedModel) {
                            ModelPart headPart = ((HeadedModel)modelRoot).m_5585_();
                            if (mainPart == null) {
                                mainPart = headPart;
                            }
                            this.entityModelPartsRenderer.renderPart(matrixStack, vertexBuilder, headPart, renderedModels, mainPart, modelConfig.modelPartsRotationReset, mrde);
                        }
                        if (modelConfig.modelPartsFields == null) {
                            mainPart = this.searchSuperclassFields(vertexBuilder, modelRoot, renderedModels, mainPart, hardcodedMainPartAliases, true, modelConfig.modelPartsRotationReset, mrde);
                        }
                        List<String> headPartsFields = hardcodedModelPartsFields;
                        if (fullModelIcon) {
                            headPartsFields = null;
                        } else if (modelConfig.modelPartsFields != null) {
                            headPartsFields = modelConfig.modelPartsFields;
                        }
                        mainPart = this.searchSuperclassFields(vertexBuilder, modelRoot, renderedModels, mainPart, headPartsFields, false, modelConfig.modelPartsRotationReset, mrde);
                    }
                }
            }
            renderTypeBuffer.m_109911_();
        }
        entityModel.f_102610_ = isChildBU;
        return mainPart;
    }

    private VertexConsumer setupModelRenderType(MultiBufferSource.BufferSource renderTypeBuffer, ResourceLocation entityTexture, ModelRenderDetectionElement mrde) {
        return renderTypeBuffer.m_6299_(CustomRenderTypes.entityIconRenderType(entityTexture, mrde.layerPhases));
    }

    public ModelPart searchSuperclassFields(VertexConsumer vertexBuilder, Object modelRoot, ArrayList<ModelPart> renderedModels, ModelPart mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        this.modelPartsFieldResolverListener.prepare(this.matrixStack, vertexBuilder, justOne, renderedModels, mainPart, zeroRotation, mrde, this.entityModelPartsRenderer);
        EntityIconModelFieldResolver.searchSuperclassFields(modelRoot, filter, this.modelPartsFieldResolverListener, ONE_RENDERER_ARRAY);
        return this.modelPartsFieldResolverListener.getMainPart();
    }

    public ModelPart handleFields(VertexConsumer vertexBuilder, Object modelRoot, Field[] declaredModelFields, ArrayList<ModelPart> renderedModels, ModelPart mainPart, List<String> filter, boolean justOne, boolean zeroRotation, ModelRenderDetectionElement mrde) {
        this.modelPartsFieldResolverListener.prepare(this.matrixStack, vertexBuilder, justOne, renderedModels, mainPart, zeroRotation, mrde, this.entityModelPartsRenderer);
        EntityIconModelFieldResolver.handleFields(modelRoot, declaredModelFields, filter, this.modelPartsFieldResolverListener, ONE_RENDERER_ARRAY);
        return this.modelPartsFieldResolverListener.getMainPart();
    }

    public void generateMipmaps() {
        this.modelRenderFramebuffer.generateMipmaps();
    }

    public void onModelRenderDetection(EntityModel<?> model, float red, float green, float blue, float alpha) {
        Object renderState;
        if (this.modelRenderDetectionEntityModelClass == null) {
            EntityModel currentMainModel = this.getEntityRendererModel(this.modelRenderDetectionEntityRenderer);
            Class<?> clazz = this.modelRenderDetectionEntityModelClass = currentMainModel == null ? null : currentMainModel.getClass();
        }
        if (this.modelRenderDetectionEntityModelClass != model.getClass()) {
            return;
        }
        RenderType lastRenderType = this.getLastRenderType((MultiBufferSource)this.modelRenderDetectionRenderTypeBuffer);
        if (lastRenderType != null && (renderState = this.getRenderState(lastRenderType)) != null) {
            int blendSrcFactor;
            Object renderTextureState = Misc.getReflectFieldValue(renderState, this.renderStateTextureStateField);
            ResourceLocation texture = this.getRenderStateTextureStateTexture(renderTextureState);
            Object renderTransparencyState = Misc.getReflectFieldValue(renderState, this.renderStateTransparencyStateField);
            ((RenderStateShard)renderTransparencyState).m_110185_();
            int blendDestFactor = GL11.glGetInteger((int)32968);
            if (blendDestFactor == 1 && (blendSrcFactor = GL11.glGetInteger((int)32969)) != 0) {
                renderTransparencyState = CustomRenderTypes.getTransparencyPhase(blendSrcFactor, blendDestFactor, 0, 1);
            }
            ((RenderStateShard)renderTransparencyState).m_110188_();
            Object renderDepthTestState = Misc.getReflectFieldValue(renderState, this.renderStateDepthTestStateField);
            Object renderWriteMaskState = Misc.getReflectFieldValue(renderState, this.renderStateWriteMaskStateField);
            Object renderCullState = Misc.getReflectFieldValue(renderState, this.renderStateCullStateField);
            Object renderShaderState = Misc.getReflectFieldValue(renderState, this.renderStateShaderStateField);
            CustomRenderTypes.EntityIconLayerPhases layerPhases = new CustomRenderTypes.EntityIconLayerPhases(renderTextureState, renderTransparencyState, renderDepthTestState, renderWriteMaskState, renderCullState, renderShaderState);
            this.lastModelRenderDetected = new ModelRenderDetectionElement(model, texture, layerPhases, red, green, blue, alpha);
            this.modelRenderDetectionList.add(this.lastModelRenderDetected);
        }
    }

    public void onModelPartRenderDetection(ModelPart modelRenderer, float red, float green, float blue, float alpha) {
        if (this.lastModelRenderDetected != null) {
            this.lastModelRenderDetected.addVisibleModelPart(modelRenderer, red, green, blue, alpha);
        }
    }

    private RenderType getLastRenderType(MultiBufferSource renderTypeBuffer) {
        if (renderTypeBuffer instanceof MultiBufferSource.BufferSource) {
            Object lastRenderTypeObject = Misc.getReflectFieldValue(renderTypeBuffer, this.lastRenderTypeField);
            RenderType lastRenderType = null;
            lastRenderType = lastRenderTypeObject instanceof Optional ? (RenderType)((Optional)lastRenderTypeObject).get() : (RenderType)lastRenderTypeObject;
            return lastRenderType;
        }
        return null;
    }

    private Object getRenderState(RenderType renderType) {
        while (renderType.getClass() == this.irisRenderLayerWrapperClass && this.irisRenderLayerWrapperUnwrapMethod != null) {
            renderType = (RenderType)Misc.getReflectMethodValue(renderType, this.irisRenderLayerWrapperUnwrapMethod, new Object[0]);
        }
        if (renderType.getClass() == this.renderTypeTypeClass) {
            Object renderState = Misc.getReflectFieldValue(renderType, this.renderStateField);
            return renderState;
        }
        return null;
    }

    private ResourceLocation getRenderStateTextureStateTexture(Object renderTextureState) {
        Optional optional;
        Object renderStateTextureObject = Misc.getReflectFieldValue(renderTextureState, this.renderStateTextureStateTextureField);
        Object renderStateTexture = null;
        renderStateTexture = renderStateTextureObject instanceof Optional ? (!(optional = (Optional)renderStateTextureObject).isPresent() ? null : (ResourceLocation)optional.get()) : (ResourceLocation)renderStateTextureObject;
        return renderStateTexture;
    }

    private boolean renderIcon(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, EntityRenderer entityRenderer, EntityModel mainEntityModel, List<ModelRenderDetectionElement> detectedModels, Entity entity, EntityIconModelConfig modelConfig) {
        EntityIconCustomRenderer extraLayer;
        boolean forceFieldCheck;
        boolean bl = forceFieldCheck = !(modelConfig.renderingFullModel != null && modelConfig.renderingFullModel != false || modelConfig.modelPartsFields == null && !EntityIconDefinitions.forceFieldCheck(mainEntityModel));
        boolean fullModelIcon = modelConfig.renderingFullModel == null ? !forceFieldCheck && EntityIconDefinitions.fullModelIcon(mainEntityModel) : modelConfig.renderingFullModel;
        ModelPart mainPart = null;
        boolean renderedSomething = false;
        ArrayList<ModelPart> mainRenderedModels = new ArrayList<ModelPart>();
        ResourceLocation mainEntityTexture = entityRenderer.m_5478_(entity);
        if (detectedModels.isEmpty() && mainEntityTexture != null) {
            detectedModels.add(new ModelRenderDetectionElement(mainEntityModel, mainEntityTexture, CustomRenderTypes.getBasicEntityIconLayerPhases(mainEntityTexture), 1.0f, 1.0f, 1.0f, 1.0f));
        }
        boolean allEmpty = true;
        for (ModelRenderDetectionElement mrde : detectedModels) {
            if (mrde.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            for (ModelRenderDetectionElement mrde : detectedModels) {
                mrde.allVisible = true;
            }
        }
        List<String> hardcodedMainPartAliases = EntityIconDefinitions.getMainModelPartFields(entityRenderer, mainEntityModel, entity);
        List<String> hardcodedModelPartsFields = EntityIconDefinitions.getSecondaryModelPartsFields(entityRenderer, mainEntityModel, entity);
        ModelRenderDetectionElement mainMrde = null;
        for (ModelRenderDetectionElement mrde : detectedModels) {
            boolean mainPartsVisibility;
            if (mrde.isEmpty() || renderedSomething && !modelConfig.layersAllowed) continue;
            EntityModel<?> detectedModel = mrde.model;
            ResourceLocation detectedTexture = mrde.renderTexture;
            boolean mainModel = detectedModel == mainEntityModel;
            boolean bl2 = mainPartsVisibility = mainModel && mainMrde != null && mrde.sameVisibility(mainMrde);
            if (mainModel && !mainPartsVisibility) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                mainRenderedModels.clear();
                mainPart = this.renderModel(matrixStack, renderTypeBuffer, entityRenderer, detectedModel, entity, modelConfig, mainPart, mainRenderedModels, detectedTexture, forceFieldCheck, fullModelIcon, mrde, hardcodedMainPartAliases, hardcodedModelPartsFields);
                mainMrde = mrde;
                renderedSomething = renderedSomething || !mainRenderedModels.isEmpty();
                continue;
            }
            if (!mainModel) {
                if (!this.resetModelRotations(entity, detectedModel)) break;
                ArrayList<ModelPart> renderedModels = new ArrayList<ModelPart>();
                mainPart = this.renderModel(matrixStack, renderTypeBuffer, entityRenderer, detectedModel, entity, modelConfig, mainPart, renderedModels, detectedTexture, forceFieldCheck, fullModelIcon, mrde, hardcodedMainPartAliases, hardcodedModelPartsFields);
                renderedSomething = renderedSomething || !renderedModels.isEmpty();
                continue;
            }
            if (mainRenderedModels.isEmpty()) continue;
            VertexConsumer vertexBuilder = this.setupModelRenderType(renderTypeBuffer, detectedTexture, mrde);
            this.entityModelPartsRenderer.renderPartsIterable(mainRenderedModels, matrixStack, vertexBuilder, new ArrayList<ModelPart>(), mainPart, modelConfig.modelPartsRotationReset, mrde);
            renderTypeBuffer.m_109911_();
        }
        if (!mainRenderedModels.isEmpty() && modelConfig.layersAllowed && (extraLayer = EntityIconDefinitions.getCustomLayer(entityRenderer, entity)) != null) {
            mainPart = extraLayer.render(matrixStack, renderTypeBuffer, entityRenderer, entity, mainEntityModel, this.entityModelPartsRenderer, mainRenderedModels, mainPart, modelConfig, mainMrde);
        }
        return renderedSomething;
    }

    private boolean resetModelRotations(Entity entity, EntityModel model) {
        try {
            model.m_6839_(entity, 0.0f, 0.0f, 1.0f);
            model.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_, 0.0f, 0.0f);
            OpenGLException.checkGLError();
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private EntityModel getEntityRendererModel(EntityRenderer entityRenderer) {
        if (entityRenderer instanceof LivingEntityRenderer) {
            return ((LivingEntityRenderer)entityRenderer).m_7200_();
        }
        if (entityRenderer instanceof EnderDragonRenderer) {
            return (EntityModel)Misc.getReflectFieldValue(entityRenderer, this.enderDragonModelField);
        }
        return null;
    }

    private Object resolveModelRoot(EntityModel<?> model, ArrayList<ArrayList<String>> rootPath, Entity entity) {
        ResolvedFieldModelRootPathListener resolvedFieldModelRootPathListener = this.resolvedFieldModelRootPathListener;
        Object currentChainNode = model;
        for (ArrayList<String> pathStep : rootPath) {
            resolvedFieldModelRootPathListener.prepare();
            EntityIconModelFieldResolver.searchSuperclassFields(currentChainNode, pathStep, resolvedFieldModelRootPathListener, ONE_OBJECT_ARRAY);
            currentChainNode = resolvedFieldModelRootPathListener.getCurrentNode();
            if (currentChainNode != null && !resolvedFieldModelRootPathListener.failed()) continue;
            System.out.println(String.format("The following entity icon model root path step couldn't be resolved for %s:", EntityType.m_20613_((EntityType)entity.m_6095_())));
            pathStep.forEach(System.out::println);
            return null;
        }
        return currentChainNode;
    }
}

