/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.ISettingEntry;
import xaero.common.gui.ScreenBase;
import xaero.common.gui.TooltipButton;

public class ScreenSwitchSettingEntry
implements ISettingEntry {
    private String name;
    private BiFunction<Screen, Screen, Screen> screenFactory;
    private Supplier<CursorBox> tooltipSupplier;
    private boolean active;

    public ScreenSwitchSettingEntry(String name, BiFunction<Screen, Screen, Screen> screenFactoryFromCurrentAndEscape, CursorBox tooltip, boolean active) {
        this.name = name;
        this.screenFactory = screenFactoryFromCurrentAndEscape;
        this.tooltipSupplier = () -> tooltip;
        this.active = active;
    }

    @Override
    public String getStringForSearch(Options mcOptions) {
        CursorBox entryTooltip = this.tooltipSupplier == null ? null : this.tooltipSupplier.get();
        return I18n.m_118938_((String)this.name, (Object[])new Object[0]) + " " + this.name.replace("gui.xaero", "") + (String)(entryTooltip != null ? " " + entryTooltip.getFullCode().replace("gui.xaero", "") + " " + I18n.m_118938_((String)entryTooltip.getFullCode(), (Object[])new Object[0]) : "");
    }

    @Override
    public AbstractWidget createWidget(Options mcOptions, int x, int y, int w, boolean canEditIngameSettings) {
        TooltipButton button = new TooltipButton(x, y, w, 20, (Component)new TranslatableComponent(this.name), b -> {
            Minecraft mc = Minecraft.m_91087_();
            Screen current = mc.f_91080_;
            Screen currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
            Screen targetScreen = this.screenFactory.apply(current, currentEscScreen);
            if (current instanceof ScreenBase) {
                ((ScreenBase)current).onExit(targetScreen);
            } else {
                mc.m_91152_(targetScreen);
            }
        }, this.tooltipSupplier);
        button.f_93623_ = this.active;
        return button;
    }

    public BiFunction<Screen, Screen, Screen> getScreenFactory() {
        return this.screenFactory;
    }
}

