/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.common.interfaces.render.InterfaceRenderer;

public class CustomRenderTypes
extends RenderType {
    private static final RenderStateShard.OutputStateShard KEEP_TARGET = new RenderStateShard.OutputStateShard("xaero_keep_target", () -> {}, () -> {});
    protected static final RenderStateShard.TransparencyStateShard TRANSLUCENT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_translucent_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    protected static final RenderStateShard.TransparencyStateShard LINES_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("xaero_lines_transparency", () -> {
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.m_69461_();
        RenderSystem.m_69453_();
    });
    protected static final RenderStateShard.LayeringStateShard POLYGON_OFFSET_LAYERING = new RenderStateShard.LayeringStateShard("xaero_polygon_offset_layering", () -> {
        RenderSystem.m_69863_((float)0.0f, (float)10.0f);
        RenderSystem.m_69486_();
    }, () -> {
        RenderSystem.m_69863_((float)0.0f, (float)0.0f);
        RenderSystem.m_69469_();
    });
    public static final RenderType GUI_BILINEAR;
    public static final RenderType GUI_NEAREST;
    public static final RenderType COLORED_WAYPOINTS_BGS;
    public static final RenderType MAP_CHUNK_OVERLAY;
    public static final RenderType MAP_LINES;
    public static final RenderType RADAR_NAME_BGS;

    public static RenderType entityIconRenderType(ResourceLocation texture, EntityIconLayerPhases layerPhases) {
        ImmutableList<RenderStateShard> rendertype$state = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)layerPhases.texture).transparency(layerPhases.transparency).shader(layerPhases.shader).depthTest(layerPhases.depthTest).writeMaskState(layerPhases.writeMask).cull(layerPhases.cull).lightmap(f_110152_).overlay(f_110154_).target(KEEP_TARGET).build();
        return new MultiPhaseRenderType("xaero_entity_icon", DefaultVertexFormat.f_85812_, VertexFormat.Mode.QUADS, 256, true, true, rendertype$state);
    }

    private CustomRenderTypes(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static RenderStateShard.TransparencyStateShard getTransparencyPhase(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        return new RenderStateShard.TransparencyStateShard("xaero_custom_transparency", () -> {
            RenderSystem.m_69478_();
            RenderSystem.m_69411_((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
        }, () -> {
            RenderSystem.m_69461_();
            RenderSystem.m_69453_();
        });
    }

    public static EntityIconLayerPhases getBasicEntityIconLayerPhases(ResourceLocation texture) {
        return new EntityIconLayerPhases(new RenderStateShard.TextureStateShard(texture, false, false), TRANSLUCENT_TRANSPARENCY, f_110113_, f_110114_, f_110110_, f_173066_);
    }

    static /* synthetic */ RenderStateShard.EmptyTextureStateShard access$000() {
        return f_110147_;
    }

    static /* synthetic */ RenderStateShard.ShaderStateShard access$100() {
        return f_173096_;
    }

    static /* synthetic */ RenderStateShard.TransparencyStateShard access$200() {
        return f_110134_;
    }

    static /* synthetic */ RenderStateShard.DepthTestStateShard access$300() {
        return f_110113_;
    }

    static /* synthetic */ RenderStateShard.CullStateShard access$400() {
        return f_110158_;
    }

    static /* synthetic */ RenderStateShard.LightmapStateShard access$500() {
        return f_110153_;
    }

    static /* synthetic */ RenderStateShard.OverlayStateShard access$600() {
        return f_110155_;
    }

    static /* synthetic */ RenderStateShard.LayeringStateShard access$700() {
        return f_110117_;
    }

    static /* synthetic */ RenderStateShard.OutputStateShard access$800() {
        return f_110123_;
    }

    static /* synthetic */ RenderStateShard.TexturingStateShard access$900() {
        return f_110148_;
    }

    static /* synthetic */ RenderStateShard.WriteMaskStateShard access$1000() {
        return f_110114_;
    }

    static /* synthetic */ RenderStateShard.LineStateShard access$1100() {
        return f_110130_;
    }

    static {
        ImmutableList<RenderStateShard> multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InterfaceRenderer.guiTextures, false, false)).transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.POSITION_COLOR_TEX)).cull(f_110110_).target(KEEP_TARGET).build();
        GUI_NEAREST = new MultiPhaseRenderType("xaero_gui_nearest", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().texture((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(InterfaceRenderer.guiTextures, true, false)).transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.POSITION_COLOR_TEX)).cull(f_110110_).target(KEEP_TARGET).build();
        GUI_BILINEAR = new MultiPhaseRenderType("xaero_gui_bilinear", DefaultVertexFormat.f_85818_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.POSITION_COLOR)).target(KEEP_TARGET).layering(POLYGON_OFFSET_LAYERING).build();
        COLORED_WAYPOINTS_BGS = new MultiPhaseRenderType("xaero_colored_waypoints", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.POSITION_COLOR)).target(KEEP_TARGET).layering(POLYGON_OFFSET_LAYERING).build();
        RADAR_NAME_BGS = new MultiPhaseRenderType("xaero_radar_name_bg", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(TRANSLUCENT_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.POSITION_COLOR)).target(KEEP_TARGET).build();
        MAP_CHUNK_OVERLAY = new MultiPhaseRenderType("xaero_chunk_overlay", DefaultVertexFormat.f_85815_, VertexFormat.Mode.QUADS, 256, false, false, multiPhaseParameters);
        multiPhaseParameters = new MultiPhaseBuilder().transparency(LINES_TRANSPARENCY).shader(new RenderStateShard.ShaderStateShard(() -> MinimapShaders.FRAMEBUFFER_LINES)).target(KEEP_TARGET).build();
        MAP_LINES = new MultiPhaseRenderType("xaero_lines", DefaultVertexFormat.f_166851_, VertexFormat.Mode.LINES, 256, false, false, multiPhaseParameters);
    }

    static class MultiPhaseBuilder {
        private RenderStateShard.EmptyTextureStateShard texture = CustomRenderTypes.access$000();
        private RenderStateShard.ShaderStateShard shader = CustomRenderTypes.access$100();
        private RenderStateShard.TransparencyStateShard transparency = CustomRenderTypes.access$200();
        private RenderStateShard.DepthTestStateShard depthTest = CustomRenderTypes.access$300();
        private RenderStateShard.CullStateShard cull = CustomRenderTypes.access$400();
        private RenderStateShard.LightmapStateShard lightmap = CustomRenderTypes.access$500();
        private RenderStateShard.OverlayStateShard overlay = CustomRenderTypes.access$600();
        private RenderStateShard.LayeringStateShard layering = CustomRenderTypes.access$700();
        private RenderStateShard.OutputStateShard target = CustomRenderTypes.access$800();
        private RenderStateShard.TexturingStateShard texturing = CustomRenderTypes.access$900();
        private RenderStateShard.WriteMaskStateShard writeMaskState = CustomRenderTypes.access$1000();
        private RenderStateShard.LineStateShard lineWidth = CustomRenderTypes.access$1100();

        MultiPhaseBuilder() {
        }

        public MultiPhaseBuilder texture(RenderStateShard.EmptyTextureStateShard texture) {
            this.texture = texture;
            return this;
        }

        public MultiPhaseBuilder shader(RenderStateShard.ShaderStateShard shader) {
            this.shader = shader;
            return this;
        }

        public MultiPhaseBuilder transparency(RenderStateShard.TransparencyStateShard transparency) {
            this.transparency = transparency;
            return this;
        }

        public MultiPhaseBuilder depthTest(RenderStateShard.DepthTestStateShard depthTest) {
            this.depthTest = depthTest;
            return this;
        }

        public MultiPhaseBuilder cull(RenderStateShard.CullStateShard cull) {
            this.cull = cull;
            return this;
        }

        public MultiPhaseBuilder lightmap(RenderStateShard.LightmapStateShard lightmap) {
            this.lightmap = lightmap;
            return this;
        }

        public MultiPhaseBuilder overlay(RenderStateShard.OverlayStateShard overlay) {
            this.overlay = overlay;
            return this;
        }

        public MultiPhaseBuilder layering(RenderStateShard.LayeringStateShard layering) {
            this.layering = layering;
            return this;
        }

        public MultiPhaseBuilder target(RenderStateShard.OutputStateShard target) {
            this.target = target;
            return this;
        }

        public MultiPhaseBuilder texturing(RenderStateShard.TexturingStateShard texturing) {
            this.texturing = texturing;
            return this;
        }

        public MultiPhaseBuilder writeMaskState(RenderStateShard.WriteMaskStateShard writeMaskState) {
            this.writeMaskState = writeMaskState;
            return this;
        }

        public MultiPhaseBuilder lineWidth(RenderStateShard.LineStateShard lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        public ImmutableList<RenderStateShard> build() {
            return ImmutableList.of((Object)this.texture, (Object)this.shader, (Object)this.transparency, (Object)this.depthTest, (Object)this.cull, (Object)this.lightmap, (Object)this.overlay, (Object)this.layering, (Object)this.target, (Object)this.texturing, (Object)this.writeMaskState, (Object)this.lineWidth, (Object[])new RenderStateShard[0]);
        }
    }

    public static class EntityIconLayerPhases {
        public RenderStateShard.TextureStateShard texture;
        public RenderStateShard.TransparencyStateShard transparency;
        public RenderStateShard.DepthTestStateShard depthTest;
        public RenderStateShard.WriteMaskStateShard writeMask;
        public RenderStateShard.CullStateShard cull;
        public RenderStateShard.ShaderStateShard shader;

        public EntityIconLayerPhases(Object texture, Object transparency, Object depthTest, Object writeMask, Object cull, Object shader) {
            this.texture = (RenderStateShard.TextureStateShard)texture;
            this.transparency = (RenderStateShard.TransparencyStateShard)transparency;
            this.depthTest = (RenderStateShard.DepthTestStateShard)depthTest;
            this.writeMask = (RenderStateShard.WriteMaskStateShard)writeMask;
            this.cull = (RenderStateShard.CullStateShard)cull;
            this.shader = (RenderStateShard.ShaderStateShard)shader;
        }
    }

    private static class MultiPhaseRenderType
    extends CustomRenderTypes {
        public MultiPhaseRenderType(String name, VertexFormat vertexFormat, VertexFormat.Mode drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, ImmutableList<RenderStateShard> phases) {
            super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, () -> phases.forEach(RenderStateShard::m_110185_), () -> phases.forEach(RenderStateShard::m_110188_));
        }
    }
}

