/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.task.GetServerDetailsTask;
import java.io.IOException;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.XaeroMinimapCore;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiEditMode;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWidgetUpdateAll;
import xaero.common.interfaces.pushbox.IPotionEffectsPushBox;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.patreon.Patreon;
import xaero.common.settings.ModSettings;

public class ForgeEventHandler {
    private IXaeroMinimap modMain;
    private Screen lastGuiOpen;
    private Field realmsTaskField;
    private Field realmsTaskServerField;
    public boolean crosshairDisabledByThisMod = false;
    public RealmsServer latestRealm;

    public ForgeEventHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    @SubscribeEvent
    public void handleGuiOpenEvent(ScreenOpenEvent event) {
        if (event.getScreen() instanceof OptionsScreen) {
            if (!ModSettings.settingsButton) {
                return;
            }
            event.setScreen((Screen)this.modMain.getGuiHelper().getMyOptions());
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (event.getScreen() instanceof TitleScreen || event.getScreen() instanceof JoinMultiplayerScreen) {
            this.modMain.getSettings().resetServerSettings();
        }
        Minecraft mc = Minecraft.m_91087_();
        if (event.getScreen() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                GetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    try {
                        this.realmsTaskField = RealmsLongRunningMcoTaskScreen.class.getDeclaredField("f_88773_");
                    }
                    catch (NoSuchFieldException nsfe) {
                        this.realmsTaskField = RealmsLongRunningMcoTaskScreen.class.getDeclaredField("task");
                    }
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    try {
                        this.realmsTaskServerField = GetServerDetailsTask.class.getDeclaredField("f_90327_");
                    }
                    catch (NoSuchFieldException nsfe) {
                        this.realmsTaskServerField = GetServerDetailsTask.class.getDeclaredField("server");
                    }
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)event.getScreen())) instanceof GetServerDetailsTask && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (GetServerDetailsTask)task)) != null && (this.latestRealm == null || realm.f_87473_ != this.latestRealm.f_87473_)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ((event.getScreen() instanceof GuiAddWaypoint || event.getScreen() instanceof GuiWaypoints) && (mc.f_91074_.m_21023_(Effects.NO_WAYPOINTS) || mc.f_91074_.m_21023_(Effects.NO_WAYPOINTS_BENEFICIAL) || mc.f_91074_.m_21023_(Effects.NO_WAYPOINTS_HARMFUL))) {
            event.setScreen(null);
        }
        this.lastGuiOpen = event.getScreen();
    }

    protected void handleRenderGameOverlayEventPreLayerOverridable(RenderGameOverlayEvent.PreLayer event) {
    }

    @SubscribeEvent
    public void handleRenderGameOverlayEventPre(RenderGameOverlayEvent.Pre event) {
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)256)) {
            GuiEditMode.cancel(this.modMain.getInterfaces());
        }
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPostLayer(RenderGameOverlayEvent.PostLayer event) {
        IPotionEffectsPushBox potionEffectsPushBox;
        if (event.getOverlay() == ForgeIngameGui.POTION_ICONS_ELEMENT && (potionEffectsPushBox = this.modMain.getInterfaces().getPotionEffectPushBox()) != null) {
            potionEffectsPushBox.setActive(true);
        }
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPreLayer(RenderGameOverlayEvent.PreLayer event) {
        this.handleRenderGameOverlayEventPreLayerOverridable(event);
    }

    @SubscribeEvent
    protected void handleRenderGameOverlayEventPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && this.crosshairDisabledByThisMod) {
            OverlayRegistry.enableOverlay((IIngameOverlay)ForgeIngameGui.CROSSHAIR_ELEMENT, (boolean)true);
            this.crosshairDisabledByThisMod = false;
        }
    }

    @SubscribeEvent
    public void handleClientSendChatEvent(ClientChatEvent e) {
        if (e.getMessage().startsWith("xaero_waypoint_add:")) {
            String[] args = e.getMessage().split(":");
            e.setMessage("");
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointAdd(args);
        } else if (e.getMessage().equals("/xaero_tp_anyway")) {
            e.setMessage("");
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointsManager().teleportAnyway();
        }
    }

    @SubscribeEvent
    public void handleClientChatReceivedEvent(ClientChatReceivedEvent e) {
        if (e.getMessage() == null) {
            return;
        }
        Component text = e.getMessage();
        String textString = text.getString();
        if (textString.contains("xaero_waypoint:") || textString.contains("xaero-waypoint:")) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            minimapSession.getWaypointSharing().onWaypointReceived(textString, e);
        }
    }

    @SubscribeEvent
    public void handleRenderWorldLastEvent(RenderLevelLastEvent event) {
        XaeroMinimapCore.onProjectionMatrix(event.getProjectionMatrix());
        XaeroMinimapCore.onWorldModelViewMatrix(event.getPoseStack());
    }

    @SubscribeEvent
    public void handleDrawScreenEventPost(ScreenEvent.DrawScreenEvent.Post event) {
        if (Patreon.needsNotification() && event.getScreen() instanceof TitleScreen) {
            Minecraft.m_91087_().m_91152_((Screen)new GuiWidgetUpdateAll(this.modMain));
        } else if (this.modMain.isOutdated()) {
            this.modMain.setOutdated(false);
        }
    }

    public void handlePlayerSetSpawn(Level world, BlockPos spawn) {
        XaeroMinimapSession minimapSession;
        if (world instanceof ClientLevel && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            minimapSession.getWaypointsManager().setCurrentSpawn(spawn, (ClientLevel)world);
        }
    }

    @SubscribeEvent
    public void handleRenderPlayerEventPost(RenderPlayerEvent.Post event) {
        if (this.modMain.getSupportMods().optifine) {
            Patreon.renderCapeFallback(this.modMain.getFileLayoutID(), event);
        }
    }

    public Object getLastGuiOpen() {
        return this.lastGuiOpen;
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        XaeroMinimapSession minimapSession;
        if (event.getWorld() instanceof ClientLevel && (minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
            MinimapProcessor minimap = minimapSession.getMinimapProcessor();
            minimap.getEntityRadar().updateRadar(null, null, null, minimap);
        }
    }
}

