/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.data;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import xaero.common.category.setting.ObjectCategorySetting;
import xaero.common.category.ui.data.GuiCategoryUIEditorCategoryData;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorOptionsData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorSimpleButtonData;
import xaero.common.category.ui.data.options.range.setting.IGuiCategoryUIEditorSettingData;
import xaero.common.category.ui.data.options.range.setting.IGuiCategoryUIEditorSettingDataBuilder;
import xaero.common.category.ui.data.options.text.GuiCategoryUIEditorTextFieldOptionsData;
import xaero.common.category.ui.entry.CategorySettingsListEntryWidget;
import xaero.common.category.ui.entry.CategorySettingsListEntryWrapper;
import xaero.common.category.ui.entry.CategorySettingsListMainEntryFactory;
import xaero.common.category.ui.entry.widget.CategorySettingsButton;
import xaero.common.graphics.CursorBox;
import xaero.common.misc.ListFactory;
import xaero.common.misc.MapFactory;

public class GuiCategoryUIEditorSettingsData<SETTING_DATA extends GuiCategoryUIEditorOptionsData<?>>
extends GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> {
    private final Map<ObjectCategorySetting<?>, SETTING_DATA> settings;
    private final List<SETTING_DATA> settingList;
    private boolean toBeDeleted;
    private final GuiCategoryUIEditorSimpleButtonData deleteButton;
    private final GuiCategoryUIEditorSimpleButtonData protectionButton;
    private final GuiCategoryUIEditorTextFieldOptionsData nameOption;
    private final ListFactory listFactory;
    private final boolean rootSettings;
    private boolean protection;

    protected GuiCategoryUIEditorSettingsData(@Nonnull Map<ObjectCategorySetting<?>, SETTING_DATA> settings, @Nonnull List<SETTING_DATA> settingList, @Nonnull GuiCategoryUIEditorSimpleButtonData deleteButton, @Nonnull GuiCategoryUIEditorSimpleButtonData protectionButton, @Nonnull GuiCategoryUIEditorTextFieldOptionsData nameOption, @Nonnull ListFactory listFactory, boolean rootSettings, boolean movable, @Nonnull CategorySettingsListMainEntryFactory listEntryFactory, BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>>, Supplier<CursorBox>> tooltipSupplier, boolean protection) {
        super(movable, listEntryFactory, tooltipSupplier);
        this.settings = settings;
        this.settingList = settingList;
        this.listFactory = listFactory;
        this.rootSettings = rootSettings;
        this.deleteButton = deleteButton;
        this.protectionButton = protectionButton;
        this.nameOption = nameOption;
        this.protection = protection;
    }

    public Map<ObjectCategorySetting<?>, SETTING_DATA> getSettings() {
        return this.settings;
    }

    public IGuiCategoryUIEditorSettingData<?> getSettingData(ObjectCategorySetting<?> setting) {
        return (IGuiCategoryUIEditorSettingData)this.settings.get(setting);
    }

    public boolean isRootSettings() {
        return this.rootSettings;
    }

    public boolean isToBeDeleted() {
        return this.toBeDeleted;
    }

    public void setToBeDeleted() {
        this.toBeDeleted = true;
    }

    public boolean getProtection() {
        return this.protection;
    }

    public void setProtected(boolean protection) {
        this.protection = protection;
    }

    @Override
    public List<GuiCategoryUIEditorExpandableData<?>> getSubExpandables() {
        List<GuiCategoryUIEditorExpandableData<?>> result = this.listFactory.get();
        result.addAll(this.settingList);
        if (!this.protection) {
            result.add(this.nameOption);
        }
        result.add(this.deleteButton);
        result.add(this.protectionButton);
        return result;
    }

    @Override
    public String getDisplayName() {
        return I18n.m_118938_((String)"gui.xaero_category_settings", (Object[])new Object[0]);
    }

    public GuiCategoryUIEditorTextFieldOptionsData getNameOption() {
        return this.nameOption;
    }

    public static final class FinalBuilder
    extends Builder<GuiCategoryUIEditorSettingsData<?>, FinalBuilder> {
        protected FinalBuilder(MapFactory mapFactory, ListFactory listFactory, List<ObjectCategorySetting<?>> allSettings) {
            super(mapFactory, listFactory, allSettings);
        }

        @Override
        protected GuiCategoryUIEditorSettingsData<?> buildInternally(List<IGuiCategoryUIEditorSettingData<?>> builtSettingData, Map<ObjectCategorySetting<?>, IGuiCategoryUIEditorSettingData<?>> builtSettingsDataMap) {
            GuiCategoryUIEditorSettingsData result = new GuiCategoryUIEditorSettingsData(builtSettingsDataMap, builtSettingData, this.deleteButtonBuilder.build(), this.protectionButtonBuilder.build(), this.nameOptionBuilder.build(), this.listFactory, this.rootSettings, this.movable, this.listEntryFactory, this.tooltipSupplier, this.protection);
            return result;
        }
    }

    public static abstract class Builder<SD extends GuiCategoryUIEditorSettingsData<?>, SDB extends Builder<SD, SDB>>
    extends GuiCategoryUIEditorExpandableData.Builder<GuiCategoryUIEditorExpandableData<?>, Builder<SD, SDB>> {
        protected final SDB self = this;
        protected final Map<ObjectCategorySetting<?>, IGuiCategoryUIEditorSettingDataBuilder<?, ?>> settingMap;
        protected final List<IGuiCategoryUIEditorSettingDataBuilder<?, ?>> settingList;
        protected final GuiCategoryUIEditorSimpleButtonData.Builder deleteButtonBuilder;
        protected final GuiCategoryUIEditorSimpleButtonData.Builder protectionButtonBuilder;
        protected final GuiCategoryUIEditorTextFieldOptionsData.Builder nameOptionBuilder;
        protected final MapFactory mapFactory;
        protected final ListFactory listFactory;
        protected boolean rootSettings;
        protected boolean protection;

        protected Builder(MapFactory mapFactory, ListFactory listFactory, List<ObjectCategorySetting<?>> allSettings) {
            this.settingMap = mapFactory.get();
            this.settingList = listFactory.get();
            this.deleteButtonBuilder = GuiCategoryUIEditorSimpleButtonData.Builder.getDefault();
            this.protectionButtonBuilder = GuiCategoryUIEditorSimpleButtonData.Builder.getDefault();
            this.nameOptionBuilder = GuiCategoryUIEditorTextFieldOptionsData.Builder.getDefault(listFactory);
            this.mapFactory = mapFactory;
            this.listFactory = listFactory;
            for (ObjectCategorySetting<?> setting : allSettings) {
                this.addSetting(setting);
            }
        }

        private <V> void addSetting(ObjectCategorySetting<V> setting) {
            IGuiCategoryUIEditorSettingDataBuilder builder = setting.getSettingUIType().getSettingDataBuilderFactory().apply(this.listFactory).setSetting(setting);
            this.settingMap.put(setting, builder);
            this.settingList.add(builder);
        }

        @Override
        public SDB setDefault() {
            super.setDefault();
            for (IGuiCategoryUIEditorSettingDataBuilder<?, ?> builder : this.settingList) {
                builder.setSettingValue(null);
            }
            this.setRootSettings(false);
            this.setListEntryFactory((data, parent, index, lineType, rowList, screenWidth, isFinalExpanded) -> new CategorySettingsListEntryWrapper((x, y, width, height, root) -> new CategorySettingsListEntryWidget(x, y, width, height, index, rowList, root, (AbstractWidget)new CategorySettingsButton(parent, () -> data.getDisplayName(), true, 216, 20, b -> data.getExpandAction(rowList).run(), rowList), data.getTooltipSupplier(parent)), screenWidth, index, rowList, lineType, data));
            this.nameOptionBuilder.setDefault();
            this.deleteButtonBuilder.setDefault().setDisplayName(I18n.m_118938_((String)"gui.xaero_category_delete", (Object[])new Object[0])).setCallback((parent, bd, rl) -> {
                GuiCategoryUIEditorSettingsData settings = (GuiCategoryUIEditorSettingsData)parent;
                Minecraft mc = Minecraft.m_91087_();
                Screen configScreen = mc.f_91080_;
                mc.m_91152_((Screen)new ConfirmScreen(result -> {
                    if (result) {
                        settings.setToBeDeleted();
                    }
                    mc.m_91152_(configScreen);
                }, (Component)new TranslatableComponent("gui.xaero_category_delete_confirm"), (Component)new TranslatableComponent(settings.getNameOption().getResult()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)))));
            }).setIsActiveSupplier((parent, data) -> !((GuiCategoryUIEditorSettingsData)parent).getProtection());
            this.protectionButtonBuilder.setDefault().setDisplayName("").setCallback((parent, bd, rl) -> {
                GuiCategoryUIEditorSettingsData settings = (GuiCategoryUIEditorSettingsData)parent;
                boolean currentlyProtected = settings.getProtection();
                Minecraft mc = Minecraft.m_91087_();
                Screen configScreen = mc.f_91080_;
                mc.m_91152_((Screen)new ConfirmScreen(result -> {
                    if (result) {
                        settings.setProtected(!settings.getProtection());
                    }
                    mc.m_91152_(configScreen);
                }, (Component)new TranslatableComponent(currentlyProtected ? "gui.xaero_category_disable_protection_confirm" : "gui.xaero_category_enable_protection_confirm"), (Component)new TranslatableComponent(settings.getNameOption().getResult()).m_130948_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)(currentlyProtected ? ChatFormatting.RED : ChatFormatting.GREEN))))));
            }).setMessageSupplier((parent, bd) -> () -> ((GuiCategoryUIEditorSettingsData)parent).getProtection() ? I18n.m_118938_((String)"gui.xaero_category_disable_protection", (Object[])new Object[0]) : I18n.m_118938_((String)"gui.xaero_category_enable_protection", (Object[])new Object[0])).setIsActiveSupplier((parent, bd) -> !((GuiCategoryUIEditorSettingsData)parent).isRootSettings()).setTooltipSupplier((parent, bd) -> {
                CursorBox protectionTooltip = new CursorBox(I18n.m_118938_((String)"gui.xaero_box_category_protection", (Object[])new Object[0]));
                return () -> protectionTooltip;
            });
            this.setTooltipSupplier((parent, data) -> {
                if (parent instanceof GuiCategoryUIEditorCategoryData) {
                    GuiCategoryUIEditorCategoryData category = (GuiCategoryUIEditorCategoryData)parent;
                    CursorBox tooltip = new CursorBox(I18n.m_118938_((String)"gui.xaero_box_category_settings", (Object[])new Object[]{I18n.m_118938_((String)category.getDisplayName(), (Object[])new Object[0])}));
                    tooltip.setAutoLinebreak(false);
                    return () -> tooltip;
                }
                return null;
            });
            return this.self;
        }

        public <T> SDB setSettingValue(ObjectCategorySetting<T> setting, T value) {
            IGuiCategoryUIEditorSettingDataBuilder<?, ?> settingBuilder = this.settingMap.get(setting);
            settingBuilder.setSettingValue(value);
            return this.self;
        }

        public SDB setRootSettings(boolean rootSettings) {
            this.rootSettings = rootSettings;
            return this.self;
        }

        public SDB setProtection(boolean protection) {
            this.protection = protection;
            return this.self;
        }

        public GuiCategoryUIEditorTextFieldOptionsData.Builder getNameOptionBuilder() {
            return this.nameOptionBuilder;
        }

        public GuiCategoryUIEditorSimpleButtonData.Builder getDeleteButtonBuilder() {
            return this.deleteButtonBuilder;
        }

        @Override
        protected GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorExpandableData<?>> buildInternally() {
            List builtSettingData = this.settingList.stream().map(b -> b.setRootSettings(this.rootSettings)).map(IGuiCategoryUIEditorSettingDataBuilder::build).collect(this.listFactory::get, List::add, List::addAll);
            Map<ObjectCategorySetting<?>, IGuiCategoryUIEditorSettingData<?>> builtSettingsDataMap = this.mapFactory.get();
            for (IGuiCategoryUIEditorSettingData sd : builtSettingData) {
                if (!(sd instanceof GuiCategoryUIEditorOptionsData)) {
                    throw new IllegalStateException("illegal setting data class! " + sd.getClass());
                }
                builtSettingsDataMap.put(sd.getSetting(), sd);
            }
            return this.buildInternally(builtSettingData, builtSettingsDataMap);
        }

        protected abstract SD buildInternally(List<IGuiCategoryUIEditorSettingData<?>> var1, Map<ObjectCategorySetting<?>, IGuiCategoryUIEditorSettingData<?>> var2);
    }
}

