/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.serialization.data;

import com.google.gson.Gson;
import javax.annotation.Nonnull;
import xaero.common.category.serialization.data.ObjectCategoryData;
import xaero.common.category.serialization.data.ObjectCategoryDataSerializer;

public final class ObjectCategoryDataGsonSerializer<D extends ObjectCategoryData<D>>
extends ObjectCategoryDataSerializer<D> {
    private final Gson gson;
    private final Class<D> dataClass;

    private ObjectCategoryDataGsonSerializer(@Nonnull Gson gson, Class<D> dataClass) {
        this.gson = gson;
        this.dataClass = dataClass;
    }

    @Override
    public String serialize(D data) {
        return this.gson.toJson(data);
    }

    @Override
    public D deserialize(String json) {
        return (D)((ObjectCategoryData)this.gson.fromJson(json, this.dataClass));
    }

    public static final class Builder<D extends ObjectCategoryData<D>>
    extends ObjectCategoryDataSerializer.Builder<D> {
        private final Gson gson;
        private final Class<D> dataClass;

        public Builder(Gson gson, Class<D> dataClass) {
            this.gson = gson;
            this.dataClass = dataClass;
        }

        @Override
        public Builder<D> setDefault() {
            super.setDefault();
            return this;
        }

        @Override
        public ObjectCategoryDataGsonSerializer<D> build() {
            return new ObjectCategoryDataGsonSerializer<D>(this.gson, this.dataClass);
        }

        public static <D extends ObjectCategoryData<D>> Builder<D> getDefault(Gson gson, Class<D> dataClass) {
            return new Builder<D>(gson, dataClass).setDefault();
        }
    }
}

