/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.integration.terrablender;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import terrablender.api.BiomeProvider;
import terrablender.api.BiomeProviders;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.TBClimate;
import vazkii.quark.base.handler.UndergroundBiomeHandler;

public class TerraBlenderIntegration
implements Supplier<UndergroundBiomeHandler.Proxy> {
    private TBProxy proxy;

    @Override
    public UndergroundBiomeHandler.Proxy get() {
        if (this.proxy == null) {
            this.proxy = new TBProxy();
        }
        return this.proxy;
    }

    class TBProxy
    extends UndergroundBiomeHandler.Proxy {
        TBProxy() {
        }

        @Override
        public void init(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> BiomeProviders.register((BiomeProvider)new QuarkBiomeProvider()));
        }

        @Override
        public void addUndergroundBiomes(OverworldBiomeBuilder builder, Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> consumer) {
        }
    }

    class QuarkBiomeProvider
    extends BiomeProvider {
        public QuarkBiomeProvider() {
            super(new ResourceLocation("quark", "biome_provider"), 1);
        }

        public void addOverworldBiomes(Registry<Biome> registry, Consumer<Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>> mapper) {
            for (UndergroundBiomeHandler.UndergroundBiomeSkeleton skeleton : TerraBlenderIntegration.this.proxy.skeletons) {
                if (!skeleton.module().enabled) continue;
                ResourceKey resourceKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)skeleton.biome());
                mapper.accept((Pair<TBClimate.ParameterPoint, ResourceKey<Biome>>)Pair.of((Object)this.convertParams(skeleton.climate()), (Object)resourceKey));
            }
        }

        private TBClimate.ParameterPoint convertParams(Climate.ParameterPoint vanilla) {
            return TBClimate.parameters((Climate.Parameter)vanilla.f_186863_(), (Climate.Parameter)vanilla.f_186864_(), (Climate.Parameter)vanilla.f_186865_(), (Climate.Parameter)vanilla.f_186866_(), (Climate.Parameter)vanilla.f_186868_(), (Climate.Parameter)vanilla.f_186867_(), (Climate.Parameter)BiomeProviderUtils.getUniquenessParameter((int)this.getIndex()), (float)vanilla.f_186869_());
        }
    }
}

