/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.integration.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.addons.oddities.client.screen.CrateScreen;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.building.module.VariantFurnacesModule;
import vazkii.quark.content.tools.item.AncientTomeItem;
import vazkii.quark.content.tools.module.AncientTomesModule;
import vazkii.quark.content.tools.module.ColorRunesModule;
import vazkii.quark.content.tools.module.PickarangModule;
import vazkii.quark.content.tweaks.recipe.ElytraDuplicationRecipe;
import vazkii.quark.integration.jei.ElytraDuplicationExtension;

@JeiPlugin
public class QuarkJeiPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("quark", "quark");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{AncientTomesModule.ancient_tome});
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        registration.getCraftingCategory().addCategoryExtension(ElytraDuplicationRecipe.class, ElytraDuplicationExtension::new);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        if (ModuleLoader.INSTANCE.isModuleEnabled(AncientTomesModule.class)) {
            this.registerAncientTomeAnvilRecipes(registration, factory);
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(PickarangModule.class)) {
            this.registerPickarangAnvilRepairs(registration, factory);
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(ColorRunesModule.class)) {
            this.registerRuneAnvilRecipes(registration, factory);
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (ModuleLoader.INSTANCE.isModuleEnabled(VariantFurnacesModule.class)) {
            ResourceLocation smelting = VanillaRecipeCategoryUid.FURNACE;
            ResourceLocation fuel = VanillaRecipeCategoryUid.FUEL;
            registration.addRecipeCatalyst(new ItemStack((ItemLike)VariantFurnacesModule.deepslateFurnace), new ResourceLocation[]{fuel, smelting});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)VariantFurnacesModule.blackstoneFurnace), new ResourceLocation[]{fuel, smelting});
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CrateScreen.class, (IGuiContainerHandler)new CrateGuiHandler());
    }

    private void registerAncientTomeAnvilRecipes(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        for (Enchantment enchant : AncientTomesModule.validEnchants) {
            EnchantmentInstance data = new EnchantmentInstance(enchant, enchant.m_6586_());
            recipes.add(factory.createAnvilRecipe(EnchantedBookItem.m_41161_((EnchantmentInstance)data), Collections.singletonList(AncientTomeItem.getEnchantedItemStack(data)), Collections.singletonList(EnchantedBookItem.m_41161_((EnchantmentInstance)new EnchantmentInstance(data.f_44947_, data.f_44948_ + 1)))));
        }
        registration.addRecipes(recipes, VanillaRecipeCategoryUid.ANVIL);
    }

    private void registerRuneAnvilRecipes(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        Random random = new Random();
        List used = Stream.of(Items.f_42388_, Items.f_42390_, Items.f_42391_, Items.f_42389_, Items.f_42392_, Items.f_42472_, Items.f_42473_, Items.f_42474_, Items.f_42475_, Items.f_42741_, Items.f_42740_, Items.f_42411_, Items.f_42717_, Items.f_42684_, Items.f_42523_, Items.f_42574_).map(item -> QuarkJeiPlugin.makeEnchantedDisplayItem(item, random)).collect(Collectors.toList());
        if (ModuleLoader.INSTANCE.isModuleEnabled(PickarangModule.class)) {
            used.add(QuarkJeiPlugin.makeEnchantedDisplayItem(PickarangModule.pickarang, random));
        }
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        for (Item rune : ColorRunesModule.runesTag.m_6497_()) {
            ItemStack runeStack = new ItemStack((ItemLike)rune);
            recipes.add(factory.createAnvilRecipe(used, Collections.singletonList(runeStack), used.stream().map(stack -> {
                ItemStack output = stack.m_41777_();
                ItemNBTHelper.setBoolean((ItemStack)output, (String)"quark:RuneAttached", (boolean)true);
                ItemNBTHelper.setCompound((ItemStack)output, (String)"quark:RuneColor", (CompoundTag)runeStack.serializeNBT());
                return output;
            }).collect(Collectors.toList())));
        }
        registration.addRecipes(recipes, VanillaRecipeCategoryUid.ANVIL);
    }

    private static ItemStack makeEnchantedDisplayItem(Item input, Random random) {
        ItemStack stack = new ItemStack((ItemLike)input);
        stack.m_41714_((Component)new TranslatableComponent("quark.jei.any_enchanted"));
        if (stack.getItemEnchantability() <= 0) {
            stack.m_41663_(Enchantments.f_44986_, 3);
            return stack;
        }
        return EnchantmentHelper.m_44877_((Random)random, (ItemStack)stack, (int)25, (boolean)false);
    }

    private void registerPickarangAnvilRepairs(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ItemStack nearlyBroken = new ItemStack((ItemLike)PickarangModule.pickarang);
        nearlyBroken.m_41721_(nearlyBroken.m_41776_());
        ItemStack veryDamaged = nearlyBroken.m_41777_();
        veryDamaged.m_41721_(veryDamaged.m_41776_() * 3 / 4);
        ItemStack damaged = nearlyBroken.m_41777_();
        damaged.m_41721_(damaged.m_41776_() * 2 / 4);
        IJeiAnvilRecipe materialRepair = factory.createAnvilRecipe(nearlyBroken, Collections.singletonList(new ItemStack((ItemLike)Items.f_42415_)), Collections.singletonList(veryDamaged));
        IJeiAnvilRecipe toolRepair = factory.createAnvilRecipe(veryDamaged, Collections.singletonList(veryDamaged), Collections.singletonList(damaged));
        registration.addRecipes(Arrays.asList(materialRepair, toolRepair), VanillaRecipeCategoryUid.ANVIL);
    }

    private static class CrateGuiHandler
    implements IGuiContainerHandler<CrateScreen> {
        private CrateGuiHandler() {
        }

        public List<Rect2i> getGuiExtraAreas(CrateScreen containerScreen) {
            return containerScreen.getExtraAreas();
        }
    }
}

