/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.interf.IBlockColorProvider;

public interface IMyaliteColorProvider
extends IBlockColorProvider {
    public static final PerlinSimplexNoise NOISE = new PerlinSimplexNoise((RandomSource)new LegacyRandomSource(4543543L), (List)ImmutableList.of((Object)-4, (Object)-3, (Object)-2, (Object)-1, (Object)0, (Object)1, (Object)2, (Object)3, (Object)4));

    @OnlyIn(value=Dist.CLIENT)
    default public BlockColor getBlockColor() {
        return (state, world, pos, tintIndex) -> IMyaliteColorProvider.getColor(pos, this.myaliteS(), this.myaliteB());
    }

    @OnlyIn(value=Dist.CLIENT)
    default public ItemColor getItemColor() {
        return (stack, tintIndex) -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ == null) {
                return IMyaliteColorProvider.getColor(BlockPos.f_121853_, this.myaliteS(), this.myaliteB());
            }
            BlockPos pos = mc.f_91074_.m_142538_();
            HitResult res = mc.f_91077_;
            if (res != null && res instanceof BlockHitResult) {
                pos = ((BlockHitResult)res).m_82425_();
            }
            return IMyaliteColorProvider.getColor(pos, this.myaliteS(), this.myaliteB());
        };
    }

    default public float myaliteS() {
        return 0.7f;
    }

    default public float myaliteB() {
        return 0.8f;
    }

    public static int getColor(BlockPos pos, float s, float b) {
        double sp = 0.15;
        double range = 0.3;
        double shift = 0.05;
        if (pos == null) {
            pos = BlockPos.f_121853_;
        }
        double x = (double)pos.m_123341_() * 0.15;
        double y = (double)pos.m_123342_() * 0.15;
        double z = (double)pos.m_123343_() * 0.15;
        double xv = x + Math.sin(z) * 2.0;
        double zv = z + Math.cos(x) * 2.0;
        double yv = y + Math.sin(y + 0.7853981633974483) * 2.0;
        double noise = NOISE.m_75449_(xv + yv, zv + yv * 2.0, false);
        double h = noise * 0.15 - 0.3 + 0.05;
        return Color.HSBtoRGB((float)h, s, b);
    }
}

