/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.mobs.entity.Foxhound;
import vazkii.quark.content.tweaks.ai.NuzzleGoal;
import vazkii.quark.content.tweaks.ai.WantLoveGoal;

@LoadModule(category=ModuleCategory.TWEAKS, hasSubscriptions=true)
public class PatTheDogsModule
extends QuarkModule {
    @Config(description="How many ticks it takes for a dog to want affection after being pet/tamed; leave -1 to disable")
    public static int dogsWantLove = -1;

    @SubscribeEvent
    public void onWolfAppear(EntityJoinWorldEvent event) {
        if (dogsWantLove > 0 && event.getEntity() instanceof Wolf) {
            Wolf wolf = (Wolf)event.getEntity();
            boolean alreadySetUp = wolf.f_21345_.m_148105_().stream().anyMatch(goal -> goal.m_26015_() instanceof WantLoveGoal);
            if (!alreadySetUp) {
                wolf.f_21345_.m_25352_(4, (Goal)new NuzzleGoal((TamableAnimal)wolf, 0.5, 16.0f, 2.0f, SoundEvents.f_12625_));
                wolf.f_21345_.m_25352_(5, (Goal)new WantLoveGoal((TamableAnimal)wolf, 0.2f));
            }
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getTarget() instanceof Wolf) {
            Wolf wolf = (Wolf)event.getTarget();
            Player player = event.getPlayer();
            if (player.m_20163_() && player.m_21205_().m_41619_()) {
                if (event.getHand() == InteractionHand.MAIN_HAND && WantLoveGoal.canPet((TamableAnimal)wolf)) {
                    if (player.f_19853_ instanceof ServerLevel) {
                        Vec3 pos = wolf.m_20182_();
                        ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123750_, pos.f_82479_, pos.f_82480_ + 0.5, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.1);
                        wolf.m_5496_(SoundEvents.f_12625_, 1.0f, 0.5f + (float)Math.random() * 0.5f);
                    } else {
                        player.m_6674_(InteractionHand.MAIN_HAND);
                    }
                    WantLoveGoal.setPetTime((TamableAnimal)wolf);
                    if (wolf instanceof Foxhound && !player.m_20069_() && !player.m_21023_(MobEffects.f_19607_) && !player.m_7500_()) {
                        player.m_20254_(5);
                    }
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onTame(AnimalTameEvent event) {
        if (event.getAnimal() instanceof Wolf) {
            Wolf wolf = (Wolf)event.getAnimal();
            WantLoveGoal.setPetTime((TamableAnimal)wolf);
        }
    }
}

