/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.client.emote;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.content.tweaks.client.emote.EmoteBase;
import vazkii.quark.content.tweaks.client.emote.ModelAccessor;

@OnlyIn(value=Dist.CLIENT)
public class EmoteState {
    private float[] states = new float[0];
    private final EmoteBase emote;

    public EmoteState(EmoteBase emote) {
        this.emote = emote;
    }

    public void save(HumanoidModel<?> model) {
        float[] values = new float[1];
        for (int i = 0; i < 21; ++i) {
            ModelAccessor.INSTANCE.getValues(model, i, values);
            this.states[i] = values[0];
        }
    }

    public void load(HumanoidModel<?> model) {
        if (this.states.length == 0) {
            this.states = new float[21];
        } else {
            float[] values = new float[1];
            for (int i = 0; i < 21; ++i) {
                values[0] = this.states[i];
                int part = i / 3 * 3;
                if (!this.emote.usesBodyPart(part)) continue;
                ModelAccessor.INSTANCE.setValues(model, i, values);
            }
        }
    }

    public void rotateAndOffset(PoseStack stack, Player player) {
        if (this.states.length == 0) {
            return;
        }
        float rotX = this.states[18];
        float rotY = this.states[19];
        float rotZ = this.states[20];
        float height = player.m_20206_();
        stack.m_85837_(0.0, (double)(height / 2.0f), 0.0);
        if (rotY != 0.0f) {
            stack.m_85845_(Vector3f.f_122225_.m_122270_(rotY));
        }
        if (rotX != 0.0f) {
            stack.m_85845_(Vector3f.f_122223_.m_122270_(rotX));
        }
        if (rotZ != 0.0f) {
            stack.m_85845_(Vector3f.f_122227_.m_122270_(rotZ));
        }
        stack.m_85837_(0.0, (double)(-height / 2.0f), 0.0);
    }
}

