/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.tools.client.render.entity.PickarangRenderer;
import vazkii.quark.content.tools.entity.Pickarang;
import vazkii.quark.content.tools.item.PickarangItem;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class PickarangModule
extends QuarkModule {
    public static EntityType<Pickarang> pickarangType;
    @Config(description="How long it takes before the pickarang starts returning to the player if it doesn't hit anything.")
    public static int timeout;
    @Config(description="2 is Iron, 3 is Diamond.")
    public static int harvestLevel;
    @Config(description="2 is Iron, 3 is Diamond.")
    public static int netheriteHarvestLevel;
    @Config(description="Set to -1 to have the Pickarang be unbreakable.")
    public static int durability;
    @Config(description="Set to -1 to have the Flamerang be unbreakable.")
    public static int netheriteDurability;
    @Config(description="22.5 is ender chests, 25.0 is monster boxes, 50 is obsidian. Most things are below 5.")
    public static double maxHardness;
    @Config(description="Set this to true to use the recipe without the Heart of Diamond, even if the Heart of Diamond is enabled.", flag="pickarang_never_uses_heart")
    public static boolean neverUseHeartOfDiamond;
    @Config(description="Set this to true to disable the short cooldown between throwing pickarangs.")
    public static boolean noCooldown;
    public static Item pickarang;
    public static Item flamerang;
    private static boolean isEnabled;
    private static final ThreadLocal<Pickarang> ACTIVE_PICKARANG;

    @Override
    public void construct() {
        pickarangType = EntityType.Builder.m_20704_(Pickarang::new, (MobCategory)MobCategory.MISC).m_20699_(0.4f, 0.4f).m_20702_(4).m_20717_(10).setCustomClientFactory((spawnEntity, world) -> new Pickarang((EntityType<? extends Pickarang>)pickarangType, (Level)world)).m_20712_("pickarang");
        RegistryHelper.register(pickarangType, (String)"pickarang");
        pickarang = new PickarangItem("pickarang", this, PickarangModule.propertiesFor(harvestLevel, durability, false), false);
        flamerang = new PickarangItem("flamerang", this, PickarangModule.propertiesFor(netheriteHarvestLevel, netheriteDurability, true), true);
    }

    private static Item.Properties propertiesFor(int level, int durability, boolean netherite) {
        Item.Properties properties = new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40756_);
        if (durability > 0) {
            properties.m_41503_(durability);
        }
        if (netherite) {
            properties.m_41486_();
        }
        return properties;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        EntityRenderers.m_174036_(pickarangType, PickarangRenderer::new);
    }

    @Override
    public void configChanged() {
        isEnabled = this.enabled;
    }

    public static void setActivePickarang(Pickarang pickarang) {
        ACTIVE_PICKARANG.set(pickarang);
    }

    public static DamageSource createDamageSource(Player player) {
        Pickarang pickarang = ACTIVE_PICKARANG.get();
        if (pickarang == null) {
            return null;
        }
        return new IndirectEntityDamageSource("player", (Entity)pickarang, (Entity)player).m_19366_();
    }

    public static boolean getIsFireResistant(boolean vanillaVal, Entity entity) {
        if (!isEnabled || vanillaVal) {
            return vanillaVal;
        }
        Entity riding = entity.m_20202_();
        if (riding instanceof Pickarang) {
            return ((Pickarang)riding).netherite;
        }
        return false;
    }

    static {
        timeout = 20;
        harvestLevel = 3;
        netheriteHarvestLevel = 3;
        durability = 800;
        netheriteDurability = 1040;
        maxHardness = 20.0;
        neverUseHeartOfDiamond = false;
        noCooldown = false;
        ACTIVE_PICKARANG = new ThreadLocal();
    }
}

