/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.client.render;

import com.google.common.base.Function;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GlintRenderTypes
extends RenderType {
    public static List<RenderType> glint = GlintRenderTypes.newRenderList((Function<String, RenderType>)((Function)GlintRenderTypes::buildGlintRenderType));
    public static List<RenderType> glintTranslucent = GlintRenderTypes.newRenderList((Function<String, RenderType>)((Function)GlintRenderTypes::buildGlintTranslucentRenderType));
    public static List<RenderType> entityGlint = GlintRenderTypes.newRenderList((Function<String, RenderType>)((Function)GlintRenderTypes::buildEntityGlintRenderType));
    public static List<RenderType> glintDirect = GlintRenderTypes.newRenderList((Function<String, RenderType>)((Function)GlintRenderTypes::buildGlintDirectRenderType));
    public static List<RenderType> entityGlintDirect = GlintRenderTypes.newRenderList((Function<String, RenderType>)((Function)GlintRenderTypes::buildEntityGlintDriectRenderType));
    public static List<RenderType> armorGlint = GlintRenderTypes.newRenderList((Function<String, RenderType>)((Function)GlintRenderTypes::buildArmorGlintRenderType));
    public static List<RenderType> armorEntityGlint = GlintRenderTypes.newRenderList((Function<String, RenderType>)((Function)GlintRenderTypes::buildArmorEntityGlintRenderType));

    private GlintRenderTypes(String name, VertexFormat vf, VertexFormat.Mode mode, int bufSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setup, Runnable clean) {
        super(name, vf, mode, bufSize, affectsCrumbling, sortOnUpload, setup, clean);
        throw new UnsupportedOperationException("Don't instantiate this");
    }

    public static void addGlintTypes(Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder> map) {
        GlintRenderTypes.addGlintTypes(map, glint);
        GlintRenderTypes.addGlintTypes(map, glintTranslucent);
        GlintRenderTypes.addGlintTypes(map, entityGlint);
        GlintRenderTypes.addGlintTypes(map, glintDirect);
        GlintRenderTypes.addGlintTypes(map, entityGlintDirect);
        GlintRenderTypes.addGlintTypes(map, armorGlint);
        GlintRenderTypes.addGlintTypes(map, armorEntityGlint);
    }

    private static List<RenderType> newRenderList(Function<String, RenderType> func) {
        ArrayList<RenderType> list = new ArrayList<RenderType>(18);
        for (DyeColor color : DyeColor.values()) {
            list.add((RenderType)func.apply((Object)color.m_41065_()));
        }
        list.add((RenderType)func.apply((Object)"rainbow"));
        list.add((RenderType)func.apply((Object)"blank"));
        return list;
    }

    private static void addGlintTypes(Object2ObjectLinkedOpenHashMap<RenderType, BufferBuilder> map, List<RenderType> typeList) {
        for (RenderType renderType : typeList) {
            if (map.containsKey((Object)renderType)) continue;
            map.put((Object)renderType, (Object)new BufferBuilder(renderType.m_110507_()));
        }
    }

    private static RenderType buildGlintRenderType(String name) {
        return RenderType.m_173215_((String)("glint_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173081_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110675_(RenderStateShard.f_110129_).m_110683_(RenderStateShard.f_110150_).m_110691_(false));
    }

    private static RenderType buildGlintTranslucentRenderType(String name) {
        return RenderType.m_173215_((String)("glint_translucent_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173080_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110675_(RenderStateShard.f_110129_).m_110683_(RenderStateShard.f_110150_).m_110691_(false));
    }

    private static RenderType buildEntityGlintRenderType(String name) {
        return RenderType.m_173215_((String)("entity_glint_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173083_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110675_(RenderStateShard.f_110129_).m_110683_(RenderStateShard.f_110151_).m_110691_(false));
    }

    private static RenderType buildGlintDirectRenderType(String name) {
        return RenderType.m_173215_((String)("glint_direct_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173082_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110683_(RenderStateShard.f_110150_).m_110691_(false));
    }

    private static RenderType buildEntityGlintDriectRenderType(String name) {
        return RenderType.m_173215_((String)("entity_glint_direct_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173084_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110683_(RenderStateShard.f_110151_).m_110691_(false));
    }

    private static RenderType buildArmorGlintRenderType(String name) {
        return RenderType.m_173215_((String)("armor_glint_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173078_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110683_(RenderStateShard.f_110151_).m_110669_(RenderStateShard.f_110119_).m_110691_(false));
    }

    private static RenderType buildArmorEntityGlintRenderType(String name) {
        return RenderType.m_173215_((String)("armor_entity_glint_" + name), (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderStateShard.f_173079_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(GlintRenderTypes.texture(name), true, false)).m_110687_(RenderStateShard.f_110115_).m_110661_(RenderStateShard.f_110110_).m_110663_(RenderStateShard.f_110112_).m_110685_(RenderStateShard.f_110137_).m_110683_(RenderStateShard.f_110151_).m_110669_(RenderStateShard.f_110119_).m_110691_(false));
    }

    private static final ResourceLocation texture(String name) {
        return new ResourceLocation("quark", "textures/glint/enchanted_item_glint_" + name + ".png");
    }
}

