/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.ai;

import com.google.common.base.Predicates;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.quark.content.tools.entity.SkullPike;

public class RunAwayFromPikesGoal
extends Goal {
    protected final PathfinderMob entity;
    private final double farSpeed;
    private final double nearSpeed;
    protected SkullPike avoidTarget;
    protected final float avoidDistance;
    protected Path path;
    protected final PathNavigation navigation;

    public RunAwayFromPikesGoal(PathfinderMob entityIn, float distance, double nearSpeedIn, double farSpeedIn) {
        this.entity = entityIn;
        this.avoidDistance = distance;
        this.farSpeed = nearSpeedIn;
        this.nearSpeed = farSpeedIn;
        this.navigation = entityIn.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        this.avoidTarget = this.getClosestEntity(this.entity.f_19853_, (LivingEntity)this.entity, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), this.entity.m_142469_().m_82377_((double)this.avoidDistance, 3.0, (double)this.avoidDistance));
        if (this.avoidTarget == null) {
            return false;
        }
        Vec3 posToMove = DefaultRandomPos.m_148407_((PathfinderMob)this.entity, (int)16, (int)7, (Vec3)this.avoidTarget.m_20182_());
        if (posToMove == null) {
            return false;
        }
        if (this.avoidTarget.m_20275_(posToMove.f_82479_, posToMove.f_82480_, posToMove.f_82481_) < this.avoidTarget.m_20280_((Entity)this.entity)) {
            return false;
        }
        this.path = this.navigation.m_26524_(posToMove.f_82479_, posToMove.f_82480_, posToMove.f_82481_, 0);
        return this.path != null;
    }

    @Nullable
    private SkullPike getClosestEntity(Level world, LivingEntity p_225318_3_, double p_225318_4_, double p_225318_6_, double p_225318_8_, AABB p_225318_10_) {
        return this.getClosestEntity(world.m_6443_(SkullPike.class, p_225318_10_, (Predicate)Predicates.alwaysTrue()), p_225318_3_, p_225318_4_, p_225318_6_, p_225318_8_);
    }

    @Nullable
    private SkullPike getClosestEntity(List<SkullPike> entities, LivingEntity target, double x, double y, double z) {
        double d0 = -1.0;
        SkullPike t = null;
        for (SkullPike t1 : entities) {
            if (!t1.isVisible((Entity)target)) continue;
            double d1 = t1.m_20275_(x, y, z);
            if (d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            t = t1;
        }
        return t;
    }

    public boolean m_8045_() {
        return !this.navigation.m_26571_();
    }

    public void m_8056_() {
        this.navigation.m_26536_(this.path, this.farSpeed);
    }

    public void m_8041_() {
        this.avoidTarget = null;
    }

    public void m_8037_() {
        if (this.entity.m_20280_((Entity)this.avoidTarget) < 49.0) {
            this.entity.m_21573_().m_26517_(this.nearSpeed);
        } else {
            this.entity.m_21573_().m_26517_(this.farSpeed);
        }
    }
}

