/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.common.ForgeMod;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.client.handler.ModelHandler;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.base.module.QuarkModule;

public class ForgottenHatItem
extends ArmorItem
implements IQuarkItem {
    private static final String TEXTURE = "quark:textures/misc/forgotten_hat_worn.png";
    private final QuarkModule module;
    private Multimap<Attribute, AttributeModifier> attributes;

    public ForgottenHatItem(QuarkModule module) {
        super((ArmorMaterial)ArmorMaterials.LEATHER, EquipmentSlot.HEAD, new Item.Properties().m_41487_(1).m_41503_(0).m_41491_(CreativeModeTab.f_40756_).m_41497_(Rarity.RARE));
        RegistryHelper.registerItem((Item)this, (String)"forgotten_hat");
        this.module = module;
    }

    @Override
    public QuarkModule getModule() {
        return this.module;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            public HumanoidModel<?> getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return ModelHandler.armorModel(ModelHandler.forgotten_hat, armorSlot);
            }
        });
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (this.attributes == null) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            UUID uuid = UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150");
            builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(uuid, "Armor luck modifier", 1.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Object)new AttributeModifier(uuid, "Armor reach modifier", 2.0, AttributeModifier.Operation.ADDITION));
            this.attributes = builder.build();
        }
        return slot == this.f_40377_ ? this.attributes : super.m_7167_(slot);
    }

    public void m_6787_(@Nonnull CreativeModeTab group, @Nonnull NonNullList<ItemStack> items) {
        if (this.isEnabled() || group == CreativeModeTab.f_40754_) {
            super.m_6787_(group, items);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.module != null && this.module.enabled;
    }
}

