/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.content.mobs.module.WraithModule;

public class Wraith
extends Zombie {
    public static final ResourceLocation LOOT_TABLE = new ResourceLocation("quark:entities/wraith");
    private static final EntityDataAccessor<String> IDLE_SOUND = SynchedEntityData.m_135353_(Wraith.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> HURT_SOUND = SynchedEntityData.m_135353_(Wraith.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> DEATH_SOUND = SynchedEntityData.m_135353_(Wraith.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final String TAG_IDLE_SOUND = "IdleSound";
    private static final String TAG_HURT_SOUND = "HurtSound";
    private static final String TAG_DEATH_SOUND = "DeathSound";

    public Wraith(EntityType<? extends Wraith> type, Level worldIn) {
        super(type, worldIn);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IDLE_SOUND, (Object)"");
        this.f_19804_.m_135372_(HURT_SOUND, (Object)"");
        this.f_19804_.m_135372_(DEATH_SOUND, (Object)"");
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22287_, 0.0);
    }

    protected void m_6851_(DifficultyInstance difficulty) {
    }

    protected SoundEvent m_7515_() {
        return this.getSound(IDLE_SOUND);
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return this.getSound(HURT_SOUND);
    }

    protected SoundEvent m_5592_() {
        return this.getSound(DEATH_SOUND);
    }

    public float m_6100_() {
        return this.f_19796_.nextFloat() * 0.1f + 0.75f;
    }

    public SoundEvent getSound(EntityDataAccessor<String> param) {
        ResourceLocation loc = new ResourceLocation((String)this.f_19804_.m_135370_(param));
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(loc);
    }

    public void m_8119_() {
        super.m_8119_();
        AABB aabb = this.m_142469_();
        double x = aabb.f_82288_ + Math.random() * (aabb.f_82291_ - aabb.f_82288_);
        double y = aabb.f_82289_ + Math.random() * (aabb.f_82292_ - aabb.f_82289_);
        double z = aabb.f_82290_ + Math.random() * (aabb.f_82293_ - aabb.f_82290_);
        this.m_20193_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, x, y, z, 0.0, 0.0, 0.0);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean did = super.m_7327_(entityIn);
        if (did) {
            if (entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
            }
            double dx = this.m_20185_() - entityIn.m_20185_();
            double dz = this.m_20189_() - entityIn.m_20189_();
            Vec3 vec = new Vec3(dx, 0.0, dz).m_82541_().m_82520_(0.0, 0.5, 0.0).m_82541_().m_82490_(0.85);
            this.m_20256_(vec);
        }
        return did;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        int idx = this.f_19796_.nextInt(WraithModule.validWraithSounds.size());
        String sound = WraithModule.validWraithSounds.get(idx);
        String[] split = sound.split("\\|");
        this.f_19804_.m_135381_(IDLE_SOUND, (Object)split[0]);
        this.f_19804_.m_135381_(HURT_SOUND, (Object)split[1]);
        this.f_19804_.m_135381_(DEATH_SOUND, (Object)split[2]);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_(TAG_IDLE_SOUND, (String)this.f_19804_.m_135370_(IDLE_SOUND));
        compound.m_128359_(TAG_HURT_SOUND, (String)this.f_19804_.m_135370_(HURT_SOUND));
        compound.m_128359_(TAG_DEATH_SOUND, (String)this.f_19804_.m_135370_(DEATH_SOUND));
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(IDLE_SOUND, (Object)compound.m_128461_(TAG_IDLE_SOUND));
        this.f_19804_.m_135381_(HURT_SOUND, (Object)compound.m_128461_(TAG_HURT_SOUND));
        this.f_19804_.m_135381_(DEATH_SOUND, (Object)compound.m_128461_(TAG_DEATH_SOUND));
    }

    protected ResourceLocation m_7582_() {
        return LOOT_TABLE;
    }

    public void m_6863_(boolean childZombie) {
    }

    public boolean m_6162_() {
        return false;
    }

    public float m_5610_(BlockPos pos, LevelReader worldIn) {
        BlockState state = worldIn.m_8055_(pos);
        return state.m_60620_(WraithModule.wraithSpawnableTag) ? 1.0f : 0.0f;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!super.m_6469_(source, amount)) {
            return false;
        }
        return this.f_19853_ instanceof ServerLevel;
    }

    protected void m_34339_(float difficulty) {
    }
}

