/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import com.google.common.collect.Lists;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import vazkii.quark.base.handler.QuarkSounds;
import vazkii.quark.base.proxy.CommonProxy;
import vazkii.quark.content.mobs.ai.FavorBlockGoal;
import vazkii.quark.content.mobs.ai.PassivePassengerGoal;
import vazkii.quark.content.mobs.module.FrogsModule;

public class Frog
extends Animal
implements IEntityAdditionalSpawnData,
IForgeShearable {
    public static final ResourceLocation FROG_LOOT_TABLE = new ResourceLocation("quark", "entities/frog");
    private static final EntityDataAccessor<Integer> TALK_TIME = SynchedEntityData.m_135353_(Frog.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SIZE_MODIFIER = SynchedEntityData.m_135353_(Frog.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> HAS_SWEATER = SynchedEntityData.m_135353_(Frog.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> VOID = SynchedEntityData.m_135353_(Frog.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID VOID_MODIFIER_UUID = UUID.fromString("212dbecc-7525-4137-a74b-361cc128d24f");
    public int spawnCd = -1;
    public int spawnChain = 30;
    public boolean isDuplicate = false;
    private boolean sweatered = false;
    private Ingredient[] temptationItems;
    private int droppedLegs = -1;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;

    public Frog(EntityType<? extends Frog> type, Level worldIn) {
        this(type, worldIn, 1.0f);
    }

    public Frog(EntityType<? extends Frog> type, Level worldIn, float sizeModifier) {
        super(type, worldIn);
        if (sizeModifier != 1.0f) {
            this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        }
        this.f_21343_ = new FrogJumpController();
        this.f_21342_ = new FrogMoveController();
        this.setMovementSpeed(0.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TALK_TIME, (Object)0);
        this.f_19804_.m_135372_(SIZE_MODIFIER, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(HAS_SWEATER, (Object)false);
        this.f_19804_.m_135372_(VOID, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PassivePassengerGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FrogPanicGoal(1.25));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, this.getTemptationItems(false), false));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new FavorBlockGoal((PathfinderMob)this, 1.0, Blocks.f_50196_));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.5f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25).m_22266_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
    }

    @Nonnull
    public MoveControl m_21566_() {
        return this.f_21342_;
    }

    @Nonnull
    public JumpControl m_21569_() {
        return this.f_21343_;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    protected float m_6431_(@Nonnull Pose pose, EntityDimensions size) {
        return 0.2f * size.f_20378_;
    }

    public int getTalkTime() {
        return (Integer)this.f_19804_.m_135370_(TALK_TIME);
    }

    public float getSizeModifier() {
        return ((Float)this.f_19804_.m_135370_(SIZE_MODIFIER)).floatValue();
    }

    public static boolean canBeSweatered() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 4 && calendar.get(5) == 1;
    }

    public void m_8119_() {
        Component name;
        if (!this.f_19853_.f_46443_ && !this.sweatered) {
            this.setSweater(CommonProxy.jingleTheBells && this.m_142081_().getLeastSignificantBits() % 10L == 0L);
            this.sweatered = true;
        }
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.m_6862_(false);
        }
        if (!this.isVoid() && this.m_8077_() && this.m_20186_() <= 0.0 && (name = this.m_7770_()) != null && name.m_6111_().equals("Jack")) {
            this.setVoid(true);
        }
        super.m_8119_();
        int talkTime = this.getTalkTime();
        if (talkTime > 0) {
            this.f_19804_.m_135381_(TALK_TIME, (Object)(talkTime - 1));
        }
        if (FrogsModule.enableBigFunny && this.spawnCd > 0 && this.spawnChain > 0) {
            --this.spawnCd;
            if (this.spawnCd == 0 && !this.f_19853_.f_46443_) {
                float multiplier = 0.8f;
                Frog newFrog = new Frog(FrogsModule.frogType, this.f_19853_);
                Vec3 pos = this.m_20182_();
                newFrog.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                newFrog.m_20334_((Math.random() - 0.5) * (double)multiplier, (Math.random() - 0.5) * (double)multiplier, (Math.random() - 0.5) * (double)multiplier);
                newFrog.isDuplicate = true;
                newFrog.spawnCd = 2;
                newFrog.spawnChain = this.spawnChain - 1;
                this.f_19853_.m_7967_((Entity)newFrog);
                this.spawnChain = 0;
            }
        }
        if (this.isVoid() && this.m_20186_() > 320.0) {
            this.m_6088_();
        }
        this.f_19859_ = this.f_20886_;
        this.m_146922_(this.f_20885_);
    }

    protected boolean m_6149_() {
        return !this.isDuplicate && super.m_6149_();
    }

    @Nonnull
    protected ResourceLocation m_7582_() {
        return FROG_LOOT_TABLE;
    }

    protected void m_7625_(@Nonnull DamageSource source, boolean damagedByPlayer) {
        this.droppedLegs = 0;
        super.m_7625_(source, damagedByPlayer);
        this.droppedLegs = -1;
    }

    @Nullable
    public ItemEntity m_5552_(@Nonnull ItemStack stack, float offsetY) {
        if (this.droppedLegs >= 0) {
            int count = Math.max(4 - this.droppedLegs, 0);
            this.droppedLegs += stack.m_41613_();
            if (stack.m_41613_() > count) {
                ItemStack copy = stack.m_41777_();
                copy.m_41774_(count);
                copy.m_41698_("display").m_128359_("LocName", "item.quark.frog_maybe_leg.name");
                stack = stack.m_41777_();
                stack.m_41774_(copy.m_41613_());
                super.m_5552_(copy, offsetY);
            }
        }
        return super.m_5552_(stack, offsetY);
    }

    @Nonnull
    public InteractionResult m_6071_(@Nonnull Player player, @Nonnull InteractionHand hand) {
        InteractionResult parent = super.m_6071_(player, hand);
        if (parent == InteractionResult.SUCCESS) {
            return parent;
        }
        ItemStack stack = player.m_21120_(hand);
        LocalDate date = LocalDate.now();
        if (DayOfWeek.from(date) == DayOfWeek.WEDNESDAY && stack.m_41720_() == Items.f_42524_) {
            if (!this.f_19853_.f_46443_ && this.spawnChain > 0 && !this.isDuplicate) {
                if (FrogsModule.enableBigFunny) {
                    this.spawnCd = 50;
                    this.f_19804_.m_135381_(TALK_TIME, (Object)80);
                }
                Vec3 pos = this.m_20182_();
                this.f_19853_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, QuarkSounds.ENTITY_FROG_WEDNESDAY, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150922_((Tag)ItemTags.f_13167_) && !this.hasSweater()) {
            if (!this.f_19853_.f_46443_) {
                this.setSweater(true);
                Vec3 pos = this.m_20182_();
                this.f_19853_.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundType.f_56745_.m_56777_(), SoundSource.PLAYERS, 1.0f, 1.0f);
                stack.m_41774_(1);
            }
            player.m_6674_(hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.hasSweater();
    }

    @Nonnull
    public List<ItemStack> onSheared(Player player, @Nonnull ItemStack item, Level iworld, BlockPos pos, int fortune) {
        this.setSweater(false);
        Vec3 epos = this.m_20182_();
        this.f_19853_.m_6263_(null, epos.f_82479_, epos.f_82480_, epos.f_82481_, QuarkSounds.ENTITY_FROG_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
        return Lists.newArrayList();
    }

    public Frog getBreedOffspring(ServerLevel sworld, AgeableMob otherParent) {
        if (this.isDuplicate) {
            return null;
        }
        float sizeMod = this.getSizeModifier();
        if (otherParent instanceof Frog) {
            if (((Frog)otherParent).isDuplicate) {
                return null;
            }
            sizeMod += ((Frog)otherParent).getSizeModifier();
            sizeMod /= 2.0f;
        }
        double regression = this.f_19796_.nextGaussian() / 20.0;
        regression *= Math.abs(((double)sizeMod + regression) / (double)sizeMod);
        return new Frog(FrogsModule.frogType, this.f_19853_, Mth.m_14036_((float)(sizeMod + (float)regression), (float)0.25f, (float)2.0f));
    }

    public boolean m_6898_(ItemStack stack) {
        LocalDate date = LocalDate.now();
        return !stack.m_41619_() && (FrogsModule.enableBigFunny && DayOfWeek.from(date) == DayOfWeek.WEDNESDAY ? this.getTemptationItems(true) : this.getTemptationItems(false)).test(stack);
    }

    private Ingredient getTemptationItems(boolean nice) {
        if (this.temptationItems == null) {
            this.temptationItems = new Ingredient[]{Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_}), Ingredient.m_43911_((Tag)ItemTags.f_13156_)})), Ingredient.merge((Collection)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42591_, Items.f_42524_}), Ingredient.m_43911_((Tag)ItemTags.f_13156_)}))};
        }
        return this.temptationItems[nice ? 1 : 0];
    }

    public void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.spawnCd = compound.m_128451_("Cooldown");
        if (compound.m_128441_("Chain")) {
            this.spawnChain = compound.m_128451_("Chain");
        }
        this.f_19804_.m_135381_(TALK_TIME, (Object)compound.m_128451_("DudeAmount"));
        float sizeModifier = compound.m_128441_("FrogAmount") ? compound.m_128457_("FrogAmount") : 1.0f;
        this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
        this.isDuplicate = compound.m_128471_("FakeFrog");
        this.sweatered = compound.m_128471_("SweaterComp");
        this.setSweater(compound.m_128471_("Sweater"));
        this.setVoid(compound.m_128471_("Jack"));
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("FrogAmount", this.getSizeModifier());
        compound.m_128405_("Cooldown", this.spawnCd);
        compound.m_128405_("Chain", this.spawnChain);
        compound.m_128405_("DudeAmount", this.getTalkTime());
        compound.m_128379_("FakeFrog", this.isDuplicate);
        compound.m_128379_("SweaterComp", this.sweatered);
        compound.m_128379_("Sweater", this.hasSweater());
        compound.m_128379_("Jack", this.isVoid());
    }

    protected SoundEvent m_7515_() {
        return QuarkSounds.ENTITY_FROG_IDLE;
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSourceIn) {
        return QuarkSounds.ENTITY_FROG_HURT;
    }

    protected SoundEvent m_5592_() {
        return QuarkSounds.ENTITY_FROG_DIE;
    }

    protected SoundEvent getJumpSound() {
        return QuarkSounds.ENTITY_FROG_JUMP;
    }

    public boolean hasSweater() {
        return (Boolean)this.f_19804_.m_135370_(HAS_SWEATER);
    }

    public void setSweater(boolean sweater) {
        this.f_19804_.m_135381_(HAS_SWEATER, (Object)sweater);
    }

    public boolean isVoid() {
        return (Boolean)this.f_19804_.m_135370_(VOID);
    }

    protected float m_6118_() {
        float motion = super.m_6118_();
        if (this.isVoid()) {
            return -motion;
        }
        return motion;
    }

    public void setVoid(boolean jack) {
        if (jack && this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22111_(VOID_MODIFIER_UUID) == null) {
            this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22125_(new AttributeModifier(VOID_MODIFIER_UUID, "Void gravity", -2.0, AttributeModifier.Operation.MULTIPLY_BASE));
        } else {
            this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22120_(VOID_MODIFIER_UUID);
        }
        this.f_19804_.m_135381_(VOID, (Object)jack);
    }

    public void m_8024_() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.m_20096_()) {
            FrogJumpController jumpHelper;
            if (!this.wasOnGround) {
                this.m_6862_(false);
                this.checkLandingDelay();
            }
            if (!(jumpHelper = (FrogJumpController)this.f_21343_).getIsJumping()) {
                if (this.f_21342_.m_24995_() && this.currentMoveTypeDuration == 0) {
                    Path path = this.f_21344_.m_26570_();
                    Vec3 Vector3d = new Vec3(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_());
                    if (path != null && path.m_77399_() < path.m_77398_()) {
                        Vector3d = path.m_77380_((Entity)this);
                    }
                    this.calculateRotationYaw(Vector3d.f_82479_, Vector3d.f_82481_);
                    this.startJumping();
                }
            } else if (!jumpHelper.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.m_20096_();
    }

    public boolean m_5843_() {
        return false;
    }

    private void calculateRotationYaw(double x, double z) {
        Vec3 pos = this.m_20182_();
        this.m_146922_((float)(Mth.m_14136_((double)(z - pos.f_82481_), (double)(x - pos.f_82479_)) * 57.29577951308232) - 90.0f);
    }

    private void enableJumpControl() {
        ((FrogJumpController)this.f_21343_).setCanJump(true);
    }

    private void disableJumpControl() {
        ((FrogJumpController)this.f_21343_).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.f_21342_.m_24999_() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void m_7350_(@Nonnull EntityDataAccessor<?> parameter) {
        if (parameter.equals(SIZE_MODIFIER)) {
            this.m_6210_();
        }
        super.m_7350_(parameter);
    }

    protected void m_6135_() {
        super.m_6135_();
        double d0 = this.f_21342_.m_24999_();
        if (d0 > 0.0) {
            Vec3 motion = this.m_20184_();
            double d1 = motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_;
            if (d1 < 0.01) {
                this.m_19920_(0.1f, new Vec3(0.0, 0.0, 1.0));
            }
        }
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)1);
        }
    }

    public void setMovementSpeed(double newSpeed) {
        this.m_21573_().m_26517_(newSpeed);
        this.f_21342_.m_6849_(this.f_21342_.m_25000_(), this.f_21342_.m_25001_(), this.f_21342_.m_25002_(), newSpeed);
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(jumping);
        if (jumping) {
            this.m_5496_(this.getJumpSound(), this.m_6121_(), ((this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.m_6862_(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 1) {
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.m_7822_(id);
        }
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.getSizeModifier());
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.f_19804_.m_135381_(SIZE_MODIFIER, (Object)Float.valueOf(buffer.readFloat()));
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return super.m_6972_(poseIn).m_20388_(this.getSizeModifier());
    }

    public class FrogJumpController
    extends JumpControl {
        private boolean canJump;

        public FrogJumpController() {
            super((Mob)Frog.this);
        }

        public boolean getIsJumping() {
            return this.f_24897_;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void m_8124_() {
            if (this.f_24897_) {
                Frog.this.startJumping();
                this.f_24897_ = false;
            }
        }
    }

    public class FrogMoveController
    extends MoveControl {
        private double nextJumpSpeed;

        public FrogMoveController() {
            super((Mob)Frog.this);
        }

        public void m_8126_() {
            if (Frog.this.m_20096_() && !Frog.this.f_20899_ && !((FrogJumpController)Frog.this.f_21343_).getIsJumping()) {
                Frog.this.setMovementSpeed(0.0);
            } else if (this.m_24995_()) {
                Frog.this.setMovementSpeed(this.nextJumpSpeed);
            }
            super.m_8126_();
        }

        public void m_6849_(double x, double y, double z, double speedIn) {
            if (Frog.this.m_20069_()) {
                speedIn = 1.5;
            }
            super.m_6849_(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }

    public class FrogPanicGoal
    extends PanicGoal {
        public FrogPanicGoal(double speedIn) {
            super((PathfinderMob)Frog.this, speedIn);
        }

        public void m_8037_() {
            super.m_8037_();
            Frog.this.setMovementSpeed(this.f_25685_);
        }
    }
}

