/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.management.module;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.MANAGEMENT, hasSubscriptions=true)
public class QuickArmorSwappingModule
extends QuarkModule {
    @Config
    public static boolean swapOffHand = true;

    @SubscribeEvent
    public void onEntityInteractSpecific(PlayerInteractEvent.EntityInteractSpecific event) {
        Player player = event.getPlayer();
        if (player.m_5833_() || player.m_7500_() || !(event.getTarget() instanceof ArmorStand)) {
            return;
        }
        if (player.m_6047_()) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            ArmorStand armorStand = (ArmorStand)event.getTarget();
            this.swapSlot(player, armorStand, EquipmentSlot.HEAD);
            this.swapSlot(player, armorStand, EquipmentSlot.CHEST);
            this.swapSlot(player, armorStand, EquipmentSlot.LEGS);
            this.swapSlot(player, armorStand, EquipmentSlot.FEET);
            if (swapOffHand) {
                this.swapSlot(player, armorStand, EquipmentSlot.OFFHAND);
            }
        }
    }

    private void swapSlot(Player player, ArmorStand armorStand, EquipmentSlot slot) {
        ItemStack playerItem = player.m_6844_(slot);
        ItemStack armorStandItem = armorStand.m_6844_(slot);
        if (EnchantmentHelper.m_44920_((ItemStack)playerItem)) {
            return;
        }
        ItemStack held = player.m_21120_(InteractionHand.MAIN_HAND);
        if (armorStandItem.m_41619_() && !held.m_41619_() && Player.m_147233_((ItemStack)held) == slot) {
            ItemStack copy = held.m_41777_();
            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            armorStandItem = copy;
        }
        player.m_8061_(slot, armorStandItem);
        armorStand.m_8061_(slot, playerItem);
    }
}

