/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.experimental.module;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.EXPERIMENTAL, enabledByDefault=false, hasSubscriptions=true)
public class GameNerfsModule
extends QuarkModule {
    private static final String TAG_TRADES_ADJUSTED = "quark:zombie_trades_adjusted";
    @Config(description="Makes Mending act like the Unmending mod\nhttps://www.curseforge.com/minecraft/mc-mods/unmending")
    public static boolean nerfMending = true;
    @Config(description="Resets all villager discounts when zombified to prevent reducing prices to ridiculous levels")
    public static boolean nerfVillagerDiscount = true;
    @Config(description="Makes Iron Golems not drop Iron Ingots")
    public static boolean disableIronFarms = true;
    @Config(description="Makes Boats not glide on ice")
    public static boolean disableIceRoads = true;
    @Config(description="Makes Sheep not drop Wool when killed")
    public static boolean disableWoolDrops = true;
    private static boolean staticEnabled;

    @Override
    public void configChanged() {
        staticEnabled = this.enabled;
    }

    public static float getBoatFriction(float glide) {
        return staticEnabled && disableIceRoads ? 0.45f : glide;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void killMending(PlayerXpEvent.PickupXp event) {
        if (!nerfMending) {
            return;
        }
        Player player = event.getPlayer();
        ExperienceOrb orb = event.getOrb();
        player.f_36101_ = 2;
        player.m_7938_((Entity)orb, 1);
        if (orb.f_20770_ > 0) {
            player.m_6756_(orb.f_20770_);
        }
        orb.m_146870_();
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        if (!nerfMending) {
            return;
        }
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        ItemStack out = event.getOutput();
        if (out.m_41619_() && (left.m_41619_() || right.m_41619_())) {
            return;
        }
        boolean isMended = false;
        Map enchLeft = EnchantmentHelper.m_44831_((ItemStack)left);
        Map enchRight = EnchantmentHelper.m_44831_((ItemStack)right);
        if (enchLeft.containsKey(Enchantments.f_44962_) || enchRight.containsKey(Enchantments.f_44962_)) {
            if (left.m_41720_() == right.m_41720_()) {
                isMended = true;
            }
            if (right.m_41720_() == Items.f_42690_) {
                isMended = true;
            }
        }
        if (isMended) {
            if (out.m_41619_()) {
                out = left.m_41777_();
            }
            if (!out.m_41782_()) {
                out.m_41751_(new CompoundTag());
            }
            Map enchOutput = EnchantmentHelper.m_44831_((ItemStack)out);
            enchOutput.putAll(enchRight);
            enchOutput.remove(Enchantments.f_44962_);
            EnchantmentHelper.m_44865_((Map)enchOutput, (ItemStack)out);
            out.m_41742_(0);
            if (out.m_41763_()) {
                out.m_41721_(0);
            }
            event.setOutput(out);
            if (event.getCost() == 0) {
                event.setCost(1);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onTooltip(ItemTooltipEvent event) {
        if (!nerfMending) {
            return;
        }
        MutableComponent itemgotmodified = new TranslatableComponent("quark.misc.repaired").m_130940_(ChatFormatting.YELLOW);
        int repairCost = event.getItemStack().m_41610_();
        if (repairCost > 0) {
            event.getToolTip().add(itemgotmodified);
        }
    }

    @SubscribeEvent
    public void onTick(LivingEvent.LivingUpdateEvent event) {
        if (nerfVillagerDiscount && event.getEntity().m_6095_() == EntityType.f_20530_ && !event.getEntity().getPersistentData().m_128441_(TAG_TRADES_ADJUSTED)) {
            ZombieVillager zombie = (ZombieVillager)event.getEntity();
            net.minecraft.nbt.Tag gossipsNbt = zombie.f_34361_;
            GossipContainer manager = new GossipContainer();
            manager.m_26177_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)gossipsNbt));
            for (UUID uuid : manager.f_26156_.keySet()) {
                GossipContainer.EntityGossips gossips = (GossipContainer.EntityGossips)manager.f_26156_.get(uuid);
                gossips.m_26226_(GossipType.MAJOR_POSITIVE);
                gossips.m_26226_(GossipType.MINOR_POSITIVE);
            }
            zombie.getPersistentData().m_128379_(TAG_TRADES_ADJUSTED, true);
        }
    }

    @SubscribeEvent
    public void onLoot(LivingDropsEvent event) {
        if (disableIronFarms && event.getEntity().m_6095_() == EntityType.f_20460_) {
            event.getDrops().removeIf(e -> e.m_32055_().m_41720_() == Items.f_42416_);
        }
        if (disableWoolDrops && event.getEntity().m_6095_() == EntityType.f_20520_) {
            event.getDrops().removeIf(e -> e.m_32055_().m_150922_((Tag)ItemTags.f_13167_));
        }
    }
}

