/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.module;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.ClientTicker;
import vazkii.quark.base.client.handler.ModKeybindHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.CLIENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class AutoWalkKeybindModule
extends QuarkModule {
    @Config
    public static boolean drawHud = true;
    @Config
    public static int hudHeight = 10;
    @OnlyIn(value=Dist.CLIENT)
    private KeyMapping keybind;
    private boolean autorunning;
    private boolean hadAutoJump;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        if (this.enabled) {
            this.keybind = ModKeybindHandler.init("autorun", null, "quark.gui.keygroup.misc");
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onMouseInput(InputEvent.MouseInputEvent event) {
        this.acceptInput();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        this.acceptInput();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(RenderGameOverlayEvent.Post event) {
        if (drawHud && this.autorunning && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            String message = I18n.m_118938_((String)"quark.misc.autowalking", (Object[])new Object[0]);
            Minecraft mc = Minecraft.m_91087_();
            int w = mc.f_91062_.m_92895_("OoO" + message + "oOo");
            Window window = event.getWindow();
            int x = (window.m_85445_() - w) / 2;
            int y = hudHeight;
            Object displayMessage = message;
            int dots = ClientTicker.ticksInGame / 10 % 2;
            switch (dots) {
                case 0: {
                    displayMessage = "OoO " + message + " oOo";
                    break;
                }
                case 1: {
                    displayMessage = "oOo " + message + " OoO";
                }
            }
            mc.f_91062_.m_92750_(event.getMatrixStack(), (String)displayMessage, (float)x, (float)y, -1);
        }
    }

    private void acceptInput() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92085_.m_90857_()) {
            if (this.autorunning) {
                mc.f_91066_.f_92036_ = this.hadAutoJump;
            }
            this.autorunning = false;
        } else if (this.keybind.m_90857_()) {
            boolean bl = this.autorunning = !this.autorunning;
            if (this.autorunning) {
                this.hadAutoJump = mc.f_91066_.f_92036_;
                mc.f_91066_.f_92036_ = true;
            } else {
                mc.f_91066_.f_92036_ = this.hadAutoJump;
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onInput(MovementInputUpdateEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && this.autorunning) {
            Input input = event.getInput();
            input.f_108568_ = true;
            input.f_108567_ = ((LocalPlayer)event.getPlayer()).m_108635_() ? 0.3f : 1.0f;
        }
    }
}

