/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.module;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.quark.base.block.QuarkPaneBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.handler.StructureBlockReplacementHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.BUILDING)
public class GoldBarsModule
extends QuarkModule {
    @Config
    public static boolean generateInNetherFortress = true;
    public static boolean staticEnabled;
    public static Block gold_bars;

    @Override
    public void construct() {
        gold_bars = new QuarkPaneBlock("gold_bars", this, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50183_), RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
        StructureBlockReplacementHandler.functions.add(GoldBarsModule::getGenerationBarBlockState);
    }

    @Override
    public void configChanged() {
        staticEnabled = this.enabled;
    }

    private static BlockState getGenerationBarBlockState(BlockState current, StructureBlockReplacementHandler.StructureHolder structure) {
        if (staticEnabled && generateInNetherFortress && current.m_60734_() == Blocks.f_50198_) {
            ResourceLocation res = structure.currentStructure.getRegistryName();
            if (res == null) {
                return null;
            }
            String name = res.toString();
            if ("minecraft:fortress".equals(name)) {
                BlockState newState = gold_bars.m_49966_();
                for (Property prop : current.m_61147_()) {
                    if (!newState.m_61138_(prop)) continue;
                    newState = (BlockState)newState.m_61124_(prop, current.m_61143_(prop));
                }
                return newState;
            }
        }
        return null;
    }
}

