/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.item;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import vazkii.quark.base.item.QuarkItem;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.util.TriFunction;

public class QuarkItemFrameItem
extends QuarkItem {
    private final TriFunction<? extends HangingEntity, Level, BlockPos, Direction> entityProvider;

    public QuarkItemFrameItem(String name, QuarkModule module, TriFunction<? extends HangingEntity, Level, BlockPos, Direction> entityProvider) {
        super(name, module, new Item.Properties().m_41491_(CreativeModeTab.f_40750_));
        this.entityProvider = entityProvider;
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_();
        BlockPos placeLocation = pos.m_142300_(facing);
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player != null && !this.canPlace(player, facing, stack, placeLocation)) {
            return InteractionResult.FAIL;
        }
        Level world = context.m_43725_();
        HangingEntity frame = this.entityProvider.apply(world, placeLocation, facing);
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            EntityType.m_20620_((Level)world, (Player)player, (Entity)frame, (CompoundTag)tag);
        }
        if (frame.m_7088_()) {
            if (!world.f_46443_) {
                frame.m_7084_();
                world.m_7967_((Entity)frame);
            }
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean canPlace(Player player, Direction facing, ItemStack stack, BlockPos pos) {
        return !player.f_19853_.m_151570_(pos) && player.m_36204_(pos, facing, stack);
    }
}

