/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.building.entity.Stool;
import vazkii.quark.content.building.module.StoolsModule;

public class StoolBlock
extends QuarkBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE_TOP = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)1.0, (double)4.0);
    private static final VoxelShape SHAPE_TOP_BIG = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_LEG_BIG = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0);
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)SHAPE_TOP, (VoxelShape[])new VoxelShape[]{SHAPE_LEG, SHAPE_LEG.m_83216_(0.75, 0.0, 0.0), SHAPE_LEG.m_83216_(0.75, 0.0, 0.75), SHAPE_LEG.m_83216_(0.0, 0.0, 0.75)});
    private static final VoxelShape SHAPE_BIG = Shapes.m_83124_((VoxelShape)SHAPE_TOP_BIG, (VoxelShape[])new VoxelShape[]{SHAPE_LEG_BIG, SHAPE_LEG_BIG.m_83216_(0.75, 0.0, 0.0), SHAPE_LEG_BIG.m_83216_(0.75, 0.0, 0.75), SHAPE_LEG_BIG.m_83216_(0.0, 0.0, 0.75)});
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty BIG = BooleanProperty.m_61465_((String)"big");
    public static final BooleanProperty SAT_IN = BooleanProperty.m_61465_((String)"sat_in");

    public StoolBlock(QuarkModule module, DyeColor color) {
        super(color.m_41065_() + "_stool", module, CreativeModeTab.f_40750_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)color.m_41069_()).m_60918_(SoundType.f_56736_).m_60978_(0.2f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BIG, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SAT_IN, (Comparable)Boolean.valueOf(false)));
    }

    public void blockClicked(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (!((Boolean)state.m_61143_((Property)BIG)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)BIG, (Comparable)Boolean.valueOf(true)));
            world.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        this.fixState((Level)worldIn, pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)SAT_IN)).booleanValue() || !worldIn.m_8055_(pos.m_7494_()).m_60795_() || player.m_20202_() != null) {
            return super.m_6227_(state, worldIn, pos, player, handIn, hit);
        }
        if (!worldIn.f_46443_) {
            Stool entity = new Stool(StoolsModule.stoolEntity, worldIn);
            entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5);
            worldIn.m_7967_((Entity)entity);
            player.m_20329_((Entity)entity);
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)SAT_IN, (Comparable)Boolean.valueOf(true)));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_142072_(Level worldIn, BlockState state, BlockPos pos, Entity entityIn, float fallDistance) {
        super.m_142072_(worldIn, state, pos, entityIn, fallDistance * 0.5f);
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        if (entityIn.m_20162_()) {
            super.m_5548_(worldIn, entityIn);
        } else {
            this.bounceEntity(entityIn);
        }
    }

    private void bounceEntity(Entity entity) {
        Vec3 vector3d = entity.m_20184_();
        if (vector3d.f_82480_ < 0.0) {
            double d0 = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vector3d.f_82479_, -vector3d.f_82480_ * (double)0.66f * d0, vector3d.f_82481_);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)BIG) != false ? SHAPE_BIG : SHAPE;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getStateFor(context.m_43725_(), context.m_8083_());
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        this.fixState(worldIn, pos, state);
    }

    private void fixState(Level worldIn, BlockPos pos, BlockState state) {
        BlockState target = this.getStateFor(worldIn, pos);
        if (!target.equals(state)) {
            worldIn.m_46597_(pos, target);
        }
    }

    private BlockState getStateFor(Level world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_))).m_61124_((Property)BIG, (Comparable)Boolean.valueOf(world.m_8055_(pos.m_7494_()).m_60808_((BlockGetter)world, pos.m_7494_()).m_83288_(Direction.Axis.Y) == 0.0))).m_61124_((Property)SAT_IN, (Comparable)Boolean.valueOf(world.m_6443_(Stool.class, new AABB(pos, pos.m_7494_()).m_82400_(0.4), e -> e.m_142538_().equals((Object)pos)).size() > 0));
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return (Boolean)blockState.m_61143_((Property)SAT_IN) != false ? 15 : 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, BIG, SAT_IN});
    }
}

