/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.building.block;

import it.unimi.dsi.fastutil.floats.Float2ObjectArrayMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;

public class GrateBlock
extends QuarkBlock
implements SimpleWaterloggedBlock {
    private static final VoxelShape TRUE_SHAPE = GrateBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Float2ObjectArrayMap<VoxelShape> WALK_BLOCK_CACHE = new Float2ObjectArrayMap();
    public static BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public GrateBlock(QuarkModule module) {
        super("grate", module, CreativeModeTab.f_40750_, BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, 10.0f).m_60918_(SoundType.f_56743_).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    private static VoxelShape createNewBox(double stepHeight) {
        return GrateBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)(17.0 + 16.0 * stepHeight), (double)16.0);
    }

    public boolean m_49967_() {
        return true;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return TRUE_SHAPE;
    }

    private static VoxelShape getCachedShape(float stepHeight) {
        return (VoxelShape)WALK_BLOCK_CACHE.computeIfAbsent(stepHeight, GrateBlock::createNewBox);
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, CollisionContext context) {
        Entity entity;
        Entity entity2 = entity = context instanceof EntityCollisionContext ? ((EntityCollisionContext)context).m_193113_() : null;
        if (entity != null) {
            if (entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
                return Shapes.m_83040_();
            }
            boolean animal = entity instanceof Animal;
            boolean leashed = animal && ((Animal)entity).m_21524_() != null;
            boolean onGrate = world.m_8055_(entity.m_142538_().m_142082_(0, -1, 0)).m_60734_() instanceof GrateBlock;
            if (animal && !leashed && !onGrate) {
                return GrateBlock.getCachedShape(entity.f_19793_);
            }
            return TRUE_SHAPE;
        }
        return TRUE_SHAPE;
    }

    @Nullable
    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        if (entity instanceof Animal) {
            return BlockPathTypes.DAMAGE_OTHER;
        }
        return null;
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, PathComputationType path) {
        return false;
    }

    public boolean m_7420_(BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }
}

