/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world.generator;

import java.util.BitSet;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.module.config.type.OrePocketConfig;
import vazkii.quark.base.world.generator.Generator;

public class OreGenerator
extends Generator {
    public static final Predicate<BlockState> STONE_MATCHER = state -> {
        if (state == null) {
            return false;
        }
        Block block = state.m_60734_();
        return block == Blocks.f_50069_ || block == Blocks.f_152550_;
    };
    public static final Predicate<BlockState> NETHERRACK_MATCHER = state -> {
        if (state == null) {
            return false;
        }
        Block block = state.m_60734_();
        return block == Blocks.f_50134_;
    };
    public static final Predicate<BlockState> ENDSTONE_MATCHER = state -> {
        if (state == null) {
            return false;
        }
        Block block = state.m_60734_();
        return block == Blocks.f_50259_;
    };
    public static final Predicate<BlockState> ALL_DIMS_STONE_MATCHER = STONE_MATCHER.or(NETHERRACK_MATCHER).or(ENDSTONE_MATCHER);
    private final OrePocketConfig oreConfig;
    private final BlockState placeState;
    private final Predicate<BlockState> matcher;

    public OreGenerator(DimensionConfig dimConfig, OrePocketConfig oreConfig, BlockState placeState, Predicate<BlockState> matcher, BooleanSupplier condition) {
        super(dimConfig, condition);
        this.oreConfig = oreConfig;
        this.placeState = placeState;
        this.matcher = matcher;
    }

    @Override
    public void generateChunk(WorldGenRegion worldIn, ChunkGenerator generator, Random rand, BlockPos pos) {
        this.oreConfig.forEach(pos, rand, npos -> this.place((LevelAccessor)worldIn, rand, (BlockPos)npos));
    }

    public boolean place(LevelAccessor worldIn, Random rand, BlockPos pos) {
        float f = rand.nextFloat() * (float)Math.PI;
        float f1 = (float)this.oreConfig.clusterSize / 8.0f;
        int i = Mth.m_14167_((float)(((float)this.oreConfig.clusterSize / 16.0f * 2.0f + 1.0f) / 2.0f));
        double d0 = (float)pos.m_123341_() + Mth.m_14031_((float)f) * f1;
        double d1 = (float)pos.m_123341_() - Mth.m_14031_((float)f) * f1;
        double d2 = (float)pos.m_123343_() + Mth.m_14089_((float)f) * f1;
        double d3 = (float)pos.m_123343_() - Mth.m_14089_((float)f) * f1;
        double d4 = pos.m_123342_() + rand.nextInt(3) - 2;
        double d5 = pos.m_123342_() + rand.nextInt(3) - 2;
        int k = pos.m_123341_() - Mth.m_14167_((float)f1) - i;
        int l = pos.m_123342_() - 2 - i;
        int i1 = pos.m_123343_() - Mth.m_14167_((float)f1) - i;
        int j1 = 2 * (Mth.m_14167_((float)f1) + i);
        int k1 = 2 * (2 + i);
        Heightmap.Types hm = worldIn instanceof WorldGenRegion ? Heightmap.Types.OCEAN_FLOOR_WG : Heightmap.Types.WORLD_SURFACE;
        for (int l1 = k; l1 <= k + j1; ++l1) {
            for (int i2 = i1; i2 <= i1 + j1; ++i2) {
                if (l > worldIn.m_6924_(hm, l1, i2)) continue;
                return this.doPlace(worldIn, rand, d0, d1, d2, d3, d4, d5, k, l, i1, j1, k1);
            }
        }
        return false;
    }

    protected boolean doPlace(LevelAccessor worldIn, Random random, double p_207803_4_, double p_207803_6_, double p_207803_8_, double p_207803_10_, double p_207803_12_, double p_207803_14_, int p_207803_16_, int p_207803_17_, int p_207803_18_, int p_207803_19_, int p_207803_20_) {
        int i = 0;
        BitSet bitset = new BitSet(p_207803_19_ * p_207803_20_ * p_207803_19_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        double[] adouble = new double[this.oreConfig.clusterSize * 4];
        for (int j = 0; j < this.oreConfig.clusterSize; ++j) {
            float f = (float)j / (float)this.oreConfig.clusterSize;
            double d0 = Mth.m_14139_((double)f, (double)p_207803_4_, (double)p_207803_6_);
            double d2 = Mth.m_14139_((double)f, (double)p_207803_12_, (double)p_207803_14_);
            double d4 = Mth.m_14139_((double)f, (double)p_207803_8_, (double)p_207803_10_);
            double d6 = random.nextDouble() * (double)this.oreConfig.clusterSize / 16.0;
            double d7 = ((double)(Mth.m_14031_((float)((float)Math.PI * f)) + 1.0f) * d6 + 1.0) / 2.0;
            adouble[j * 4 + 0] = d0;
            adouble[j * 4 + 1] = d2;
            adouble[j * 4 + 2] = d4;
            adouble[j * 4 + 3] = d7;
        }
        for (int l2 = 0; l2 < this.oreConfig.clusterSize - 1; ++l2) {
            if (adouble[l2 * 4 + 3] <= 0.0) continue;
            for (int j3 = l2 + 1; j3 < this.oreConfig.clusterSize; ++j3) {
                double d14;
                double d13;
                double d12;
                double d15;
                if (adouble[j3 * 4 + 3] <= 0.0 || !((d15 = adouble[l2 * 4 + 3] - adouble[j3 * 4 + 3]) * d15 > (d12 = adouble[l2 * 4 + 0] - adouble[j3 * 4 + 0]) * d12 + (d13 = adouble[l2 * 4 + 1] - adouble[j3 * 4 + 1]) * d13 + (d14 = adouble[l2 * 4 + 2] - adouble[j3 * 4 + 2]) * d14)) continue;
                if (d15 > 0.0) {
                    adouble[j3 * 4 + 3] = -1.0;
                    continue;
                }
                adouble[l2 * 4 + 3] = -1.0;
            }
        }
        for (int i3 = 0; i3 < this.oreConfig.clusterSize; ++i3) {
            double d11 = adouble[i3 * 4 + 3];
            if (d11 < 0.0) continue;
            double d1 = adouble[i3 * 4 + 0];
            double d3 = adouble[i3 * 4 + 1];
            double d5 = adouble[i3 * 4 + 2];
            int k = Math.max(Mth.m_14107_((double)(d1 - d11)), p_207803_16_);
            int k3 = Math.max(Mth.m_14107_((double)(d3 - d11)), p_207803_17_);
            int l = Math.max(Mth.m_14107_((double)(d5 - d11)), p_207803_18_);
            int i1 = Math.max(Mth.m_14107_((double)(d1 + d11)), k);
            int j1 = Math.max(Mth.m_14107_((double)(d3 + d11)), k3);
            int k1 = Math.max(Mth.m_14107_((double)(d5 + d11)), l);
            for (int l1 = k; l1 <= i1; ++l1) {
                double d8 = ((double)l1 + 0.5 - d1) / d11;
                if (!(d8 * d8 < 1.0)) continue;
                for (int i2 = k3; i2 <= j1; ++i2) {
                    double d9 = ((double)i2 + 0.5 - d3) / d11;
                    if (!(d8 * d8 + d9 * d9 < 1.0)) continue;
                    for (int j2 = l; j2 <= k1; ++j2) {
                        int k2;
                        double d10 = ((double)j2 + 0.5 - d5) / d11;
                        if (!(d8 * d8 + d9 * d9 + d10 * d10 < 1.0) || bitset.get(k2 = l1 - p_207803_16_ + (i2 - p_207803_17_) * p_207803_19_ + (j2 - p_207803_18_) * p_207803_19_ * p_207803_20_)) continue;
                        bitset.set(k2);
                        blockpos$mutableblockpos.m_122178_(l1, i2, j2);
                        if (!this.matcher.test(worldIn.m_8055_((BlockPos)blockpos$mutableblockpos))) continue;
                        worldIn.m_7731_((BlockPos)blockpos$mutableblockpos, this.placeState, 2);
                        ++i;
                    }
                }
            }
        }
        return i > 0;
    }
}

