/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.world.ChunkCornerPlacement;
import vazkii.quark.base.world.DeferedFeature;
import vazkii.quark.base.world.WeightedGenerator;
import vazkii.quark.base.world.generator.IGenerator;

@Mod.EventBusSubscriber(modid="quark")
public class WorldGenHandler {
    private static Map<GenerationStep.Decoration, Feature<NoneFeatureConfiguration>> defersBaseFeature = new HashMap<GenerationStep.Decoration, Feature<NoneFeatureConfiguration>>();
    private static Map<GenerationStep.Decoration, PlacedFeature> defers = new HashMap<GenerationStep.Decoration, PlacedFeature>();
    private static Map<GenerationStep.Decoration, SortedSet<WeightedGenerator>> generators = new HashMap<GenerationStep.Decoration, SortedSet<WeightedGenerator>>();
    public static PlacementModifierType<ChunkCornerPlacement> CHUNK_CORNER_PLACEMENT_TYPE = () -> ChunkCornerPlacement.CODEC;
    public static ChunkCornerPlacement CHUNK_CORNER_PLACEMENT = new ChunkCornerPlacement();

    public static void register() {
        WorldGenHandler.registerFeatures();
    }

    private static void registerFeatures() {
        for (GenerationStep.Decoration stage : GenerationStep.Decoration.values()) {
            DeferedFeature deferredFeature = new DeferedFeature(stage);
            deferredFeature.setRegistryName("quark", "deferred_feature_" + stage.name().toLowerCase(Locale.ENGLISH));
            RegistryHelper.register((IForgeRegistryEntry)deferredFeature);
            defersBaseFeature.put(stage, deferredFeature);
        }
    }

    public static void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            for (GenerationStep.Decoration stage : GenerationStep.Decoration.values()) {
                ConfiguredFeature feature = defersBaseFeature.get(stage).m_65815_((FeatureConfiguration)FeatureConfiguration.f_67737_);
                ResourceLocation resloc = new ResourceLocation("quark", "deferred_feature_" + stage.name().toLowerCase(Locale.ROOT));
                Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)resloc, (Object)feature);
                PlacedFeature placed = feature.m_190823_(new PlacementModifier[]{CHUNK_CORNER_PLACEMENT});
                Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)resloc, (Object)placed);
                defers.put(stage, placed);
            }
            Registry.m_122965_((Registry)Registry.f_194570_, (ResourceLocation)new ResourceLocation("quark", "chunk_corner"), CHUNK_CORNER_PLACEMENT_TYPE);
        });
    }

    @SubscribeEvent
    public static void onBiomesLoaded(BiomeLoadingEvent ev) {
        BiomeGenerationSettingsBuilder settings = ev.getGeneration();
        for (GenerationStep.Decoration stage : GenerationStep.Decoration.values()) {
            List features = settings.getFeatures(stage);
            features.add(() -> defers.get(stage));
        }
    }

    public static void addGenerator(QuarkModule module, IGenerator generator, GenerationStep.Decoration stage, int weight) {
        WeightedGenerator weighted = new WeightedGenerator(module, generator, weight);
        if (!generators.containsKey(stage)) {
            generators.put(stage, new TreeSet());
        }
        generators.get(stage).add(weighted);
    }

    public static void generateChunk(FeaturePlaceContext<NoneFeatureConfiguration> context, GenerationStep.Decoration stage) {
        WorldGenLevel level = context.m_159774_();
        if (!(level instanceof WorldGenRegion)) {
            return;
        }
        ChunkGenerator generator = context.m_159775_();
        BlockPos origin = context.m_159777_();
        BlockPos pos = new BlockPos(origin.m_123341_(), 0, origin.m_123343_());
        WorldGenRegion region = (WorldGenRegion)level;
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(region.m_7328_()));
        ChunkPos center = region.m_143488_();
        long seed = random.m_64690_(region.m_7328_(), center.f_45578_ * 16, center.f_45579_ * 16);
        int stageNum = stage.ordinal() * 10000;
        if (generators.containsKey(stage)) {
            SortedSet<WeightedGenerator> set = generators.get(stage);
            for (WeightedGenerator wgen : set) {
                IGenerator gen = wgen.generator;
                if (!wgen.module.enabled || !gen.canGenerate((ServerLevelAccessor)region)) continue;
                if (GeneralConfig.enableWorldgenWatchdog) {
                    int finalStageNum = stageNum;
                    stageNum = WorldGenHandler.watchdogRun(gen, () -> gen.generate(finalStageNum, seed, stage, region, generator, random, pos), 1, TimeUnit.MINUTES);
                    continue;
                }
                stageNum = gen.generate(stageNum, seed, stage, region, generator, random, pos);
            }
        }
    }

    private static int watchdogRun(IGenerator gen, Callable<Integer> run, int time, TimeUnit unit) {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        Future<Integer> future = exec.submit(run);
        exec.shutdown();
        try {
            return future.get(time, unit);
        }
        catch (Exception e) {
            throw new RuntimeException("Error generating " + gen, e);
        }
    }
}

