/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import vazkii.quark.base.module.config.ConfigFlagManager;

public class FlagIngredient
extends Ingredient {
    private final Ingredient parent;
    private final String flag;

    public FlagIngredient(Ingredient parent, String flag) {
        super(Stream.of(new Ingredient.Value[0]));
        this.parent = parent;
        this.flag = flag;
    }

    private boolean isEnabled() {
        if (Serializer.INSTANCE == null) {
            return false;
        }
        return Serializer.INSTANCE.flagManager.getFlag(this.flag);
    }

    @Nonnull
    public ItemStack[] m_43908_() {
        if (!this.isEnabled()) {
            return new ItemStack[0];
        }
        return this.parent.m_43908_();
    }

    @Nonnull
    public IntList m_43931_() {
        if (!this.isEnabled()) {
            return IntLists.EMPTY_LIST;
        }
        return this.parent.m_43931_();
    }

    public boolean test(@Nullable ItemStack target) {
        if (target == null || !this.isEnabled()) {
            return false;
        }
        return this.parent.test(target);
    }

    protected void invalidate() {
    }

    public boolean isSimple() {
        return this.parent.isSimple();
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<FlagIngredient> {
        public static Serializer INSTANCE;
        private final ConfigFlagManager flagManager;

        public Serializer(ConfigFlagManager flagManager) {
            this.flagManager = flagManager;
            INSTANCE = this;
        }

        @Nonnull
        public FlagIngredient parse(@Nonnull FriendlyByteBuf buffer) {
            return new FlagIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130277_());
        }

        @Nonnull
        public FlagIngredient parse(@Nonnull JsonObject json) {
            Ingredient value = Ingredient.m_43917_((JsonElement)json.get("value"));
            String flag = json.getAsJsonPrimitive("flag").getAsString();
            return new FlagIngredient(value, flag);
        }

        public void write(@Nonnull FriendlyByteBuf buffer, @Nonnull FlagIngredient ingredient) {
            ingredient.parent.m_43923_(buffer);
            buffer.m_130070_(ingredient.flag);
        }
    }
}

