/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import vazkii.quark.base.Quark;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.item.IQuarkItem;
import vazkii.quark.base.module.ModuleFinder;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.ConfigResolver;

public final class ModuleLoader {
    public static final ModuleLoader INSTANCE = new ModuleLoader();
    private Map<Class<? extends QuarkModule>, QuarkModule> foundModules = new HashMap<Class<? extends QuarkModule>, QuarkModule>();
    private ConfigResolver config;
    private boolean clientTicked = false;
    private ParallelDispatchEvent event;

    private ModuleLoader() {
    }

    public void start() {
        this.findModules();
        this.dispatch(QuarkModule::construct);
        this.dispatch(QuarkModule::modulesStarted);
        this.resolveConfigSpec();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        this.dispatch(QuarkModule::constructClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void findModules() {
        ModuleFinder finder = new ModuleFinder();
        finder.findModules();
        this.foundModules = finder.getFoundModules();
    }

    private void resolveConfigSpec() {
        this.config = new ConfigResolver();
        this.config.makeSpec();
    }

    public void configChanged() {
        this.config.configChanged();
        this.dispatch(QuarkModule::configChanged);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void configChangedClient() {
        this.dispatch(QuarkModule::configChangedClient);
    }

    public void setup(ParallelDispatchEvent event) {
        this.event = event;
        this.dispatch(QuarkModule::earlySetup);
        Quark.proxy.handleQuarkConfigChange();
        this.dispatch(QuarkModule::setup);
        event = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(ParallelDispatchEvent event) {
        this.event = event;
        this.dispatch(QuarkModule::clientSetup);
        event = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void modelRegistry() {
        this.dispatch(QuarkModule::modelRegistry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void textureStitch(TextureStitchEvent.Pre event) {
        this.dispatch(m -> m.textureStitch(event));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void postTextureStitch(TextureStitchEvent.Post event) {
        this.dispatch(m -> m.postTextureStitch(event));
    }

    public void loadComplete(ParallelDispatchEvent event) {
        this.event = event;
        this.dispatch(QuarkModule::loadComplete);
        event = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void firstClientTick(TickEvent.ClientTickEvent event) {
        if (!this.clientTicked && event.phase == TickEvent.Phase.END) {
            this.dispatch(m -> m.firstClientTick());
            this.clientTicked = true;
        }
    }

    private void dispatch(Consumer<QuarkModule> run) {
        this.foundModules.values().forEach(run);
    }

    void enqueue(Runnable r) {
        Preconditions.checkNotNull((Object)this.event);
        this.event.enqueueWork(r);
    }

    public boolean isModuleEnabled(Class<? extends QuarkModule> moduleClazz) {
        QuarkModule module = this.getModuleInstance(moduleClazz);
        return module != null && module.enabled;
    }

    public QuarkModule getModuleInstance(Class<? extends QuarkModule> moduleClazz) {
        return this.foundModules.get(moduleClazz);
    }

    public boolean isItemEnabled(Item i) {
        IQuarkBlock qb;
        BlockItem bi;
        Block b;
        IQuarkItem qi;
        return !(i instanceof IQuarkItem ? !(qi = (IQuarkItem)i).isEnabled() : i instanceof BlockItem && (b = (bi = (BlockItem)i).m_40614_()) instanceof IQuarkBlock && !(qb = (IQuarkBlock)b).isEnabled());
    }
}

