/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.arl.util.ItemNBTHelper;

public class ProxiedItemStackHandler
implements IItemHandler,
IItemHandlerModifiable,
ICapabilityProvider {
    protected final ItemStack stack;
    protected final String key;
    protected final int size;

    public ProxiedItemStackHandler(ItemStack stack) {
        this(stack, "Inventory", 1);
    }

    public ProxiedItemStackHandler(ItemStack stack, String key) {
        this(stack, key, 1);
    }

    public ProxiedItemStackHandler(ItemStack stack, int size) {
        this(stack, "Inventory", size);
    }

    public ProxiedItemStackHandler(ItemStack stack, String key, int size) {
        this.stack = stack;
        this.key = key;
        this.size = size;
    }

    private ListTag getStackList() {
        ListTag list = ItemNBTHelper.getList((ItemStack)this.stack, (String)this.key, (int)10, (boolean)true);
        if (list == null) {
            list = new ListTag();
            ItemNBTHelper.setList((ItemStack)this.stack, (String)this.key, (ListTag)list);
        }
        while (list.size() < this.size) {
            list.add((Object)new CompoundTag());
        }
        return list;
    }

    private void writeStack(int index, @Nonnull ItemStack stack) {
        this.getStackList().set(index, (Tag)stack.serializeNBT());
        this.onContentsChanged(index);
    }

    private ItemStack readStack(int index) {
        return ItemStack.m_41712_((CompoundTag)this.getStackList().m_128728_(index));
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.validateSlotIndex(slot);
        this.writeStack(slot, stack);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return this.size;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.readStack(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.readStack(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            this.writeStack(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.readStack(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.writeStack(slot, ItemStack.f_41583_);
            }
            return existing;
        }
        if (!simulate) {
            this.writeStack(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.m_41741_());
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.size) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.size + ")");
        }
    }

    protected void onContentsChanged(int slot) {
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(capability, LazyOptional.of(() -> this));
    }
}

