/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.client.config.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.gui.widget.Slider;
import vazkii.quark.base.client.config.ConfigCategory;
import vazkii.quark.base.client.config.screen.AbstractInputScreen;
import vazkii.quark.base.module.config.type.ColorMatrixConfig;

public class ColorMatrixInputScreen
extends AbstractInputScreen<ColorMatrixConfig> {
    final ColorMatrixConfig color;
    final ColorMatrixConfig mutable;
    final ConfigCategory category;

    public ColorMatrixInputScreen(Screen parent, ColorMatrixConfig colorMatrix, ConfigCategory category) {
        super(parent);
        this.color = colorMatrix;
        this.mutable = colorMatrix.copy();
        this.category = category;
    }

    @Override
    void onInit() {
        int w = 70;
        int p = 12;
        int x = this.f_96543_ / 2 - 33;
        int y = 55;
        TextComponent prefix = new TextComponent("");
        TextComponent suffix = new TextComponent("");
        for (int i = 0; i < 9; ++i) {
            this.m_142416_((GuiEventListener)new Slider(x + w * (i % 3), y + 25 * (i / 3), w - p, 20, (Component)prefix, (Component)suffix, 0.0, 2.0, this.color.colorMatrix[i], false, false, this::onSlide));
        }
        this.m_142416_((GuiEventListener)new Button(x + w * 0, y + 115, w - p, 20, (Component)new TextComponent("Identity"), this::onSlide));
        this.m_142416_((GuiEventListener)new Button(x + w * 1, y + 115, w - p, 20, (Component)new TextComponent("Dreary"), this::onSlide));
        this.m_142416_((GuiEventListener)new Button(x + w * 2, y + 115, w - p, 20, (Component)new TextComponent("Vibrant"), this::onSlide));
    }

    @Override
    public void m_6305_(PoseStack mstack, int mouseX, int mouseY, float pticks) {
        super.m_6305_(mstack, mouseX, mouseY, pticks);
        int x = this.f_96543_ / 2 - 203;
        int y = 10;
        int size = 60;
        int titleLeft = this.f_96543_ / 2 + 66;
        ColorMatrixInputScreen.m_93215_((PoseStack)mstack, (Font)this.f_96547_, (Component)new TextComponent(this.category.getGuiDisplayName()).m_130940_(ChatFormatting.BOLD), (int)titleLeft, (int)20, (int)0xFFFFFF);
        ColorMatrixInputScreen.m_93215_((PoseStack)mstack, (Font)this.f_96547_, (Component)new TextComponent("Presets"), (int)titleLeft, (int)155, (int)0xFFFFFF);
        int sliders = 0;
        boolean needsUpdate = false;
        for (Widget w : this.f_169369_) {
            double val;
            double curr;
            if (!(w instanceof Slider)) continue;
            Slider s = (Slider)w;
            if (mouseX < s.f_93620_ || mouseY < s.f_93621_ || mouseX >= s.f_93620_ + s.m_5711_() || mouseY >= s.f_93621_ + s.m_93694_()) {
                s.dragging = false;
            }
            if ((curr = this.mutable.colorMatrix[sliders]) != (val = this.correct(s))) {
                this.mutable.colorMatrix[sliders] = val;
                needsUpdate = true;
            }
            String displayVal = String.format("%.2f", val);
            this.f_96547_.m_92750_(mstack, displayVal, (float)(s.f_93620_ + s.m_5711_() / 2 - this.f_96547_.m_92895_(displayVal) / 2), (float)(s.f_93621_ + 6), 0xFFFFFF);
            switch (sliders) {
                case 0: {
                    this.f_96547_.m_92750_(mstack, "R =", (float)(s.f_93620_ - 20), (float)(s.f_93621_ + 5), 0xFF0000);
                    this.f_96547_.m_92750_(mstack, "R", (float)(s.f_93620_ + s.m_5711_() / 2 - 2), (float)(s.f_93621_ - 12), 0xFF0000);
                    break;
                }
                case 1: {
                    this.f_96547_.m_92750_(mstack, "G", (float)(s.f_93620_ + s.m_5711_() / 2 - 2), (float)(s.f_93621_ - 12), 65280);
                    break;
                }
                case 2: {
                    this.f_96547_.m_92750_(mstack, "B", (float)(s.f_93620_ + s.m_5711_() / 2 - 2), (float)(s.f_93621_ - 12), 30719);
                    break;
                }
                case 3: {
                    this.f_96547_.m_92750_(mstack, "G =", (float)(s.f_93620_ - 20), (float)(s.f_93621_ + 5), 65280);
                    break;
                }
                case 6: {
                    this.f_96547_.m_92750_(mstack, "B =", (float)(s.f_93620_ - 20), (float)(s.f_93621_ + 5), 30719);
                    break;
                }
            }
            if (sliders % 3 != 0) {
                this.f_96547_.m_92750_(mstack, "+", (float)(s.f_93620_ - 9), (float)(s.f_93621_ + 5), 0xFFFFFF);
            }
            ++sliders;
        }
        String[] biomes = new String[]{"plains", "forest", "mountains", "jungle", "savanna", "swamp"};
        int[] colors = new int[]{-7226023, -8798118, -7686519, -10892996, -4212907, -9801671};
        int[] folliageColors = new int[]{-8934609, -10899920, -9591957, -13583605, -5331926, -9801671};
        for (int i = 0; i < biomes.length; ++i) {
            String name = biomes[i];
            int color = colors[i];
            int folliage = folliageColors[i];
            int convolved = this.mutable.convolve(color);
            int convolvedFolliage = this.mutable.convolve(folliage);
            int cx = x + i % 2 * (size + 5);
            int cy = y + i / 2 * (size + 5);
            ColorMatrixInputScreen.m_93172_((PoseStack)mstack, (int)(cx - 1), (int)(cy - 1), (int)(cx + size + 1), (int)(cy + size + 1), (int)-16777216);
            ColorMatrixInputScreen.m_93172_((PoseStack)mstack, (int)cx, (int)cy, (int)(cx + size), (int)(cy + size), (int)convolved);
            ColorMatrixInputScreen.m_93172_((PoseStack)mstack, (int)(cx + size / 2 - 1), (int)(cy + size / 2 - 1), (int)(cx + size), (int)(cy + size), (int)0x22000000);
            ColorMatrixInputScreen.m_93172_((PoseStack)mstack, (int)(cx + size / 2), (int)(cy + size / 2), (int)(cx + size), (int)(cy + size), (int)convolvedFolliage);
            this.f_96547_.m_92883_(mstack, name, (float)(cx + 2), (float)(cy + 2), 0x55000000);
            this.f_96541_.m_91291_().m_115123_(new ItemStack((ItemLike)Items.f_42799_), cx + size - 18, cy + size - 16);
            mstack.m_85836_();
            mstack.m_85837_(0.0, 0.0, 999.0);
            ColorMatrixInputScreen.m_93172_((PoseStack)mstack, (int)(cx + size / 2), (int)(cy + size / 2), (int)(cx + size), (int)(cy + size), (int)(convolvedFolliage & 0x55FFFFFF));
            mstack.m_85849_();
        }
        if (needsUpdate) {
            this.update();
        }
    }

    private double correct(Slider s) {
        double val = s.getValue();
        val = this.correct(val, 1.0, s);
        val = this.correct(val, 0.5, s);
        val = this.correct(val, 1.5, s);
        return val;
    }

    private double correct(double val, double correct, Slider s) {
        if (Math.abs(val - correct) < 0.02) {
            s.setValue(correct);
            return correct;
        }
        return val;
    }

    @Override
    ColorMatrixConfig compute() {
        return this.mutable;
    }

    void onSlide(Button button) {
        String name = button.m_6035_().getString();
        double[][] matrices = new double[][]{{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0}, {1.24, 0.0, 0.0, 0.0, 0.84, 0.0, 0.0, 0.16, 0.36}, {1.0, 0.0, 0.0, 0.24, 1.0, 0.24, 0.0, 0.0, 0.6}};
        int idx = 0;
        switch (name) {
            case "Dreary": {
                idx = 1;
                break;
            }
            case "Vibrant": {
                idx = 2;
            }
        }
        int sliders = 0;
        this.mutable.colorMatrix = Arrays.copyOf(matrices[idx], matrices[idx].length);
        for (Widget w : this.f_169369_) {
            if (!(w instanceof Slider)) continue;
            Slider s = (Slider)w;
            s.setValue(matrices[idx][sliders]);
            ++sliders;
        }
        this.update();
    }

    @Override
    void setDefault() {
        this.mutable.colorMatrix = Arrays.copyOf(this.color.defaultMatrix, this.color.defaultMatrix.length);
    }

    @Override
    void reset() {
        this.mutable.colorMatrix = Arrays.copyOf(this.mutable.defaultMatrix, this.mutable.defaultMatrix.length);
    }

    @Override
    boolean isErrored() {
        return false;
    }

    @Override
    boolean isDirty() {
        return !this.color.equals(this.mutable);
    }

    @Override
    void commit() {
        this.color.inherit(this.mutable);
    }
}

