/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.capability;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.quark.addons.oddities.capability.Force;
import vazkii.quark.api.IMagnetTracker;

public class MagnetTracker
implements IMagnetTracker {
    private final Multimap<BlockPos, Force> forcesActing = HashMultimap.create();
    private final Level world;

    public MagnetTracker(Level world) {
        this.world = world;
    }

    @Override
    public Vec3i getNetForce(BlockPos pos) {
        Vec3i net = Vec3i.f_123288_;
        for (Force force : this.forcesActing.get((Object)pos)) {
            net = force.add(net);
        }
        return net;
    }

    @Override
    public void applyForce(BlockPos pos, int magnitude, boolean pushing, Direction dir, int distance, BlockPos origin) {
        this.forcesActing.put((Object)pos, (Object)new Force(magnitude, pushing, dir, distance, origin));
    }

    @Override
    public void actOnForces(BlockPos pos) {
        Vec3i net = this.getNetForce(pos);
        if (net.equals((Object)Vec3i.f_123288_)) {
            return;
        }
        Direction target = Direction.m_122372_((float)net.m_123341_(), (float)net.m_123342_(), (float)net.m_123343_());
        for (Force force : this.forcesActing.get((Object)pos)) {
            if (force.getDirection() != target) continue;
            BlockState origin = this.world.m_8055_(force.getOrigin());
            this.world.m_7696_(force.getOrigin(), origin.m_60734_(), force.isPushing() ? 0 : 1, force.getDistance());
        }
    }

    @Override
    public Collection<BlockPos> getTrackedPositions() {
        return this.forcesActing.keySet();
    }

    @Override
    public void clear() {
        this.forcesActing.clear();
    }
}

