/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.addons.oddities.block.MovingMagnetizedBlock;
import vazkii.quark.addons.oddities.block.be.MagnetBlockEntity;
import vazkii.quark.addons.oddities.block.be.MagnetizedBlockBlockEntity;
import vazkii.quark.addons.oddities.magnetsystem.MagnetSystem;
import vazkii.quark.addons.oddities.module.MagnetsModule;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.module.QuarkModule;

public class MagnetBlock
extends QuarkBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public MagnetBlock(QuarkModule module) {
        super("magnet", module, CreativeModeTab.f_40751_, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50075_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        if (stack.m_41786_().m_6111_().equals("Q")) {
            tooltip.add((Component)new TextComponent("haha yes"));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        boolean wasPowered = (Boolean)state.m_61143_((Property)POWERED);
        boolean isPowered = this.isPowered(worldIn, pos, (Direction)state.m_61143_((Property)FACING));
        if (isPowered != wasPowered) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)));
        }
    }

    public boolean m_8133_(BlockState state, Level world, BlockPos pos, int action, int data) {
        boolean push = action == 0;
        Direction moveDir = (Direction)state.m_61143_((Property)FACING);
        Direction dir = push ? moveDir : moveDir.m_122424_();
        BlockPos targetPos = pos.m_5484_(dir, data);
        BlockState targetState = world.m_8055_(targetPos);
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof MagnetBlockEntity)) {
            return false;
        }
        BlockPos endPos = targetPos.m_142300_(moveDir);
        PushReaction reaction = MagnetSystem.getPushAction((MagnetBlockEntity)tile, targetPos, targetState, moveDir);
        if (reaction != PushReaction.IGNORE && reaction != PushReaction.DESTROY) {
            return false;
        }
        BlockEntity tilePresent = world.m_7702_(targetPos);
        CompoundTag tileData = new CompoundTag();
        if (tilePresent != null && !(tilePresent instanceof MagnetizedBlockBlockEntity)) {
            tileData = tilePresent.m_187480_();
        }
        BlockState setState = (BlockState)MagnetsModule.magnetized_block.m_49966_().m_61124_((Property)MovingMagnetizedBlock.FACING, (Comparable)moveDir);
        MagnetizedBlockBlockEntity movingTile = new MagnetizedBlockBlockEntity(endPos, setState, targetState, tileData, moveDir);
        if (!world.f_46443_ && reaction == PushReaction.DESTROY) {
            BlockState blockstate = world.m_8055_(endPos);
            Block.m_49892_((BlockState)blockstate, (LevelAccessor)world, (BlockPos)endPos, (BlockEntity)tilePresent);
        }
        if (tilePresent != null) {
            tilePresent.m_7651_();
        }
        world.m_7731_(endPos, setState, 68);
        world.m_151523_((BlockEntity)movingTile);
        world.m_7731_(targetPos, Blocks.f_50016_.m_49966_(), 66);
        return true;
    }

    private boolean isPowered(Level worldIn, BlockPos pos, Direction facing) {
        Direction opp = facing.m_122424_();
        for (Direction direction : Direction.values()) {
            if (direction == facing || direction == opp || !worldIn.m_46616_(pos.m_142300_(direction), direction)) continue;
            return true;
        }
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_7820_().m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(this.isPowered(context.m_43725_(), context.m_8083_(), facing)));
    }

    @Nonnull
    public BlockState m_6843_(@Nonnull BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(@Nonnull BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MagnetBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return MagnetBlock.createTickerHelper(type, MagnetsModule.magnetType, MagnetBlockEntity::tick);
    }
}

