/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.catalogue.client.screen;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mrcrayfish.catalogue.Catalogue;
import com.mrcrayfish.catalogue.client.ScreenUtil;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueCheckBoxButton;
import com.mrcrayfish.catalogue.client.screen.widget.CatalogueIconButton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.common.util.Size2i;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.resource.PathResourcePack;
import net.minecraftforge.resource.ResourcePackLoader;
import org.apache.commons.lang3.tuple.Pair;

public class CatalogueModListScreen
extends Screen {
    private static final Comparator<ModEntry> SORT = Comparator.comparing(o -> o.getInfo().getDisplayName());
    private static final ResourceLocation MISSING_BANNER = new ResourceLocation("catalogue", "textures/gui/missing_banner.png");
    private static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private static final Map<String, Pair<ResourceLocation, Size2i>> LOGO_CACHE = new HashMap<String, Pair<ResourceLocation, Size2i>>();
    private static final Map<String, Pair<ResourceLocation, Size2i>> ICON_CACHE = new HashMap<String, Pair<ResourceLocation, Size2i>>();
    private static final Map<String, ItemStack> ITEM_CACHE = new HashMap<String, ItemStack>();
    private EditBox searchTextField;
    private ModList modList;
    private IModInfo selectedModInfo;
    private Button modFolderButton;
    private Button configButton;
    private Button websiteButton;
    private Button issueButton;
    private Checkbox updatesButton;
    private StringList descriptionList;
    private int tooltipYOffset;
    private List<? extends FormattedCharSequence> activeTooltip;

    public CatalogueModListScreen() {
        super(TextComponent.f_131282_);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchTextField = new EditBox(this.f_96547_, 11, 25, 148, 20, TextComponent.f_131282_);
        this.searchTextField.m_94151_(s -> {
            this.updateSearchField((String)s);
            this.modList.filterAndUpdateList((String)s);
            this.updateSelectedModList();
        });
        this.m_7787_((GuiEventListener)this.searchTextField);
        this.modList = new ModList();
        this.modList.m_93507_(10);
        this.modList.m_93496_(false);
        this.m_7787_((GuiEventListener)this.modList);
        this.m_142416_((GuiEventListener)new Button(10, this.modList.getBottom() + 8, 127, 20, CommonComponents.f_130660_, onPress -> this.getMinecraft().m_91152_(null)));
        this.modFolderButton = (Button)this.m_142416_((GuiEventListener)new CatalogueIconButton(140, this.modList.getBottom() + 8, 0, 0, onPress -> Util.m_137581_().m_137644_(FMLPaths.MODSDIR.get().toFile())));
        int padding = 10;
        int contentLeft = this.modList.getRight() + 12 + padding;
        int contentWidth = this.f_96543_ - contentLeft - padding;
        int buttonWidth = (contentWidth - padding) / 3;
        this.configButton = (Button)this.m_142416_((GuiEventListener)new CatalogueIconButton(contentLeft, 105, 10, 0, buttonWidth, (Component)new TranslatableComponent("fml.menu.mods.config"), onPress -> {
            if (this.selectedModInfo != null) {
                ConfigGuiHandler.getGuiFactoryFor((IModInfo)this.selectedModInfo).map(f -> (Screen)f.apply(this.f_96541_, this)).ifPresent(newScreen -> this.getMinecraft().m_91152_(newScreen));
            }
        }));
        this.configButton.f_93624_ = false;
        this.websiteButton = (Button)this.m_142416_((GuiEventListener)new CatalogueIconButton(contentLeft + buttonWidth + 5, 105, 20, 0, buttonWidth, (Component)new TextComponent("Website"), onPress -> this.openLink("displayURL", (IConfigurable)this.selectedModInfo)));
        this.websiteButton.f_93624_ = false;
        this.issueButton = (Button)this.m_142416_((GuiEventListener)new CatalogueIconButton(contentLeft + buttonWidth + buttonWidth + 10, 105, 30, 0, buttonWidth, (Component)new TextComponent("Submit Bug"), onPress -> this.openLink("issueTrackerURL", (IConfigurable)(this.selectedModInfo != null ? (ModFileInfo)this.selectedModInfo.getOwningFile() : null))));
        this.issueButton.f_93624_ = false;
        this.descriptionList = new StringList(contentWidth, this.f_96544_ - 135 - 55, contentLeft, 130);
        this.descriptionList.m_93496_(false);
        this.descriptionList.m_93488_(false);
        this.m_7787_((GuiEventListener)this.descriptionList);
        this.updatesButton = (Checkbox)this.m_142416_((GuiEventListener)new CatalogueCheckBoxButton(this.modList.getRight() - 14, 7, button -> {
            this.modList.filterAndUpdateList(this.searchTextField.m_94155_());
            this.updateSelectedModList();
        }));
        this.modList.filterAndUpdateList(this.searchTextField.m_94155_());
        if (this.selectedModInfo != null) {
            this.setSelectedModInfo(this.selectedModInfo);
            this.updateSelectedModList();
            ModEntry entry = this.modList.getEntryFromInfo(this.selectedModInfo);
            if (entry != null) {
                this.modList.centerScrollOn(entry);
            }
        }
        this.updateSearchField(this.searchTextField.m_94155_());
    }

    private void openLink(String key, @Nullable IConfigurable configurable) {
        if (configurable != null) {
            configurable.getConfigElement(new String[]{key}).ifPresent(o -> this.openLink(o.toString()));
        }
    }

    private void openLink(String url) {
        Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        this.m_5561_(style);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.activeTooltip = null;
        this.m_7333_(poseStack);
        this.drawModList(poseStack, mouseX, mouseY, partialTicks);
        this.drawModInfo(poseStack, mouseX, mouseY, partialTicks);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        Optional optional = net.minecraftforge.fml.ModList.get().getModContainerById("catalogue");
        optional.ifPresent(container -> this.loadAndCacheLogo(container.getModInfo()));
        Pair<ResourceLocation, Size2i> pair = LOGO_CACHE.get("catalogue");
        if (pair != null && pair.getLeft() != null) {
            ResourceLocation textureId = (ResourceLocation)pair.getLeft();
            Size2i size = (Size2i)pair.getRight();
            RenderSystem.m_157456_((int)0, (ResourceLocation)textureId);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Screen.m_93160_((PoseStack)poseStack, (int)10, (int)9, (int)10, (int)10, (float)0.0f, (float)0.0f, (int)size.width, (int)size.height, (int)size.width, (int)size.height);
        }
        if (ScreenUtil.isMouseWithin(10, 9, 10, 10, mouseX, mouseY)) {
            this.setActiveTooltip(new TranslatableComponent("catalogue.gui.info").getString());
            this.tooltipYOffset = 10;
        }
        if (this.modFolderButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.setActiveTooltip(new TranslatableComponent("fml.button.open.mods.folder").getString());
        }
        if (this.activeTooltip != null) {
            this.renderTooltip(poseStack, this.activeTooltip, mouseX, mouseY + this.tooltipYOffset, this.f_96547_);
            this.tooltipYOffset = 0;
        }
    }

    private void updateSelectedModList() {
        ModEntry selectedEntry = this.modList.getEntryFromInfo(this.selectedModInfo);
        if (selectedEntry != null) {
            this.modList.m_6987_(selectedEntry);
        }
    }

    private void updateSearchField(String value) {
        if (value.isEmpty()) {
            this.searchTextField.m_94167_(new TranslatableComponent("fml.menu.mods.search").m_7220_((Component)new TextComponent("...")).getString());
        } else {
            Optional<IModInfo> optional = net.minecraftforge.fml.ModList.get().getMods().stream().filter(info -> info.getDisplayName().toLowerCase(Locale.ENGLISH).startsWith(value.toLowerCase(Locale.ENGLISH))).min(Comparator.comparing(IModInfo::getDisplayName));
            if (optional.isPresent()) {
                int length = value.length();
                String displayName = optional.get().getDisplayName();
                this.searchTextField.m_94167_(displayName.substring(length));
            } else {
                this.searchTextField.m_94167_("");
            }
        }
    }

    private void drawModList(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172814_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)VERSION_CHECK_ICONS);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CatalogueModListScreen.m_93133_((PoseStack)poseStack, (int)(this.modList.getRight() - 24), (int)10, (float)24.0f, (float)0.0f, (int)8, (int)8, (int)64, (int)16);
        this.modList.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        CatalogueModListScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TextComponent(ForgeI18n.parseMessage((String)"fml.menu.mods.title", (Object[])new Object[0])).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.WHITE), (int)70, (int)10, (int)0xFFFFFF);
        this.searchTextField.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        if (ScreenUtil.isMouseWithin(this.modList.getRight() - 14, 7, 14, 14, mouseX, mouseY)) {
            this.setActiveTooltip(I18n.m_118938_((String)"fml.menu.mods.filter_updates", (Object[])new Object[0]));
            this.tooltipYOffset = 10;
        }
    }

    private void drawModInfo(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_93222_(poseStack, this.modList.getRight() + 11, -1, this.f_96544_, -9408400);
        CatalogueModListScreen.m_93172_((PoseStack)poseStack, (int)(this.modList.getRight() + 12), (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)0x66000000);
        this.descriptionList.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        int contentLeft = this.modList.getRight() + 12 + 10;
        int contentWidth = this.f_96543_ - contentLeft - 10;
        if (this.selectedModInfo != null) {
            Optional authors;
            this.drawLogo(poseStack, contentWidth, contentLeft, 10, this.f_96543_ - (this.modList.getRight() + 12 + 10) - 10, 50);
            poseStack.m_85836_();
            poseStack.m_85837_((double)contentLeft, 70.0, 0.0);
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            CatalogueModListScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.selectedModInfo.getDisplayName(), (int)0, (int)0, (int)0xFFFFFF);
            poseStack.m_85849_();
            MutableComponent modId = new TextComponent("Mod ID: " + this.selectedModInfo.getModId()).m_130940_(ChatFormatting.DARK_GRAY);
            int modIdWidth = this.f_96547_.m_92852_((FormattedText)modId);
            CatalogueModListScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)modId, (int)(contentLeft + contentWidth - modIdWidth), (int)92, (int)0xFFFFFF);
            this.drawStringWithLabel(poseStack, "fml.menu.mods.info.version", this.selectedModInfo.getVersion().toString(), contentLeft, 92, contentWidth, mouseX, mouseY, ChatFormatting.GRAY, ChatFormatting.WHITE);
            VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)this.selectedModInfo);
            if (result.status().shouldDraw() && result.url() != null) {
                String version = ForgeI18n.parseMessage((String)"fml.menu.mods.info.version", (Object[])new Object[]{this.selectedModInfo.getVersion().toString()});
                int versionWidth = this.f_96547_.m_92895_(version);
                RenderSystem.m_157427_(GameRenderer::m_172814_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)VERSION_CHECK_ICONS);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int vOffset = result.status().isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8 : 0;
                Screen.m_93133_((PoseStack)poseStack, (int)(contentLeft + versionWidth + 5), (int)92, (float)(result.status().getSheetOffset() * 8), (float)vOffset, (int)8, (int)8, (int)64, (int)16);
                if (ScreenUtil.isMouseWithin(contentLeft + versionWidth + 5, 92, 8, 8, mouseX, mouseY)) {
                    this.setActiveTooltip(ForgeI18n.parseMessage((String)"fml.menu.mods.info.updateavailable", (Object[])new Object[]{result.url()}));
                }
            }
            int labelOffset = this.f_96544_ - 20;
            String license = this.selectedModInfo.getOwningFile().getLicense();
            this.drawStringWithLabel(poseStack, "fml.menu.mods.info.license", license, contentLeft, labelOffset, contentWidth, mouseX, mouseY, ChatFormatting.GRAY, ChatFormatting.WHITE);
            labelOffset -= 15;
            Optional credits = ((ModInfo)this.selectedModInfo).getConfigElement(new String[]{"credits"});
            if (credits.isPresent()) {
                this.drawStringWithLabel(poseStack, "fml.menu.mods.info.credits", credits.get().toString(), contentLeft, labelOffset, contentWidth, mouseX, mouseY, ChatFormatting.GRAY, ChatFormatting.WHITE);
                labelOffset -= 15;
            }
            if ((authors = ((ModInfo)this.selectedModInfo).getConfigElement(new String[]{"authors"})).isPresent()) {
                this.drawStringWithLabel(poseStack, "fml.menu.mods.info.authors", authors.get().toString(), contentLeft, labelOffset, contentWidth, mouseX, mouseY, ChatFormatting.GRAY, ChatFormatting.WHITE);
            }
        } else {
            MutableComponent message = new TranslatableComponent("catalogue.gui.no_selection").m_130940_(ChatFormatting.GRAY);
            CatalogueModListScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)message, (int)(contentLeft + contentWidth / 2), (int)(this.f_96544_ / 2 - 5), (int)0xFFFFFF);
        }
    }

    private void drawStringWithLabel(PoseStack poseStack, String format, String text, int x, int y, int maxWidth, int mouseX, int mouseY, ChatFormatting labelColor, ChatFormatting contentColor) {
        String formatted = ForgeI18n.parseMessage((String)format, (Object[])new Object[]{text});
        String label = formatted.substring(0, formatted.indexOf(":") + 1);
        Object content = formatted.substring(formatted.indexOf(":") + 1);
        if (this.f_96547_.m_92895_(formatted) > maxWidth) {
            content = this.f_96547_.m_92834_((String)content, maxWidth - this.f_96547_.m_92895_(label) - 7) + "...";
            MutableComponent credits = new TextComponent(label).m_130940_(labelColor);
            credits.m_7220_((Component)new TextComponent((String)content).m_130940_(contentColor));
            CatalogueModListScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)credits, (int)x, (int)y, (int)0xFFFFFF);
            if (ScreenUtil.isMouseWithin(x, y, maxWidth, 9, mouseX, mouseY)) {
                this.setActiveTooltip(text);
            }
        } else {
            CatalogueModListScreen.m_93243_((PoseStack)poseStack, (Font)this.f_96547_, (Component)new TextComponent(label).m_130940_(labelColor).m_7220_((Component)new TextComponent((String)content).m_130940_(contentColor)), (int)x, (int)y, (int)0xFFFFFF);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        VersionChecker.CheckResult result;
        String version;
        int versionWidth;
        int contentLeft;
        if (ScreenUtil.isMouseWithin(10, 9, 10, 10, (int)mouseX, (int)mouseY) && button == 0) {
            this.openLink("https://www.curseforge.com/minecraft/mc-mods/catalogue");
            return true;
        }
        if (this.selectedModInfo != null && ScreenUtil.isMouseWithin((contentLeft = this.modList.getRight() + 12 + 10) + (versionWidth = this.f_96547_.m_92895_(version = ForgeI18n.parseMessage((String)"fml.menu.mods.info.version", (Object[])new Object[]{this.selectedModInfo.getVersion().toString()}))) + 5, 92, 8, 8, (int)mouseX, (int)mouseY) && (result = VersionChecker.getResult((IModInfo)this.selectedModInfo)).status().shouldDraw() && result.url() != null) {
            Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, result.url()));
            this.m_5561_(style);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private void setActiveTooltip(String content) {
        this.activeTooltip = this.f_96547_.m_92923_((FormattedText)new TextComponent(content), Math.min(200, this.f_96543_));
        this.tooltipYOffset = 0;
    }

    private void setSelectedModInfo(IModInfo selectedModInfo) {
        this.selectedModInfo = selectedModInfo;
        this.loadAndCacheLogo(selectedModInfo);
        this.configButton.f_93624_ = true;
        this.websiteButton.f_93624_ = true;
        this.issueButton.f_93624_ = true;
        this.configButton.f_93623_ = ConfigGuiHandler.getGuiFactoryFor((IModInfo)selectedModInfo).isPresent();
        this.websiteButton.f_93623_ = ((ModInfo)selectedModInfo).getConfigElement(new String[]{"displayURL"}).isPresent();
        this.issueButton.f_93623_ = ((ModInfo)selectedModInfo).getOwningFile().getConfigElement(new String[]{"issueTrackerURL"}).isPresent();
        int contentLeft = this.modList.getRight() + 12 + 10;
        int contentWidth = this.f_96543_ - contentLeft - 10;
        int labelCount = this.getLabelCount(selectedModInfo);
        this.descriptionList.m_93437_(contentWidth, this.f_96544_ - 135 - 10 - labelCount * 15, 130, this.f_96544_ - 10 - labelCount * 15);
        this.descriptionList.m_93507_(contentLeft);
        this.descriptionList.setTextFromInfo(selectedModInfo);
        this.descriptionList.m_93410_(0.0);
    }

    private int getLabelCount(IModInfo selectedModInfo) {
        int count = 1;
        if (((ModInfo)selectedModInfo).getConfigElement(new String[]{"credits"}).isPresent()) {
            ++count;
        }
        if (((ModInfo)selectedModInfo).getConfigElement(new String[]{"authors"}).isPresent()) {
            ++count;
        }
        return count;
    }

    private void drawLogo(PoseStack poseStack, int contentWidth, int x, int y, int maxWidth, int maxHeight) {
        if (this.selectedModInfo != null) {
            Pair<ResourceLocation, Size2i> logoInfo;
            ResourceLocation logoResource = MISSING_BANNER;
            Size2i size = new Size2i(600, 120);
            if (LOGO_CACHE.containsKey(this.selectedModInfo.getModId()) && (logoInfo = LOGO_CACHE.get(this.selectedModInfo.getModId())).getLeft() != null) {
                logoResource = (ResourceLocation)logoInfo.getLeft();
                size = (Size2i)logoInfo.getRight();
            }
            RenderSystem.m_157427_(GameRenderer::m_172814_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)logoResource);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int width = size.width;
            int height = size.height;
            if (size.width > maxWidth) {
                width = maxWidth;
                height = width * size.height / size.width;
            }
            if (height > maxHeight) {
                height = maxHeight;
                width = height * size.width / size.height;
            }
            Screen.m_93160_((PoseStack)poseStack, (int)(x += (contentWidth - width) / 2), (int)(y += (maxHeight - height) / 2), (int)width, (int)height, (float)0.0f, (float)0.0f, (int)size.width, (int)size.height, (int)size.width, (int)size.height);
        }
    }

    private void loadAndCacheLogo(IModInfo info) {
        if (LOGO_CACHE.containsKey(info.getModId())) {
            return;
        }
        LOGO_CACHE.put(info.getModId(), (Pair<ResourceLocation, Size2i>)Pair.of(null, (Object)new Size2i(0, 0)));
        ModInfo modInfo = (ModInfo)info;
        modInfo.getLogoFile().ifPresent(s -> {
            if (s.isEmpty()) {
                return;
            }
            if (s.contains("/") || s.contains("\\")) {
                Catalogue.LOGGER.warn("Skipped loading logo file from {}. The file name '{}' contained illegal characters '/' or '\\'", (Object)info.getDisplayName(), s);
                return;
            }
            PathResourcePack resourcePack = ResourcePackLoader.getPackFor((String)info.getModId()).orElse((PathResourcePack)ResourcePackLoader.getPackFor((String)"forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
            try (InputStream is = resourcePack.m_5542_(s);
                 NativeImage logo = NativeImage.m_85058_((InputStream)is);){
                TextureManager textureManager = this.getMinecraft().m_91097_();
                LOGO_CACHE.put(info.getModId(), (Pair<ResourceLocation, Size2i>)Pair.of((Object)textureManager.m_118490_("modlogo", this.createLogoTexture(logo, modInfo.getLogoBlur())), (Object)new Size2i(logo.m_84982_(), logo.m_85084_())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private void loadAndCacheIcon(IModInfo info) {
        if (ICON_CACHE.containsKey(info.getModId())) {
            return;
        }
        ICON_CACHE.put(info.getModId(), (Pair<ResourceLocation, Size2i>)Pair.of(null, (Object)new Size2i(0, 0)));
        ModInfo modInfo = (ModInfo)info;
        if (modInfo.getModProperties().containsKey("catalogueImageIcon")) {
            String s2 = (String)modInfo.getModProperties().get("catalogueImageIcon");
            if (s2.isEmpty()) {
                return;
            }
            if (s2.contains("/") || s2.contains("\\")) {
                Catalogue.LOGGER.warn("Skipped loading Catalogue icon file from {}. The file name '{}' contained illegal characters '/' or '\\'", (Object)info.getDisplayName(), (Object)s2);
                return;
            }
            PathResourcePack resourcePack = ResourcePackLoader.getPackFor((String)info.getModId()).orElse((PathResourcePack)ResourcePackLoader.getPackFor((String)"forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
            try (InputStream is = resourcePack.m_5542_(s2);){
                block18: {
                    NativeImage icon = NativeImage.m_85058_((InputStream)is);
                    try {
                        TextureManager textureManager = this.getMinecraft().m_91097_();
                        ICON_CACHE.put(info.getModId(), (Pair<ResourceLocation, Size2i>)Pair.of((Object)textureManager.m_118490_("catalogueicon", this.createLogoTexture(icon, false)), (Object)new Size2i(icon.m_84982_(), icon.m_85084_())));
                        if (icon == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (icon != null) {
                            try {
                                icon.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    icon.close();
                }
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        modInfo.getLogoFile().ifPresent(s -> {
            if (s.isEmpty()) {
                return;
            }
            if (s.contains("/") || s.contains("\\")) {
                Catalogue.LOGGER.warn("Skipped loading logo file from {}. The file name '{}' contained illegal characters '/' or '\\'", (Object)info.getDisplayName(), s);
                return;
            }
            PathResourcePack resourcePack = ResourcePackLoader.getPackFor((String)info.getModId()).orElse((PathResourcePack)ResourcePackLoader.getPackFor((String)"forge").orElseThrow(() -> new RuntimeException("Can't find forge, WHAT!")));
            try (InputStream is = resourcePack.m_5542_(s);
                 NativeImage logo = NativeImage.m_85058_((InputStream)is);){
                if (logo.m_84982_() == logo.m_85084_()) {
                    TextureManager textureManager = this.getMinecraft().m_91097_();
                    String modId = info.getModId();
                    if (LOGO_CACHE.containsKey(modId) && LOGO_CACHE.get(modId).getLeft() != null) {
                        ICON_CACHE.put(modId, LOGO_CACHE.get(modId));
                        return;
                    }
                    DynamicTexture texture = this.createLogoTexture(logo, modInfo.getLogoBlur());
                    Size2i size = new Size2i(logo.m_84982_(), logo.m_85084_());
                    ResourceLocation textureId = textureManager.m_118490_("catalogueicon", texture);
                    ICON_CACHE.put(modId, (Pair<ResourceLocation, Size2i>)Pair.of((Object)textureId, (Object)size));
                    LOGO_CACHE.put(modId, (Pair<ResourceLocation, Size2i>)Pair.of((Object)textureId, (Object)size));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    private DynamicTexture createLogoTexture(final NativeImage image, final boolean smooth) {
        return new DynamicTexture(image){

            public void m_117985_() {
                this.m_117966_();
                image.m_85013_(0, 0, 0, 0, 0, image.m_84982_(), image.m_85084_(), smooth, false, false, false);
            }
        };
    }

    private class ModList
    extends AbstractSelectionList<ModEntry> {
        public ModList() {
            super(CatalogueModListScreen.this.f_96541_, 150, CatalogueModListScreen.this.f_96544_, 46, CatalogueModListScreen.this.f_96544_ - 35, 26);
        }

        protected int m_5756_() {
            return super.getLeft() + this.f_93388_ - 6;
        }

        public int m_5747_() {
            return super.getLeft();
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        public void filterAndUpdateList(String text) {
            List entries = net.minecraftforge.fml.ModList.get().getMods().stream().filter(info -> info.getDisplayName().toLowerCase(Locale.ENGLISH).contains(text.toLowerCase(Locale.ENGLISH))).filter(info -> !CatalogueModListScreen.this.updatesButton.m_93840_() || VersionChecker.getResult((IModInfo)info).status().shouldDraw()).map(info -> new ModEntry((IModInfo)info, this)).sorted(SORT).collect(Collectors.toList());
            this.m_5988_(entries);
            this.m_93410_(0.0);
        }

        @Nullable
        public ModEntry getEntryFromInfo(IModInfo info) {
            return this.m_6702_().stream().filter(entry -> entry.info == info).findFirst().orElse(null);
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            ScreenUtil.scissor(this.m_5747_(), this.getTop(), this.getWidth(), this.getBottom() - this.getTop());
            super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            RenderSystem.m_69471_();
        }

        public boolean m_7933_(int key, int scanCode, int modifiers) {
            if (key == 257 && this.m_93511_() != null) {
                CatalogueModListScreen.this.setSelectedModInfo(((ModEntry)this.m_93511_()).info);
                SoundManager handler = Minecraft.m_91087_().m_91106_();
                handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            return super.m_7933_(key, scanCode, modifiers);
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }

        public void centerScrollOn(ModEntry entry) {
            super.m_93494_((AbstractSelectionList.Entry)entry);
        }
    }

    private class StringList
    extends AbstractSelectionList<StringEntry> {
        public StringList(int width, int height, int left, int top) {
            super(CatalogueModListScreen.this.f_96541_, width, CatalogueModListScreen.this.f_96544_, top, top + height, 10);
            this.m_93507_(left);
        }

        public void setTextFromInfo(IModInfo info) {
            this.m_93516_();
            CatalogueModListScreen.this.f_96547_.m_92865_().m_92432_(info.getDescription().trim(), this.m_5759_(), Style.f_131099_).forEach(text -> this.m_7085_(new StringEntry(text.getString().replace("\n", "").replace("\r", "").trim())));
        }

        public void setSelected(@Nullable StringEntry entry) {
        }

        protected int m_5756_() {
            return this.getLeft() + this.f_93388_ - 7;
        }

        public int m_5747_() {
            return this.getLeft();
        }

        public int m_5759_() {
            return this.f_93388_ - 10;
        }

        public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            ScreenUtil.scissor(this.m_5747_(), this.getTop(), this.getWidth(), this.getBottom() - this.getTop());
            super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            RenderSystem.m_69471_();
        }

        public void m_142291_(NarrationElementOutput p_169152_) {
        }
    }

    private class ModEntry
    extends AbstractSelectionList.Entry<ModEntry> {
        private final IModInfo info;
        private final ModList list;

        public ModEntry(IModInfo info, ModList list) {
            this.info = info;
            this.list = list;
        }

        public void m_6311_(PoseStack poseStack, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            GuiComponent.m_93243_((PoseStack)poseStack, (Font)CatalogueModListScreen.this.f_96547_, (Component)this.getFormattedModName(), (int)(left + 24), (int)(top + 2), (int)0xFFFFFF);
            GuiComponent.m_93243_((PoseStack)poseStack, (Font)CatalogueModListScreen.this.f_96547_, (Component)new TextComponent(this.info.getVersion().toString()).m_130940_(ChatFormatting.GRAY), (int)(left + 24), (int)(top + 12), (int)0xFFFFFF);
            CatalogueModListScreen.this.loadAndCacheIcon(this.info);
            if (ICON_CACHE.containsKey(this.info.getModId()) && ICON_CACHE.get(this.info.getModId()).getLeft() != null) {
                ResourceLocation logoResource = TextureManager.f_118466_;
                Size2i size = new Size2i(16, 16);
                Pair<ResourceLocation, Size2i> logoInfo = ICON_CACHE.get(this.info.getModId());
                if (logoInfo != null && logoInfo.getLeft() != null) {
                    logoResource = (ResourceLocation)logoInfo.getLeft();
                    size = (Size2i)logoInfo.getRight();
                }
                RenderSystem.m_157427_(GameRenderer::m_172814_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)logoResource);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Screen.m_93160_((PoseStack)poseStack, (int)(left + 4), (int)(top + 2), (int)16, (int)16, (float)0.0f, (float)0.0f, (int)size.width, (int)size.height, (int)size.width, (int)size.height);
            } else {
                CatalogueModListScreen.this.getMinecraft().m_91291_().m_115123_(this.getItemIcon(), left + 4, top + 2);
            }
            VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)this.info);
            if (result.status().shouldDraw()) {
                RenderSystem.m_157427_(GameRenderer::m_172814_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)VERSION_CHECK_ICONS);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int vOffset = result.status().isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8 : 0;
                Screen.m_93133_((PoseStack)poseStack, (int)(left + rowWidth - 8 - 10), (int)(top + 6), (float)(result.status().getSheetOffset() * 8), (float)vOffset, (int)8, (int)8, (int)64, (int)16);
            }
        }

        private ItemStack getItemIcon() {
            ItemStack item2;
            Optional<ItemStack> optional;
            if (ITEM_CACHE.containsKey(this.info.getModId())) {
                return ITEM_CACHE.get(this.info.getModId());
            }
            ITEM_CACHE.put(this.info.getModId(), new ItemStack((ItemLike)Items.f_42276_));
            if (this.info.getModId().equals("forge")) {
                ItemStack item3 = new ItemStack((ItemLike)Items.f_42146_);
                ITEM_CACHE.put("forge", item3);
                return item3;
            }
            String itemIcon = (String)this.info.getModProperties().get("catalogueItemIcon");
            if (itemIcon == null) {
                itemIcon = ((ModInfo)this.info).getConfigElement(new String[]{"itemIcon"}).orElse("");
            }
            if (!itemIcon.isEmpty()) {
                try {
                    ItemParser parser = new ItemParser(new StringReader(itemIcon), false).m_121032_();
                    ItemStack item4 = new ItemStack((ItemLike)parser.m_121014_(), 1, parser.m_121018_());
                    ITEM_CACHE.put(this.info.getModId(), item4);
                    return item4;
                }
                catch (CommandSyntaxException parser) {
                    // empty catch block
                }
            }
            if ((optional = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.getRegistryName().m_135827_().equals(this.info.getModId())).map(ItemStack::new).findFirst()).isPresent() && (item2 = optional.get()).m_41720_() != Items.f_41852_) {
                ITEM_CACHE.put(this.info.getModId(), item2);
                return item2;
            }
            return new ItemStack((ItemLike)Items.f_42276_);
        }

        private Component getFormattedModName() {
            Object name = this.info.getDisplayName();
            int width = this.list.m_5759_() - (this.list.m_93518_() > 0 ? 30 : 24);
            if (CatalogueModListScreen.this.f_96547_.m_92895_((String)name) > width) {
                name = CatalogueModListScreen.this.f_96547_.m_92834_((String)name, width - 10) + "...";
            }
            TextComponent title = new TextComponent((String)name);
            if (this.info.getModId().equals("forge") || this.info.getModId().equals("minecraft")) {
                title.m_130940_(ChatFormatting.DARK_GRAY);
            }
            return title;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            CatalogueModListScreen.this.setSelectedModInfo(this.info);
            this.list.m_6987_(this);
            return false;
        }

        public IModInfo getInfo() {
            return this.info;
        }
    }

    private class StringEntry
    extends AbstractSelectionList.Entry<StringEntry> {
        private String line;

        public StringEntry(String line) {
            this.line = line;
        }

        public void m_6311_(PoseStack poseStack, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            GuiComponent.m_93236_((PoseStack)poseStack, (Font)CatalogueModListScreen.this.f_96547_, (String)this.line, (int)left, (int)top, (int)0xFFFFFF);
        }
    }
}

