/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.engine;

import com.simibubi.create.content.contraptions.components.flywheel.FlywheelBlock;
import com.simibubi.create.content.contraptions.components.flywheel.FlywheelTileEntity;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineBlock;
import com.simibubi.create.content.contraptions.components.flywheel.engine.EngineTileEntity;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.teammoeg.steampowered.FluidRegistry;
import com.teammoeg.steampowered.content.engine.SteamEngineBlock;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class SteamEngineTileEntity
extends EngineTileEntity
implements IHaveGoggleInformation {
    private FluidTank tank;
    private LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    private int heatup = 0;

    public SteamEngineTileEntity(BlockEntityType<? extends SteamEngineTileEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.refreshCapability();
        this.tank = new FluidTank(this.getSteamStorage(), fluidStack -> {
            Tag steamTag = FluidTags.m_144299_().m_13404_(new ResourceLocation("forge", "steam"));
            if (steamTag != null) {
                return fluidStack.getFluid().m_76108_(steamTag);
            }
            return fluidStack.getFluid() == FluidRegistry.steam.get();
        });
    }

    public void tick() {
        super.tick();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (this.poweredWheel == null || this.poweredWheel.m_58901_()) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(false)));
                this.refreshWheelSpeed();
                this.heatup = 0;
                this.tank.drain(this.getSteamConsumptionPerTick(), IFluidHandler.FluidAction.EXECUTE);
            } else if (!this.tank.isEmpty() && this.tank.drain(this.getSteamConsumptionPerTick(), IFluidHandler.FluidAction.EXECUTE).getAmount() >= this.getSteamConsumptionPerTick()) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(true)));
                if (this.heatup >= 60) {
                    this.appliedCapacity = this.getGeneratingCapacity();
                    this.appliedSpeed = this.getGeneratingSpeed();
                    this.refreshWheelSpeed();
                } else {
                    ++this.heatup;
                }
            } else {
                if (this.heatup > 0) {
                    --this.heatup;
                }
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)SteamEngineBlock.LIT, (Comparable)Boolean.valueOf(false)));
                this.appliedCapacity = 0.0f;
                this.appliedSpeed = 0.0f;
                this.refreshWheelSpeed();
            }
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!((Boolean)this.m_58900_().m_61143_((Property)SteamEngineBlock.LIT)).booleanValue()) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("tooltip.steampowered.steam_engine.not_enough_steam").m_130940_(ChatFormatting.RED)));
        } else if (this.heatup < 60) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("tooltip.steampowered.steam_engine.heating").m_130940_(ChatFormatting.YELLOW)));
        } else {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)new TranslatableComponent("tooltip.steampowered.steam_engine.running").m_130940_(ChatFormatting.GREEN)));
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tank.readFromNBT(compound.m_128469_("TankContent"));
        this.heatup = compound.m_128451_("heatup");
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("TankContent", (net.minecraft.nbt.Tag)this.tank.writeToNBT(new CompoundTag()));
        compound.m_128405_("heatup", this.heatup);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!this.holder.isPresent()) {
            this.refreshCapability();
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.holder.cast() : super.getCapability(capability, facing);
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.holder;
        this.holder = LazyOptional.of(() -> this.tank);
        oldCap.invalidate();
    }

    public void attachWheel() {
        BlockEntity te;
        Direction wheelFacing;
        Direction engineFacing = (Direction)this.m_58900_().m_61143_((Property)EngineBlock.f_54117_);
        BlockPos wheelPos = this.f_58858_.m_5484_(engineFacing, 2);
        BlockState wheelState = this.f_58857_.m_8055_(wheelPos);
        if (!(this.getFlywheel() != wheelState.m_60734_() || (wheelFacing = (Direction)wheelState.m_61143_(FlywheelBlock.HORIZONTAL_FACING)).m_122434_() != engineFacing.m_122427_().m_122434_() || FlywheelBlock.isConnected((BlockState)wheelState) && FlywheelBlock.getConnection((BlockState)wheelState) != engineFacing.m_122424_() || (te = this.f_58857_.m_7702_(wheelPos)).m_58901_() || !(te instanceof FlywheelTileEntity))) {
            if (!FlywheelBlock.isConnected((BlockState)wheelState)) {
                FlywheelBlock.setConnection((Level)this.f_58857_, (BlockPos)te.m_58899_(), (BlockState)te.m_58900_(), (Direction)engineFacing.m_122424_());
            }
            this.poweredWheel = (FlywheelTileEntity)te;
            this.refreshWheelSpeed();
        }
    }

    public abstract Block getFlywheel();

    public abstract float getGeneratingCapacity();

    public abstract float getGeneratingSpeed();

    public abstract int getSteamConsumptionPerTick();

    public abstract int getSteamStorage();
}

