/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.burner;

import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.teammoeg.steampowered.client.ClientUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class BurnerBlock
extends Block {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty REDSTONE_LOCKED = BooleanProperty.m_61465_((String)"redstone_locked");

    public BurnerBlock(BlockBehaviour.Properties props) {
        super(props.m_60953_(s -> (Boolean)s.m_61143_((Property)LIT) != false ? 10 : 0));
    }

    public void m_7100_(BlockState bs, Level w, BlockPos bp, Random r) {
        super.m_7100_(bs, w, bp, r);
        if (((Boolean)bs.m_61143_((Property)LIT)).booleanValue()) {
            double d0 = (double)bp.m_123341_() + 0.5;
            double d1 = bp.m_123342_();
            double d2 = (double)bp.m_123343_() + 0.5;
            if (r.nextDouble() < 0.2) {
                w.m_7785_(d0, d1, d2, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            if (r.nextDouble() < 0.5) {
                Direction direction = (Direction)bs.m_61143_((Property)FACING);
                Direction.Axis direction$axis = direction.m_122434_();
                double d4 = w.m_5822_().nextDouble() * 0.6 - 0.3;
                double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
                double d6 = w.m_5822_().nextDouble() * 6.0 / 16.0;
                double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
                w.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                w.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_43719_();
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(facing.m_122434_().m_122478_() ? context.m_8125_().m_122424_() : facing))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)REDSTONE_LOCKED, (Comparable)Boolean.valueOf(false));
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue() && pEntity instanceof LivingEntity) {
            pEntity.m_6469_(DamageSource.f_19309_, 2.0f);
        }
    }

    public abstract int getHuProduce();

    public abstract double getEfficiency();

    public String getEfficiencyString() {
        return (float)((int)(this.getEfficiency() * 1000.0)) / 10.0f + "%";
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{LIT}).m_61104_(new Property[]{FACING}).m_61104_(new Property[]{REDSTONE_LOCKED}));
    }

    public void m_5871_(ItemStack i, BlockGetter w, List<Component> t, TooltipFlag f) {
        if (Screen.m_96638_()) {
            t.add((Component)new TranslatableComponent("tooltip.steampowered.burner.brief").m_130940_(ChatFormatting.GOLD));
            if (ClientUtils.hasGoggles()) {
                t.add((Component)new TranslatableComponent("tooltip.steampowered.burner.efficiency", new Object[]{this.getEfficiencyString()}).m_130940_(ChatFormatting.RED));
                t.add((Component)new TranslatableComponent("tooltip.steampowered.burner.huproduce", new Object[]{this.getHuProduce()}).m_130940_(ChatFormatting.GOLD));
                t.add((Component)new TranslatableComponent("tooltip.steampowered.burner.danger").m_130940_(ChatFormatting.RED));
            }
        } else {
            t.add((Component)TooltipHelper.holdShift((ItemDescription.Palette)ItemDescription.Palette.Gray, (boolean)false));
        }
        if (Screen.m_96637_()) {
            t.add((Component)new TranslatableComponent("tooltip.steampowered.burner.redstone").m_130940_(ChatFormatting.RED));
        } else {
            t.add((Component)Lang.translate((String)"tooltip.holdForControls", (Object[])new Object[]{Lang.translate((String)"tooltip.keyCtrl", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        super.m_5871_(i, w, t, f);
    }

    public InteractionResult m_6227_(BlockState bs, Level w, BlockPos bp, Player pe, InteractionHand h, BlockHitResult br) {
        if (pe.m_21120_(h).m_41619_()) {
            IItemHandler cap = (IItemHandler)w.m_7702_(bp).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get();
            ItemStack is = cap.getStackInSlot(0);
            if (!is.m_41619_()) {
                pe.m_21008_(h, cap.extractItem(0, is.m_41613_(), false));
                return InteractionResult.SUCCESS;
            }
        } else if (ForgeHooks.getBurnTime((ItemStack)pe.m_21120_(h), (RecipeType)RecipeType.f_44109_) != 0 && pe.m_21120_(h).getContainerItem().m_41619_()) {
            IItemHandler cap = (IItemHandler)w.m_7702_(bp).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).resolve().get();
            pe.m_21008_(h, cap.insertItem(0, pe.m_21120_(h), false));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        boolean isLocked;
        if (!world.f_46443_ && (isLocked = ((Boolean)state.m_61143_((Property)REDSTONE_LOCKED)).booleanValue()) != world.m_46753_(pos)) {
            if (isLocked) {
                world.m_186460_(pos, (Block)this, 4);
            } else {
                world.m_7731_(pos, (BlockState)state.m_61122_((Property)REDSTONE_LOCKED), 2);
            }
        }
    }

    public void m_7458_(BlockState state, ServerLevel serverworld, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)REDSTONE_LOCKED)).booleanValue() && !serverworld.m_46753_(pos)) {
            serverworld.m_7731_(pos, (BlockState)state.m_61122_((Property)REDSTONE_LOCKED), 2);
        }
    }
}

