/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.boiler;

import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.teammoeg.steampowered.FluidRegistry;
import com.teammoeg.steampowered.SPConfig;
import com.teammoeg.steampowered.content.burner.IHeatReceiver;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class BoilerTileEntity
extends SmartTileEntity
implements IHeatReceiver,
IHaveGoggleInformation {
    FluidTank input = new FluidTank(10000, s -> s.getFluid() == Fluids.f_76193_);
    FluidTank output = new FluidTank(10000);
    private IFluidHandler ft = new IFluidHandler(){

        public int getTanks() {
            return 2;
        }

        public FluidStack getFluidInTank(int tank) {
            switch (tank) {
                case 0: {
                    return BoilerTileEntity.this.input.getFluid();
                }
                case 1: {
                    return BoilerTileEntity.this.output.getFluid();
                }
            }
            return null;
        }

        public int getTankCapacity(int tank) {
            return 10000;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return tank == 0 && stack.getFluid() == Fluids.f_76193_;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return BoilerTileEntity.this.input.fill(resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return BoilerTileEntity.this.output.drain(resource, action);
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return BoilerTileEntity.this.output.drain(maxDrain, action);
        }
    };
    int heatreceived;
    int lastheat;
    private LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.ft);

    public BoilerTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        nbt.m_128365_("in", (Tag)this.input.writeToNBT(new CompoundTag()));
        nbt.m_128365_("out", (Tag)this.output.writeToNBT(new CompoundTag()));
        nbt.m_128405_("hu", this.heatreceived);
        nbt.m_128405_("lasthu", this.lastheat);
        super.write(nbt, clientPacket);
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        this.input.readFromNBT(nbt.m_128469_("in"));
        this.output.readFromNBT(nbt.m_128469_("out"));
        this.heatreceived = nbt.m_128451_("hu");
        this.lastheat = nbt.m_128451_("lasthu");
        super.read(nbt, clientPacket);
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean flag = false;
            if (this.lastheat != this.heatreceived) {
                flag = true;
            }
            this.lastheat = this.heatreceived;
            if (this.heatreceived != 0) {
                int consume = Math.min(this.getHUPerTick(), this.heatreceived);
                this.heatreceived = 0;
                double waterconsume = (Double)SPConfig.COMMON.steamPerWater.get() * 10.0;
                consume = Math.min((int)((double)this.input.drain((int)Math.ceil((double)consume / waterconsume), IFluidHandler.FluidAction.EXECUTE).getAmount() * waterconsume), consume);
                this.output.fill(new FluidStack((Fluid)FluidRegistry.steam.get(), consume / 10), IFluidHandler.FluidAction.EXECUTE);
                flag = true;
            }
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Override
    public void commitHeat(float value) {
        this.heatreceived = (int)value;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        this.containedFluidTooltip(tooltip, isPlayerSneaking, LazyOptional.of(() -> this.input));
        this.containedFluidTooltip(tooltip, isPlayerSneaking, LazyOptional.of(() -> this.output));
        return true;
    }

    protected abstract int getHUPerTick();

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.holder.isPresent()) {
            this.refreshCapability();
        }
        return cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this.holder.cast() : super.getCapability(cap, side);
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.holder;
        this.holder = LazyOptional.of(() -> this.ft);
        oldCap.invalidate();
    }
}

