/*
 * Decompiled with CFR 0.152.
 */
package com.teammoeg.steampowered.content.boiler;

import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.teammoeg.steampowered.client.ClientUtils;
import com.teammoeg.steampowered.client.Particles;
import com.teammoeg.steampowered.content.boiler.BoilerTileEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class BoilerBlock
extends Block
implements LiquidBlockContainer {
    public boolean m_6044_(BlockGetter w, BlockPos p, BlockState s, Fluid f) {
        BlockEntity te = w.m_7702_(p);
        if (te instanceof BoilerTileEntity) {
            BoilerTileEntity boiler = (BoilerTileEntity)te;
            if (boiler.input.fill(new FluidStack(f, 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                return true;
            }
        }
        return false;
    }

    public boolean m_7361_(LevelAccessor w, BlockPos p, BlockState s, FluidState f) {
        BlockEntity te = w.m_7702_(p);
        if (te instanceof BoilerTileEntity) {
            BoilerTileEntity boiler = (BoilerTileEntity)te;
            if (boiler.input.fill(new FluidStack(f.m_76152_(), 1000), IFluidHandler.FluidAction.SIMULATE) == 1000) {
                boiler.input.fill(new FluidStack(f.m_76152_(), 1000), IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
        }
        return false;
    }

    public void m_7100_(BlockState p_180655_1_, Level p_180655_2_, BlockPos p_180655_3_, Random p_180655_4_) {
        BlockEntity te = p_180655_2_.m_7702_(p_180655_3_);
        if (te instanceof BoilerTileEntity) {
            BoilerTileEntity boiler = (BoilerTileEntity)te;
            if (boiler.output.getFluidAmount() >= 10000 && boiler.lastheat != 0) {
                double d0 = p_180655_3_.m_123341_();
                double d1 = p_180655_3_.m_123342_() + 1;
                double d2 = p_180655_3_.m_123343_();
                p_180655_2_.m_7785_(d0, d1, d2, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.25f, 0.25f, false);
                int count = 4;
                while (--count != 0) {
                    p_180655_2_.m_7106_((ParticleOptions)Particles.STEAM.get(), d0 + (double)p_180655_4_.nextFloat(), d1, d2 + (double)p_180655_4_.nextFloat(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean m_7278_(BlockState p_149740_1_) {
        return true;
    }

    public BoilerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public int m_6782_(BlockState b, Level w, BlockPos p) {
        BlockEntity te = w.m_7702_(p);
        if (te instanceof BoilerTileEntity) {
            BoilerTileEntity boiler = (BoilerTileEntity)te;
            return boiler.output.getFluidAmount() * 15 / boiler.output.getCapacity();
        }
        return super.m_6782_(b, w, p);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public abstract int getHuConsume();

    public void m_5871_(ItemStack i, BlockGetter w, List<Component> t, TooltipFlag f) {
        if (Screen.m_96638_()) {
            t.add((Component)new TranslatableComponent("tooltip.steampowered.boiler.brief").m_130940_(ChatFormatting.GOLD));
            if (ClientUtils.hasGoggles()) {
                t.add((Component)new TranslatableComponent("tooltip.steampowered.boiler.danger").m_130940_(ChatFormatting.RED));
                t.add((Component)new TranslatableComponent("tooltip.steampowered.boiler.huconsume", new Object[]{this.getHuConsume()}).m_130940_(ChatFormatting.GOLD));
                t.add((Component)new TranslatableComponent("tooltip.steampowered.boiler.waterconsume", new Object[]{(int)Math.ceil((double)this.getHuConsume() / 120.0)}).m_130940_(ChatFormatting.AQUA));
                t.add((Component)new TranslatableComponent("tooltip.steampowered.boiler.steamproduce", new Object[]{this.getHuConsume() / 10}).m_130940_(ChatFormatting.GOLD));
            }
        } else {
            t.add((Component)TooltipHelper.holdShift((ItemDescription.Palette)ItemDescription.Palette.Gray, (boolean)false));
        }
        if (Screen.m_96637_()) {
            t.add((Component)new TranslatableComponent("tooltip.steampowered.boiler.redstone").m_130940_(ChatFormatting.RED));
        } else {
            t.add((Component)Lang.translate((String)"tooltip.holdForControls", (Object[])new Object[]{Lang.translate((String)"tooltip.keyCtrl", (Object[])new Object[0]).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.DARK_GRAY));
        }
        super.m_5871_(i, w, t, f);
    }

    public void stepOn(Level w, BlockPos bp, Entity e) {
        BlockEntity te = w.m_7702_(bp);
        if (te instanceof BoilerTileEntity && e instanceof LivingEntity && (((BoilerTileEntity)te).lastheat > 0 || !((BoilerTileEntity)te).output.isEmpty())) {
            e.m_6469_(DamageSource.f_19309_, 2.0f);
        }
    }
}

